/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonServerOptions;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.amqp.connect.MockServer;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ValidateAMQPErrorsTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    private static final Logger logger = Logger.getLogger(ValidateAMQPErrorsTest.class);
    protected Vertx vertx;
    protected MockServer mockServer;

    public void startVerx() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void stop() throws Exception {
        if (this.mockServer != null) {
            this.mockServer.close();
            this.mockServer = null;
        }
        if (this.vertx != null) {
            try {
                CountDownLatch latch = new CountDownLatch(1);
                this.vertx.close(x -> latch.countDown());
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            }
            finally {
                this.vertx = null;
            }
        }
        AssertionLoggerHandler.stopCapture();
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testConnectItself() throws Exception {
        try {
            AssertionLoggerHandler.startCapture();
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(10).setRetryInterval(1);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            Assert.assertEquals((long)1L, (long)this.server.getBrokerConnections().size());
            this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((BrokerConnection)t).isStarted()));
            Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ111001"}));
            AssertionLoggerHandler.clear();
            Thread.sleep(100L);
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ111002"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ111003"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseLinkOnMirror() throws Exception {
        try {
            int i;
            Session session;
            AssertionLoggerHandler.startCapture();
            ActiveMQServer server2 = this.createServer(5673, false);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5673").setReconnectAttempts(-1).setRetryInterval(10);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            Assert.assertEquals((long)1L, (long)this.server.getBrokerConnections().size());
            Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ111002"}));
            this.server.getBrokerConnections().forEach(t -> Wait.assertTrue(() -> ((AMQPBrokerConnection)t).isConnecting()));
            server2.start();
            this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((AMQPBrokerConnection)t).isConnecting()));
            this.createAddressAndQueues(this.server);
            Wait.assertTrue(() -> server2.locateQueue(this.getQueueName()) != null);
            Wait.assertEquals((int)1, () -> ((RemotingService)server2.getRemotingService()).getConnectionCount());
            server2.getRemotingService().getConnections().forEach(t -> {
                try {
                    ActiveMQProtonRemotingConnection connection = (ActiveMQProtonRemotingConnection)t;
                    ConnectionImpl protonConnection = (ConnectionImpl)connection.getAmqpConnection().getHandler().getConnection();
                    Wait.waitFor(() -> protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE)) != null);
                    connection.getAmqpConnection().runNow(() -> {
                        Receiver receiver = (Receiver)protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE));
                        receiver.close();
                        connection.flush();
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
            try (Connection connection = cf1.createConnection();){
                session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
                for (i = 0; i < 10; ++i) {
                    producer.send((Message)session.createTextMessage("message " + i));
                }
            }
            connection = cf2.createConnection();
            var6_6 = null;
            try {
                session = connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
                connection.start();
                for (i = 0; i < 10; ++i) {
                    Assert.assertEquals((Object)("message " + i), (Object)((TextMessage)consumer.receive(5000L)).getText());
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var6_6 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Test
    public void testCloseLinkOnSender() throws Exception {
        this.testCloseLink(true);
    }

    @Test
    public void testCloseLinkOnReceiver() throws Exception {
        this.testCloseLink(false);
    }

    public void testCloseLink(boolean isSender) throws Exception {
        int i;
        Session session;
        AMQPBrokerConnectConfiguration amqpConnection;
        AtomicInteger errors = new AtomicInteger(0);
        AssertionLoggerHandler.startCapture((boolean)true);
        ActiveMQServer server2 = this.createServer(5673, false);
        if (isSender) {
            amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5673").setReconnectAttempts(-1).setRetryInterval(10);
            amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.SENDER));
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
        } else {
            amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(10);
            amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.RECEIVER));
            server2.getConfiguration().addAMQPConnection(amqpConnection);
        }
        if (isSender) {
            this.server.start();
            Assert.assertEquals((long)1L, (long)this.server.getBrokerConnections().size());
        } else {
            server2.start();
            Assert.assertEquals((long)1L, (long)server2.getBrokerConnections().size());
        }
        Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ111002"}));
        this.server.getBrokerConnections().forEach(t -> Wait.assertTrue(() -> ((AMQPBrokerConnection)t).isConnecting()));
        if (isSender) {
            server2.start();
        } else {
            this.server.start();
        }
        this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((AMQPBrokerConnection)t).isConnecting()));
        this.createAddressAndQueues(this.server);
        this.createAddressAndQueues(server2);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> server2.locateQueue(this.getQueueName()) != null);
        ActiveMQServer serverReceivingConnections = isSender ? server2 : this.server;
        Wait.assertEquals((int)1, () -> ((RemotingService)serverReceivingConnections.getRemotingService()).getConnectionCount());
        serverReceivingConnections.getRemotingService().getConnections().forEach(t -> {
            try {
                ActiveMQProtonRemotingConnection connection = (ActiveMQProtonRemotingConnection)t;
                ConnectionImpl protonConnection = (ConnectionImpl)connection.getAmqpConnection().getHandler().getConnection();
                Wait.waitFor(() -> protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE)) != null);
                connection.getAmqpConnection().runNow(() -> {
                    Link theLink = protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE));
                    theLink.close();
                    connection.flush();
                });
            }
            catch (Exception e) {
                errors.incrementAndGet();
                e.printStackTrace();
            }
        });
        Wait.assertEquals((int)1, () -> AssertionLoggerHandler.countText((String[])new String[]{"AMQ119021"}));
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connection = cf1.createConnection();){
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            for (i = 0; i < 10; ++i) {
                producer.send((Message)session.createTextMessage("message " + i));
            }
        }
        connection = cf2.createConnection();
        var8_8 = null;
        try {
            session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            connection.start();
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)("message " + i), (Object)((TextMessage)consumer.receive(5000L)).getText());
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var8_8 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    @Test
    public void testTimeoutOnSenderOpen() throws Exception {
        this.startVerx();
        ProtonServerOptions serverOptions = new ProtonServerOptions();
        this.mockServer = new MockServer(this.vertx, serverOptions, null, (Handler<ProtonConnection>)((Handler)serverConnection -> {
            serverConnection.openHandler(serverSender -> {
                serverConnection.closeHandler(x -> serverConnection.close());
                serverConnection.open();
            });
            serverConnection.sessionOpenHandler(s -> s.open());
            serverConnection.senderOpenHandler(x -> x.open());
            serverConnection.receiverOpenHandler(x -> {});
        }));
        try {
            AssertionLoggerHandler.startCapture((boolean)true);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:" + this.mockServer.actualPort() + "?connect-timeout-millis=20").setReconnectAttempts(5).setRetryInterval(10);
            amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.SENDER));
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ111001"}));
            Wait.assertEquals((int)6, () -> AssertionLoggerHandler.countText((String[])new String[]{"AMQ119020"}));
        }
        finally {
            this.mockServer.close();
        }
    }

    @Test
    public void testReconnectAfterSenderOpenTimeout() throws Exception {
        this.startVerx();
        AssertionLoggerHandler.startCapture((boolean)true);
        ProtonServerOptions serverOptions = new ProtonServerOptions();
        AtomicInteger countOpen = new AtomicInteger(0);
        CyclicBarrier startFlag = new CyclicBarrier(2);
        CountDownLatch blockBeforeOpen = new CountDownLatch(1);
        AtomicInteger disconnects = new AtomicInteger(0);
        AtomicInteger messagesReceived = new AtomicInteger(0);
        AtomicInteger errors = new AtomicInteger(0);
        ConcurrentHashSet connections = new ConcurrentHashSet();
        this.mockServer = new MockServer(this.vertx, serverOptions, null, (Handler<ProtonConnection>)((Handler)serverConnection -> {
            serverConnection.disconnectHandler(c -> {
                disconnects.incrementAndGet();
                connections.remove(c);
            });
            serverConnection.openHandler(serverSender -> {
                serverConnection.closeHandler(x -> {
                    serverConnection.close();
                    connections.remove(serverConnection);
                });
                serverConnection.open();
                connections.add(serverConnection);
            });
            serverConnection.sessionOpenHandler(s -> s.open());
            serverConnection.senderOpenHandler(x -> x.open());
            serverConnection.receiverOpenHandler(x -> {
                if (countOpen.incrementAndGet() > 2) {
                    if (countOpen.get() == 3) {
                        try {
                            startFlag.await(10L, TimeUnit.SECONDS);
                            blockBeforeOpen.await(10L, TimeUnit.SECONDS);
                            return;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    HashMap<Symbol, String> brokerIDProperties = new HashMap<Symbol, String>();
                    brokerIDProperties.put(AMQPMirrorControllerSource.BROKER_ID, "fake-id");
                    x.setProperties(brokerIDProperties);
                    x.setOfferedCapabilities(new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY});
                    x.setTarget(x.getRemoteTarget());
                    x.open();
                    x.handler((del, msg) -> {
                        Map map;
                        Object value;
                        if (msg.getApplicationProperties() != null && (value = (map = msg.getApplicationProperties().getValue()).get("sender")) != null) {
                            if (messagesReceived.get() != ((Integer)value).intValue()) {
                                logger.warn((Object)("Message out of order. Expected " + messagesReceived.get() + " but received " + value));
                                errors.incrementAndGet();
                            }
                            messagesReceived.incrementAndGet();
                        }
                    });
                }
            });
        }));
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:" + this.mockServer.actualPort() + "?connect-timeout-millis=1000").setReconnectAttempts(10).setRetryInterval(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        startFlag.await(10L, TimeUnit.SECONDS);
        blockBeforeOpen.countDown();
        Wait.assertEquals((int)2, disconnects::intValue);
        Wait.assertEquals((int)1, () -> ((ConcurrentHashSet)connections).size());
        Wait.assertEquals((int)3, () -> AssertionLoggerHandler.countText((String[])new String[]{"AMQ119020"}));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            for (int i = 0; i < 100; ++i) {
                TextMessage message = session.createTextMessage("hello");
                message.setIntProperty("sender", i);
                producer.send((Message)message);
            }
        }
        Wait.assertEquals((int)100, messagesReceived::intValue, (long)5000L);
        Assert.assertEquals((float)0.0f, (float)errors.get(), (float)5000.0f);
    }

    @Test
    public void testNoServerOfferedMirrorCapability() throws Exception {
        this.startVerx();
        this.mockServer = new MockServer(this.vertx, (Handler<ProtonConnection>)((Handler)serverConnection -> {
            serverConnection.openHandler(serverSender -> serverConnection.open());
            serverConnection.sessionOpenHandler(s -> s.open());
            serverConnection.senderOpenHandler(x -> x.open());
            serverConnection.receiverOpenHandler(x -> {
                x.setTarget(x.getRemoteTarget());
                x.open();
            });
        }));
        AssertionLoggerHandler.startCapture((boolean)true);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:" + this.mockServer.actualPort() + "?connect-timeout-millis=100").setReconnectAttempts(5).setRetryInterval(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ111001"}));
        Assert.assertEquals((long)6L, (long)AssertionLoggerHandler.countText((String[])new String[]{"AMQ119018"}));
    }

    @Test
    public void testReconnectAfterMirrorLinkRefusal() throws Exception {
        this.startVerx();
        AtomicInteger errors = new AtomicInteger(0);
        AtomicInteger messagesReceived = new AtomicInteger(0);
        List connections = Collections.synchronizedList(new ArrayList());
        List disconnected = Collections.synchronizedList(new ArrayList());
        AtomicInteger refusedLinkMessageCount = new AtomicInteger();
        AtomicInteger linkOpens = new AtomicInteger(0);
        this.mockServer = new MockServer(this.vertx, (Handler<ProtonConnection>)((Handler)serverConnection -> {
            serverConnection.disconnectHandler(c -> disconnected.add(serverConnection));
            serverConnection.openHandler(c -> {
                connections.add(serverConnection);
                serverConnection.open();
            });
            serverConnection.closeHandler(c -> {
                serverConnection.close();
                connections.remove(serverConnection);
            });
            serverConnection.sessionOpenHandler(session -> session.open());
            serverConnection.receiverOpenHandler(serverReceiver -> {
                String remoteAddress;
                Target remoteTarget = serverReceiver.getRemoteTarget();
                String string = remoteAddress = remoteTarget == null ? null : remoteTarget.getAddress();
                if (remoteAddress == null || !remoteAddress.startsWith("$ACTIVEMQ_ARTEMIS_MIRROR")) {
                    errors.incrementAndGet();
                    logger.warn((Object)("Receiving address as " + remoteAddress));
                    return;
                }
                if (linkOpens.incrementAndGet() != 2) {
                    logger.debug((Object)("Link Opens::" + linkOpens));
                    logger.debug((Object)("ServerReceiver = " + serverReceiver.getTarget()));
                    serverReceiver.setTarget(null);
                    serverReceiver.handler((del, msg) -> {
                        refusedLinkMessageCount.incrementAndGet();
                        logger.debug((Object)("Should not have got message on refused link: " + msg));
                    });
                    serverReceiver.open();
                    this.vertx.setTimer(20L, x -> {
                        serverReceiver.setCondition(new ErrorCondition(AmqpError.ILLEGAL_STATE, "Testing refusal of mirror link for $reasons"));
                        serverReceiver.close();
                    });
                } else {
                    serverReceiver.setTarget(serverReceiver.getRemoteTarget());
                    HashMap<Symbol, String> linkProperties = new HashMap<Symbol, String>();
                    linkProperties.put(AMQPMirrorControllerSource.BROKER_ID, "fake-id");
                    serverReceiver.setProperties(linkProperties);
                    serverReceiver.setOfferedCapabilities(new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY});
                    serverReceiver.handler((del, msg) -> {
                        Map map;
                        Object value;
                        logger.debug((Object)("prefetch = " + serverReceiver.getPrefetch() + ", Got message: " + msg));
                        if (msg.getApplicationProperties() != null && (value = (map = msg.getApplicationProperties().getValue()).get("sender")) != null) {
                            if (messagesReceived.get() != ((Integer)value).intValue()) {
                                logger.warn((Object)("Message out of order. Expected " + messagesReceived.get() + " but received " + value));
                                errors.incrementAndGet();
                            }
                            messagesReceived.incrementAndGet();
                        }
                        del.disposition((DeliveryState)Accepted.getInstance(), true);
                        if (serverReceiver.getPrefetch() == 0) {
                            serverReceiver.flow(1);
                        }
                    });
                    serverReceiver.open();
                }
            });
        }));
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:" + this.mockServer.actualPort()).setReconnectAttempts(3).setRetryInterval(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Wait.assertEquals((int)1, disconnected::size, (long)6000L);
        Wait.assertEquals((int)2, connections::size, (long)6000L);
        ValidateAMQPErrorsTest.assertSame(connections.get(0), disconnected.get(0));
        ValidateAMQPErrorsTest.assertFalse((boolean)((ProtonConnection)connections.get(1)).isDisconnected());
        ValidateAMQPErrorsTest.assertEquals((String)"Should not have got any message on refused link", (long)0L, (long)refusedLinkMessageCount.get());
        ValidateAMQPErrorsTest.assertEquals((long)0L, (long)errors.get());
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            for (int i = 0; i < 100; ++i) {
                TextMessage message = session.createTextMessage("hello");
                message.setIntProperty("sender", i);
                producer.send((Message)message);
            }
        }
        Wait.assertEquals((int)100, messagesReceived::intValue);
        ValidateAMQPErrorsTest.assertEquals((long)0L, (long)errors.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoClientDesiredMirrorCapability() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.server.start();
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Sender sender) {
                ErrorCondition condition = sender.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.ILLEGAL_STATE)) {
                        this.markAsInvalid("Should have been closed with an illegal state error, but error was: " + condition);
                    }
                    if (!condition.getDescription().contains("AMQ119024")) {
                        this.markAsInvalid("should have indicated the error code about missing a desired capability");
                    }
                    if (!condition.getDescription().contains((CharSequence)AMQPMirrorControllerSource.MIRROR_CAPABILITY)) {
                        this.markAsInvalid("should have indicated the error code about missing a desired capability");
                    }
                } else {
                    this.markAsInvalid("Sender should have been detached with an error");
                }
            }
        });
        String address = ProtonProtocolManager.getMirrorAddress((String)this.getTestName());
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            try {
                session.createSender(address);
                ValidateAMQPErrorsTest.fail((String)"Link should have been refused.");
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("AMQ119024"));
                this.instanceLog.debug((Object)"Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
        Wait.assertTrue(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ119024"}));
    }
}

