/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.divert;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Assert;
import org.junit.Test;

public class DivertTest
extends ActiveMQTestBase {
    private static final int TIMEOUT = 3000;

    @Test
    public void testDivertedNotificationMessagePropertiesOpenWire() throws Exception {
        String testAddress = ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString();
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress(testAddress).setForwardingAddress("forwardAddress").setFilterString("_AMQ_NotifType = 'CONSUMER_CREATED' OR _AMQ_NotifType = 'CONSUMER_CLOSED'");
        Configuration config = this.createDefaultNettyConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        connectionFactory.setClientID("myClientID");
        ActiveMQTopic forwardTopic = new ActiveMQTopic("forwardAddress");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)forwardTopic, "mySubscriptionName");
        Message message = subscriber.receive(3000L);
        connection.close();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"CONSUMER_CREATED", (Object)message.getStringProperty("_AMQ_NotifType"));
    }

    @Test
    public void testSingleNonExclusiveDivert() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        boolean numMessages = true;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 1; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 1; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            Assert.assertEquals((Object)"forwardAddress", (Object)message.getAddress());
            Assert.assertEquals((Object)"testAddress", (Object)message.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 1; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            Assert.assertEquals((Object)"testAddress", (Object)message.getAddress());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
    }

    @Test
    public void testDivertAndQueueWithSameName() throws Exception {
        String name = RandomUtil.randomString();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().addDivertConfiguration(new DivertConfiguration().setName(name).setRoutingName(RandomUtil.randomString()).setAddress(RandomUtil.randomString()).setForwardingAddress(RandomUtil.randomString())), (boolean)false));
        server.start();
        try {
            server.createQueue(new QueueConfiguration(name));
            DivertTest.fail();
        }
        catch (ActiveMQIllegalStateException activeMQIllegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCrossProtocol() throws Exception {
        String testForConvert = "testConvert";
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setRoutingType(ComponentConfigurationRoutingType.ANYCAST);
        Configuration config = this.createDefaultNettyConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        SimpleString queueName1 = SimpleString.toSimpleString((String)"testAddress");
        SimpleString queueName2 = SimpleString.toSimpleString((String)"forwardAddress");
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(queueName1).setAddress("testAddress").setRoutingType(RoutingType.ANYCAST));
        session.createQueue(new QueueConfiguration(SimpleString.toSimpleString((String)"testConvert")).setAddress("testConvert").setRoutingType(RoutingType.ANYCAST));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress").setRoutingType(RoutingType.ANYCAST));
        ConnectionFactory coreCF = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        Connection coreConnection = coreCF.createConnection();
        Session coreSession = coreConnection.createSession(1);
        MessageProducer producerCore = coreSession.createProducer((Destination)coreSession.createQueue("testConvert"));
        for (int i = 0; i < 10; ++i) {
            TextMessage textMessage = coreSession.createTextMessage("text" + i);
            producerCore.send((Message)textMessage);
        }
        producerCore.close();
        ConnectionFactory amqpCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection amqpConnection = amqpCF.createConnection();
        Session amqpSession = amqpConnection.createSession(1);
        Queue amqpQueue = amqpSession.createQueue("testAddress");
        MessageProducer producer = amqpSession.createProducer((Destination)amqpQueue);
        MessageConsumer consumerFromConvert = amqpSession.createConsumer((Destination)amqpSession.createQueue("testConvert"));
        amqpConnection.start();
        for (int i = 0; i < 10; ++i) {
            Message received = consumerFromConvert.receive(5000L);
            Assert.assertNotNull((Object)received);
            producer.send(received);
        }
        Queue outQueue = coreSession.createQueue(queueName2.toString());
        MessageConsumer consumer = coreSession.createConsumer((Destination)outQueue);
        coreConnection.start();
        for (int i = 0; i < 10; ++i) {
            TextMessage textMessage = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)textMessage);
            Assert.assertEquals((Object)("text" + i), (Object)textMessage.getText());
        }
        Assert.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testSingleNonExclusiveDivertWithRoutingType() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        boolean numMessages = true;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 1; ++i) {
            message = session.createMessage(false);
            message.setRoutingType(RoutingType.MULTICAST);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 1; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 1; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
    }

    @Test
    public void testSingleExclusiveDivertWithRoutingType() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        boolean numMessages = true;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 1; ++i) {
            message = session.createMessage(false);
            message.setRoutingType(RoutingType.MULTICAST);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 1; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
    }

    @Test
    public void testSingleDivertWithExpiry() throws Exception {
        ClientMessage message;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        String expiryAddress = "expiryAddress";
        AddressSettings expirySettings = new AddressSettings().setExpiryAddress(new SimpleString("expiryAddress"));
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).clearAddressesSettings().addAddressesSetting("#", expirySettings);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress"));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress"));
        session.createQueue(new QueueConfiguration("expiryAddress"));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        boolean numMessages = true;
        SimpleString propKey = new SimpleString("testkey");
        for (int i = 0; i < 1; ++i) {
            message = session.createMessage(true);
            message.putIntProperty(propKey, i);
            message.setExpiration(System.currentTimeMillis() + 1000L);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        int count1 = 0;
        message = null;
        while ((message = consumer1.receiveImmediate()) != null) {
            message.acknowledge();
            ++count1;
        }
        int count2 = 0;
        while ((message = consumer2.receiveImmediate()) != null) {
            message.acknowledge();
            ++count2;
        }
        DivertTest.assertEquals((long)1L, (long)count1);
        DivertTest.assertEquals((long)1L, (long)count2);
        session.rollback();
        Thread.sleep(2000L);
        DivertTest.assertNull((Object)consumer1.receiveImmediate());
        DivertTest.assertNull((Object)consumer2.receiveImmediate());
        int countOriginal1 = 0;
        int countOriginal2 = 0;
        ClientConsumer consumerExpiry = session.createConsumer("expiryAddress");
        for (int i = 0; i < 2; ++i) {
            ClientMessage message2 = consumerExpiry.receive(5000L);
            this.instanceLog.debug((Object)("Received message " + message2));
            DivertTest.assertNotNull((Object)message2);
            if (message2.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE).equals("queue1")) {
                ++countOriginal1;
                continue;
            }
            if (message2.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE).equals("queue2")) {
                ++countOriginal2;
                continue;
            }
            this.instanceLog.debug((Object)("message not part of any expired queue" + message2));
        }
        DivertTest.assertEquals((long)1L, (long)countOriginal1);
        DivertTest.assertEquals((long)1L, (long)countOriginal2);
    }

    @Test
    public void testSingleNonExclusiveDivert2() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testSingleNonExclusiveDivert3() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
    }

    @Test
    public void testSingleExclusiveDivert() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            Assert.assertEquals((Object)"forwardAddress", (Object)message.getAddress());
            Assert.assertEquals((Object)"testAddress", (Object)message.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testSinglePersistedDivert() throws Exception {
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        QueueConfiguration q1 = new QueueConfiguration("forwardAddress1").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).addQueueConfiguration(q1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.start();
        server.stop();
        divertConf.setRoutingName("divert2");
        server.start();
        Binding divert1 = server.getPostOffice().getBinding(new SimpleString("divert1"));
        Assert.assertNotNull((Object)divert1);
        Assert.assertEquals((Object)divert1.getRoutingName(), (Object)new SimpleString("divert2"));
    }

    @Test
    public void testSinglePersistedNewDivert() throws Exception {
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        QueueConfiguration q1 = new QueueConfiguration("forwardAddress1").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).addQueueConfiguration(q1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.start();
        server.stop();
        divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        config.getDivertConfigurations().clear();
        config.getDivertConfigurations().add(divertConf);
        server.start();
        Binding divert1 = server.getPostOffice().getBinding(new SimpleString("divert1"));
        Assert.assertNotNull((Object)divert1);
        Assert.assertEquals((Object)divert1.getRoutingName(), (Object)new SimpleString("divert2"));
    }

    @Test
    public void testSinglePersistedNoDeleteDivert() throws Exception {
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        QueueConfiguration q1 = new QueueConfiguration("forwardAddress1").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).addQueueConfiguration(q1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.start();
        server.stop();
        config.getDivertConfigurations().clear();
        server.start();
        Binding divert1 = server.getPostOffice().getBinding(new SimpleString("divert1"));
        Assert.assertNotNull((Object)divert1);
        Assert.assertEquals((Object)divert1.getRoutingName(), (Object)new SimpleString("divert1"));
    }

    @Test
    public void testSinglePersistedDeleteDivert() throws Exception {
        String testAddress = "testAddress";
        String forwardAddress = "forwardAddress";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        QueueConfiguration q1 = new QueueConfiguration("forwardAddress1").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setConfigDeleteDiverts(DeletionPolicy.FORCE);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).addQueueConfiguration(q1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.getAddressSettingsRepository().addMatch("testAddress", (Object)addressSettings);
        server.start();
        server.stop();
        config.getDivertConfigurations().clear();
        server.start();
        Binding divert1 = server.getPostOffice().getBinding(new SimpleString("divert1"));
        Assert.assertNull((Object)divert1);
    }

    @Test
    public void testMixedPersistedDeleteDivert() throws Exception {
        String testAddress = "testAddress";
        String testAddress2 = "testAddress2";
        String forwardAddress = "forwardAddress";
        String forwardAddress2 = "forwardAddress2";
        DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress").setExclusive(true);
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress2").setForwardingAddress("forwardAddress2").setExclusive(true);
        QueueConfiguration q1 = new QueueConfiguration("forwardAddress1").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setConfigDeleteDiverts(DeletionPolicy.FORCE);
        AddressSettings addressSettings2 = new AddressSettings();
        addressSettings2.setConfigDeleteDiverts(DeletionPolicy.OFF);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf).addDivertConfiguration(divertConf2).addQueueConfiguration(q1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)true));
        server.getAddressSettingsRepository().addMatch("testAddress", (Object)addressSettings);
        server.getAddressSettingsRepository().addMatch("testAddress2", (Object)addressSettings2);
        server.start();
        server.stop();
        config.getDivertConfigurations().clear();
        server.start();
        Binding divert1 = server.getPostOffice().getBinding(new SimpleString("divert1"));
        Assert.assertNull((Object)divert1);
        Binding divert2 = server.getPostOffice().getBinding(new SimpleString("divert2"));
        Assert.assertNotNull((Object)divert2);
    }

    @Test
    public void testMultipleNonExclusiveDivert() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testMultipleExclusiveDivert() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1").setExclusive(true);
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2").setExclusive(true);
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3").setExclusive(true);
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testMixExclusiveAndNonExclusiveDiverts() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1").setExclusive(true);
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2").setExclusive(true);
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testSingleExclusiveNonMatchingAndNonExclusiveDiverts() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        String filter = "animal='antelope'";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1").setExclusive(true).setFilterString("animal='antelope'");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(new SimpleString("animal"), new SimpleString("giraffe"));
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(new SimpleString("animal"), new SimpleString("antelope"));
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testRoundRobinDiverts() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("thename").setAddress("testAddress").setForwardingAddress("forwardAddress1");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("thename").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("thename").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
            if (++i == 10) break;
            message = consumer2.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
            if (++i == 10) break;
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testDeployDivertsSameUniqueName() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("thename1").setAddress("testAddress").setForwardingAddress("forwardAddress1");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert1").setRoutingName("thename2").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert2").setRoutingName("thename3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3").setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(3000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty(propKey).intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    @Test
    public void testInjectedTransformer() throws Exception {
        SimpleString ADDRESS = new SimpleString("myAddress");
        String DIVERT = "myDivert";
        ServiceRegistryImpl serviceRegistry = new ServiceRegistryImpl();
        Transformer transformer = new Transformer(){

            public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
                return null;
            }
        };
        serviceRegistry.addDivertTransformer("myDivert", transformer);
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)this.createBasicConfig(), null, null, null, (ServiceRegistry)serviceRegistry));
        server.start();
        server.waitForActivation(100L, TimeUnit.MILLISECONDS);
        server.createQueue(new QueueConfiguration("myQueue").setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        server.deployDivert(new DivertConfiguration().setName("myDivert").setAddress(ADDRESS.toString()).setForwardingAddress(ADDRESS.toString()));
        Collection bindings = server.getPostOffice().getBindingsForAddress(ADDRESS).getBindings();
        Divert divert = null;
        for (Binding binding : bindings) {
            if (!(binding instanceof DivertBinding)) continue;
            divert = ((DivertBinding)binding).getDivert();
        }
        DivertTest.assertNotNull(divert);
        DivertTest.assertEquals((Object)transformer, (Object)divert.getTransformer());
        server.destroyDivert(SimpleString.toSimpleString((String)"myDivert"));
        DivertTest.assertNull((Object)serviceRegistry.getDivertTransformer("myDivert", null));
    }

    @Test
    public void testProperties() throws Exception {
        String testAddress = "testAddress";
        SimpleString queue = SimpleString.toSimpleString((String)"queue");
        int COUNT = 25;
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        server.start();
        server.createQueue(new QueueConfiguration(queue).setAddress("testAddress25").setRoutingType(RoutingType.ANYCAST));
        for (int i = 0; i < 25; ++i) {
            server.deployDivert(new DivertConfiguration().setName("divert" + i).setAddress("testAddress" + i).setForwardingAddress("testAddress" + (i + 1)));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress0"));
        ClientConsumer consumer1 = session.createConsumer(queue);
        ClientMessage message = session.createMessage(false);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = consumer1.receive(3000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        Assert.assertEquals((Object)"testAddress25", (Object)message.getAddress());
        Assert.assertEquals((Object)"testAddress24", (Object)message.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS));
    }
}

