/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterConnectionControlTest
extends ManagementTestBase {
    private ActiveMQServer server_0;
    private ClusterConnectionConfiguration clusterConnectionConfig1;
    private ClusterConnectionConfiguration clusterConnectionConfig2;
    private ActiveMQServer server_1;
    private MBeanServer mbeanServer_1;

    @Test
    public void testAttributes1() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        Assert.assertEquals((Object)this.clusterConnectionConfig1.getName(), (Object)clusterConnectionControl.getName());
        Assert.assertEquals((Object)this.clusterConnectionConfig1.getAddress(), (Object)clusterConnectionControl.getAddress());
        Assert.assertEquals((Object)this.clusterConnectionConfig1.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
        Assert.assertEquals((long)this.clusterConnectionConfig1.getRetryInterval(), (long)clusterConnectionControl.getRetryInterval());
        Assert.assertEquals((Object)this.clusterConnectionConfig1.isDuplicateDetection(), (Object)clusterConnectionControl.isDuplicateDetection());
        Assert.assertEquals((Object)this.clusterConnectionConfig1.getMessageLoadBalancingType().getType(), (Object)clusterConnectionControl.getMessageLoadBalancingType());
        Assert.assertEquals((long)this.clusterConnectionConfig1.getMaxHops(), (long)clusterConnectionControl.getMaxHops());
        Assert.assertEquals((long)0L, (long)clusterConnectionControl.getMessagesPendingAcknowledgement());
        Assert.assertEquals((long)0L, (long)clusterConnectionControl.getMessagesAcknowledged());
        Map clusterMetrics = clusterConnectionControl.getMetrics();
        Assert.assertEquals((Object)0L, clusterMetrics.get("messagesPendingAcknowledgement"));
        Assert.assertEquals((Object)0L, clusterMetrics.get("messagesAcknowledged"));
        Assert.assertNull((Object)clusterConnectionControl.getBridgeMetrics("bad"));
        Object[] connectors = clusterConnectionControl.getStaticConnectors();
        Assert.assertEquals((long)1L, (long)connectors.length);
        String connector = (String)connectors[0];
        Assert.assertEquals(this.clusterConnectionConfig1.getStaticConnectors().get(0), (Object)connector);
        String jsonString = clusterConnectionControl.getStaticConnectorsAsJSON();
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        Assert.assertEquals(this.clusterConnectionConfig1.getStaticConnectors().get(0), (Object)array.getString(0));
        Assert.assertNull((Object)clusterConnectionControl.getDiscoveryGroupName());
        Assert.assertTrue((boolean)clusterConnectionControl.isStarted());
    }

    @Test
    public void testAttributes2() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig2.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig2.getName());
        Assert.assertEquals((Object)this.clusterConnectionConfig2.getName(), (Object)clusterConnectionControl.getName());
        Assert.assertEquals((Object)this.clusterConnectionConfig2.getAddress(), (Object)clusterConnectionControl.getAddress());
        Assert.assertEquals((Object)this.clusterConnectionConfig2.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
        Assert.assertEquals((long)this.clusterConnectionConfig2.getRetryInterval(), (long)clusterConnectionControl.getRetryInterval());
        Assert.assertEquals((Object)this.clusterConnectionConfig2.isDuplicateDetection(), (Object)clusterConnectionControl.isDuplicateDetection());
        Assert.assertEquals((Object)this.clusterConnectionConfig2.getMessageLoadBalancingType().getType(), (Object)clusterConnectionControl.getMessageLoadBalancingType());
        Assert.assertEquals((long)this.clusterConnectionConfig2.getMaxHops(), (long)clusterConnectionControl.getMaxHops());
        Object[] connectorPairs = clusterConnectionControl.getStaticConnectors();
        Assert.assertEquals((long)0L, (long)connectorPairs.length);
        String jsonPairs = clusterConnectionControl.getStaticConnectorsAsJSON();
        Assert.assertEquals((Object)"[]", (Object)jsonPairs);
        Assert.assertEquals((Object)this.clusterConnectionConfig2.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
    }

    @Test
    public void testStartStop() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        Assert.assertTrue((boolean)clusterConnectionControl.isStarted());
        clusterConnectionControl.stop();
        Assert.assertFalse((boolean)clusterConnectionControl.isStarted());
        clusterConnectionControl.start();
        Assert.assertTrue((boolean)clusterConnectionControl.isStarted());
    }

    @Test
    public void testNotifications() throws Exception {
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        this.server_0.getManagementService().addNotificationListener((NotificationListener)notifListener);
        Assert.assertEquals((long)0L, (long)notifListener.getNotifications().size());
        clusterConnectionControl.stop();
        Assert.assertTrue((notifListener.getNotifications().size() > 0 ? (byte)1 : 0) != 0);
        Notification notif = this.getFirstNotificationOfType(notifListener.getNotifications(), CoreNotificationType.CLUSTER_CONNECTION_STOPPED);
        Assert.assertNotNull((Object)notif);
        Assert.assertEquals((Object)clusterConnectionControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
        clusterConnectionControl.start();
        Assert.assertTrue((notifListener.getNotifications().size() > 0 ? (byte)1 : 0) != 0);
        notif = this.getFirstNotificationOfType(notifListener.getNotifications(), CoreNotificationType.CLUSTER_CONNECTION_STARTED);
        Assert.assertNotNull((Object)notif);
        Assert.assertEquals((Object)clusterConnectionControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
    }

    private Notification getFirstNotificationOfType(List<Notification> notifications, CoreNotificationType type) {
        Notification result = null;
        ArrayList<Notification> notificationsClone = new ArrayList<Notification>(notifications);
        for (Notification notification : notificationsClone) {
            if (!notification.getType().equals(type)) continue;
            result = notification;
        }
        return result;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> acceptorParams = new HashMap<String, Integer>();
        acceptorParams.put("serverId", 1);
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        QueueConfiguration queueConfig = new QueueConfiguration(RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add(connectorConfig.getName());
        String discoveryGroupName = RandomUtil.randomString();
        DiscoveryGroupConfiguration discoveryGroupConfig = new DiscoveryGroupConfiguration().setName(discoveryGroupName).setRefreshTimeout(500L).setDiscoveryInitialWaitTimeout(0L).setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(ClusterConnectionControlTest.getUDPDiscoveryAddress()).setGroupPort(ClusterConnectionControlTest.getUDPDiscoveryPort()));
        ConfigurationImpl conf_1 = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addQueueConfiguration(queueConfig);
        this.clusterConnectionConfig1 = new ClusterConnectionConfiguration().setName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setConnectorName(connectorConfig.getName()).setRetryInterval(RandomUtil.randomPositiveLong()).setDuplicateDetection(RandomUtil.randomBoolean()).setMessageLoadBalancingType(MessageLoadBalancingType.STRICT).setMaxHops(RandomUtil.randomPositiveInt()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectors).setCallTimeout(500L).setCallFailoverTimeout(500L);
        this.clusterConnectionConfig2 = new ClusterConnectionConfiguration().setName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setConnectorName(connectorConfig.getName()).setRetryInterval(RandomUtil.randomPositiveLong()).setDuplicateDetection(RandomUtil.randomBoolean()).setMessageLoadBalancingType(MessageLoadBalancingType.OFF).setMaxHops(RandomUtil.randomPositiveInt()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setDiscoveryGroupName(discoveryGroupName).setCallTimeout(500L).setCallFailoverTimeout(500L);
        ConfigurationImpl conf_0 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).addConnectorConfiguration(connectorConfig.getName(), connectorConfig).addClusterConfiguration(this.clusterConnectionConfig1).addClusterConfiguration(this.clusterConnectionConfig2).addDiscoveryGroupConfiguration(discoveryGroupName, discoveryGroupConfig);
        this.mbeanServer_1 = MBeanServerFactory.createMBeanServer();
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)this.mbeanServer_1, (boolean)false));
        this.server_1.start();
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server_0.start();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        MBeanServerFactory.releaseMBeanServer(this.mbeanServer_1);
        super.tearDown();
    }

    protected ClusterConnectionControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createClusterConnectionControl(name, this.mbeanServer);
    }
}

