/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class MQTTRejectingInterceptorTest
extends MQTTTestSupport {
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Test(timeout=60000L)
    public void testRejectedMQTTMessage() throws Exception {
        String addressQueue = this.name.getMethodName();
        String msgText = "Test rejected message";
        MQTTClientProvider subscribeProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscribeProvider);
        subscribeProvider.subscribe(addressQueue, 0);
        MQTTInterceptor incomingInterceptor = new MQTTInterceptor(){

            public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
                return packet.getClass() != MqttPublishMessage.class;
            }
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        publishProvider.publish(addressQueue, "Test rejected message".getBytes(), 0, false);
        MQTTRejectingInterceptorTest.assertNull((Object)subscribeProvider.receive(3000));
        subscribeProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test(timeout=60000L)
    public void testRejectedMqttConnectMessage() throws Exception {
        CountDownLatch publishThreadReady = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((MQTTInterceptor)(packet, connection) -> packet.getClass() != MqttConnectMessage.class));
        Thread publishThread = new Thread(() -> {
            MQTTClientProvider publishProvider = this.getMQTTClientProvider();
            publishThreadReady.countDown();
            try {
                this.initializeConnection(publishProvider);
                publishProvider.disconnect();
                MQTTRejectingInterceptorTest.fail((String)"The connection should be rejected!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        publishThread.start();
        publishThreadReady.await();
        publishThread.join(3000L);
        if (publishThread.isAlive()) {
            MQTTRejectingInterceptorTest.fail((String)"The connection is stuck!");
        }
    }
}

