/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import java.io.IOException;
import java.net.URI;
import org.apache.activemq.artemis.tests.integration.stomp.util.AbstractStompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrameV10;
import org.jboss.logging.Logger;

public class StompClientConnectionV10
extends AbstractStompClientConnection {
    private static final Logger log = Logger.getLogger(StompClientConnectionV10.class);

    public StompClientConnectionV10(String host, int port) throws IOException {
        super("1.0", host, port);
    }

    public StompClientConnectionV10(String version, String host, int port) throws IOException {
        super(version, host, port);
    }

    public StompClientConnectionV10(URI uri) throws Exception {
        super(uri);
    }

    public StompClientConnectionV10(URI uri, boolean autoConnect) throws Exception {
        super(uri, autoConnect);
    }

    @Override
    public ClientStompFrame connect(String username, String passcode) throws IOException, InterruptedException {
        return this.connect(username, passcode, null);
    }

    @Override
    public ClientStompFrame connect(String username, String passcode, String clientID) throws IOException, InterruptedException {
        ClientStompFrame response;
        ClientStompFrame frame = this.factory.newFrame("CONNECT");
        frame.addHeader("login", username);
        frame.addHeader("passcode", passcode);
        if (clientID != null) {
            frame.addHeader("client-id", clientID);
        }
        if ((response = this.sendFrame(frame)).getCommand().equals("CONNECTED")) {
            this.connected = true;
        } else {
            log.warn((Object)("Connection failed with: " + response));
            this.connected = false;
        }
        return response;
    }

    @Override
    public void disconnect() throws IOException, InterruptedException {
        ClientStompFrame frame = this.factory.newFrame("DISCONNECT");
        this.sendFrame(frame);
        this.close();
        this.connected = false;
    }

    @Override
    public ClientStompFrame createFrame(String command) {
        return new ClientStompFrameV10(command);
    }

    @Override
    public void startPinger(long interval) {
    }

    @Override
    public void stopPinger() {
    }

    @Override
    public int getServerPingNumber() {
        return 0;
    }
}

