/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.view.View;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T> SynchronousMetricStorage create(View view, InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, exemplarFilter);
        if (Aggregator.drop() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(metricDescriptor, aggregator, view.getAttributesProcessor());
    }
}

