/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractCollectionMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.CollectionMappedByResolver;
import org.hibernate.envers.configuration.internal.metadata.CollectionMetadataContext;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneIdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleRelatedComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleStraightComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.query.OneAuditEntityQueryGenerator;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Selectable;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class JoinColumnCollectionMetadataGenerator
extends AbstractCollectionMetadataGenerator {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)JoinColumnCollectionMetadataGenerator.class.getName());

    public JoinColumnCollectionMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, BasicMetadataGenerator basicMetadataGenerator, ValueMetadataGenerator valueMetadataGenerator) {
        super(metadataBuildingContext, basicMetadataGenerator, valueMetadataGenerator);
    }

    @Override
    public void addCollection(CollectionMetadataContext context) {
        PropertyMapper fakeBidirectionalRelationIndexMapper;
        PropertyMapper fakeBidirectionalRelationMapper;
        LOG.debugf("Adding audit mapping for property %s.%s: one-to-many collection, using a join column on the referenced entity", context.getReferencingEntityName(), context.getPropertyName());
        Collection collection = context.getCollection();
        PropertyAuditingData propertyAuditingData = context.getPropertyAuditingData();
        String mappedBy = CollectionMappedByResolver.resolveMappedBy(collection, propertyAuditingData);
        IdMappingData referencedIdMapping = this.getReferencedIdMappingData(context.getReferencingEntityName(), context.getReferencedEntityName(), propertyAuditingData, false);
        EntityConfiguration referencingEntityConfiguration = context.getReferencingEntityConfiguration();
        IdMappingData referencingIdMapping = referencingEntityConfiguration.getIdMappingData();
        MiddleIdData referencingIdData = this.createMiddleIdData(referencingIdMapping, mappedBy + "_", context.getReferencingEntityName());
        MiddleIdData referencedIdData = this.createMiddleIdData(referencedIdMapping, null, context.getReferencedEntityName());
        MiddleRelatedComponentMapper elementComponentMapper = new MiddleRelatedComponentMapper(referencedIdData);
        MiddleComponentData elementComponentData = new MiddleComponentData(elementComponentMapper);
        MiddleComponentData indexComponentData = this.addIndex(context, null, null);
        OneAuditEntityQueryGenerator queryGenerator = new OneAuditEntityQueryGenerator(this.getMetadataBuildingContext().getConfiguration(), referencingIdData, context.getReferencedEntityName(), referencedIdData, context.getCollection().getElement() instanceof ComponentType, mappedBy, CollectionMappedByResolver.isMappedByKey(collection, mappedBy), this.getOrderByCollectionRole(collection, collection.getOrderBy()));
        CommonCollectionMapperData commonCollectionMapperData = this.createCommonCollectionMapperData(context, context.getReferencedEntityName(), referencingIdData, queryGenerator);
        if (context.isFakeOneToManyBidirectional() || this.hasCollectionIndex(context)) {
            String auditMappedBy = this.getAddOneToManyAttachedAuditMappedBy(context);
            fakeBidirectionalRelationMapper = this.getBidirectionalRelationMapper(context.getReferencingEntityName(), referencingIdMapping, auditMappedBy);
            String positionMappedBy = this.getAttachedPositionMappedBy(context);
            if (positionMappedBy != null) {
                fakeBidirectionalRelationIndexMapper = this.getBidirectionalRelationIndexMapper(context, positionMappedBy);
                indexComponentData = this.getBidirectionalIndexData(indexComponentData, positionMappedBy);
            } else {
                fakeBidirectionalRelationIndexMapper = null;
            }
        } else {
            fakeBidirectionalRelationMapper = null;
            fakeBidirectionalRelationIndexMapper = null;
        }
        this.addMapper(context, commonCollectionMapperData, elementComponentData, indexComponentData);
        referencingEntityConfiguration.addToManyNotOwningRelation(context.getPropertyName(), mappedBy, context.getReferencedEntityName(), referencingIdData.getPrefixedMapper(), fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, this.hasCollectionIndex(context));
    }

    private boolean hasCollectionIndex(CollectionMetadataContext context) {
        return context.getCollection().isIndexed() && ((IndexedCollection)context.getCollection()).getIndex() != null;
    }

    private String getAddOneToManyAttachedAuditMappedBy(CollectionMetadataContext context) {
        if (context.isFakeOneToManyBidirectional()) {
            return context.getPropertyAuditingData().getAuditMappedBy();
        }
        return context.getCollection().getMappedByProperty();
    }

    private PropertyMapper getBidirectionalRelationMapper(String entityName, IdMappingData idData, String auditMappedBy) {
        IdMapper relMapper = idData.getIdMapper().prefixMappedProperties(MappingTools.createToOneRelationPrefix(auditMappedBy));
        return new ToOneIdMapper(relMapper, new PropertyData(auditMappedBy, null, null), entityName, false, false);
    }

    private PropertyMapper getBidirectionalRelationIndexMapper(CollectionMetadataContext context, String positionMappedBy) {
        if (positionMappedBy != null) {
            Type indexType = this.getCollectionIndexType(context);
            return new SinglePropertyMapper(PropertyData.forProperty(positionMappedBy, indexType));
        }
        return null;
    }

    private Type getCollectionIndexType(CollectionMetadataContext context) {
        if (context.getCollection().isIndexed()) {
            return ((IndexedCollection)context.getCollection()).getIndex().getType();
        }
        return null;
    }

    private String getAttachedPositionMappedBy(CollectionMetadataContext context) {
        if (context.isFakeOneToManyBidirectional()) {
            return context.getPropertyAuditingData().getPositionMappedBy();
        }
        if (this.hasCollectionIndex(context)) {
            return ((Selectable)((IndexedCollection)context.getCollection()).getIndex().getColumnIterator().next()).getText();
        }
        return null;
    }

    private MiddleComponentData getBidirectionalIndexData(MiddleComponentData original, String positionMappedBy) {
        if (positionMappedBy != null) {
            return new MiddleComponentData(new MiddleStraightComponentMapper(positionMappedBy));
        }
        return original;
    }
}

