/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.authz.jacc.ElytronMessages;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.SecurityIdentityHandler;

public class JaccDelegatingPolicy
extends Policy {
    private static final PrivilegedAction<Policy> GET_POLICY_ACTION = Policy::getPolicy;
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";
    private final Policy delegate;
    private final Set<Class<? extends Permission>> supportedPermissionTypes = new HashSet<Class<? extends Permission>>();

    public JaccDelegatingPolicy() {
        this(System.getSecurityManager() != null ? AccessController.doPrivileged(GET_POLICY_ACTION) : Policy.getPolicy());
    }

    public JaccDelegatingPolicy(Policy delegate) {
        this.delegate = (Policy)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.supportedPermissionTypes.add(WebResourcePermission.class);
        this.supportedPermissionTypes.add(WebRoleRefPermission.class);
        this.supportedPermissionTypes.add(WebUserDataPermission.class);
        this.supportedPermissionTypes.add(EJBMethodPermission.class);
        this.supportedPermissionTypes.add(EJBRoleRefPermission.class);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        try {
            if (this.isJaccPermission(permission)) {
                ElytronPolicyConfiguration policyConfiguration = (ElytronPolicyConfiguration)ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
                if (this.impliesExcludedPermission(permission, policyConfiguration)) {
                    return false;
                }
                if (this.impliesUncheckedPermission(permission, policyConfiguration)) {
                    return true;
                }
                if (this.impliesRolePermission(domain, permission, policyConfiguration)) {
                    return true;
                }
                if (this.impliesIdentityPermission(permission)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            ElytronMessages.log.authzFailedToCheckPermission(domain, permission, e);
        }
        return this.delegate.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(final ProtectionDomain domain) {
        final PermissionCollection delegatePermissions = this.delegate.getPermissions(domain);
        return new PermissionCollection(){

            @Override
            public void add(Permission permission) {
                if (JaccDelegatingPolicy.this.isJaccPermission(permission)) {
                    throw ElytronMessages.log.readOnlyPermissionCollection();
                }
                delegatePermissions.add(permission);
            }

            @Override
            public boolean implies(Permission permission) {
                if (!JaccDelegatingPolicy.this.isJaccPermission(permission) && delegatePermissions.implies(permission)) {
                    return true;
                }
                return JaccDelegatingPolicy.this.implies(domain, permission);
            }

            @Override
            public Enumeration<Permission> elements() {
                return delegatePermissions.elements();
            }
        };
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return codeSource == null ? Policy.UNSUPPORTED_EMPTY_COLLECTION : this.getPermissions(new ProtectionDomain(codeSource, null));
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    private boolean impliesIdentityPermission(Permission permission) {
        SecurityIdentity actualIdentity = this.getCurrentSecurityIdentity();
        return actualIdentity != null && actualIdentity.implies(permission);
    }

    private SecurityIdentity getCurrentSecurityIdentity() {
        try {
            return (SecurityIdentity)PolicyContext.getContext((String)SecurityIdentityHandler.KEY);
        }
        catch (Exception cause) {
            ElytronMessages.log.authzCouldNotObtainSecurityIdentity(cause);
            return null;
        }
    }

    private void extractRolesFromCurrentIdentity(Set<String> roles) throws PolicyContextException, ClassNotFoundException {
        Roles identityRoles;
        SecurityIdentity identity = this.getCurrentSecurityIdentity();
        if (identity != null && (identityRoles = identity.getRoles()) != null) {
            for (String roleName : identityRoles) {
                roles.add(roleName);
            }
        }
    }

    private void extractRolesFromProtectionDomain(ProtectionDomain domain, Set<String> roles) {
        Principal[] domainPrincipals = domain.getPrincipals();
        if (domainPrincipals != null) {
            for (Principal principal : domainPrincipals) {
                roles.add(principal.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesRolePermission(ProtectionDomain domain, Permission permission, ElytronPolicyConfiguration policyConfiguration) throws PolicyContextException, ClassNotFoundException {
        Map<String, PermissionCollection> rolePermissions;
        HashSet<String> roles = new HashSet<String>();
        this.extractRolesFromProtectionDomain(domain, roles);
        this.extractRolesFromCurrentIdentity(roles);
        roles.add(ANY_AUTHENTICATED_USER_ROLE);
        Map<String, PermissionCollection> map = rolePermissions = policyConfiguration.getPerRolePermissions();
        synchronized (map) {
            for (String roleName : roles) {
                PermissionCollection permissions = rolePermissions.get(roleName);
                if (permissions == null || !permissions.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesUncheckedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        PermissionCollection uncheckedPermissions;
        PermissionCollection permissionCollection = uncheckedPermissions = policyConfiguration.getUncheckedPermissions();
        synchronized (permissionCollection) {
            return uncheckedPermissions.implies(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesExcludedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        PermissionCollection excludedPermissions;
        PermissionCollection permissionCollection = excludedPermissions = policyConfiguration.getExcludedPermissions();
        synchronized (permissionCollection) {
            return excludedPermissions.implies(permission);
        }
    }

    private boolean isJaccPermission(Permission permission) {
        return this.supportedPermissionTypes.contains(permission.getClass());
    }
}

