/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.hibernate.cache.internal.DisabledCaching;
import org.hibernate.cache.internal.EnabledCaching;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;

public class CacheInitiator
implements SessionFactoryServiceInitiator<CacheImplementor> {
    public static final CacheInitiator INSTANCE = new CacheInitiator();

    @Override
    public CacheImplementor initiateService(SessionFactoryServiceInitiatorContext context) {
        RegionFactory regionFactory = context.getServiceRegistry().getService(RegionFactory.class);
        return !NoCachingRegionFactory.class.isInstance(regionFactory) ? new EnabledCaching(context.getSessionFactory()) : new DisabledCaching(context.getSessionFactory());
    }

    @Override
    public Class<CacheImplementor> getServiceInitiated() {
        return CacheImplementor.class;
    }
}

