/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class DiscriminatedAssociationAttributeMapping
extends AbstractSingularAttributeMapping
implements DiscriminatedAssociationModelPart {
    private final NavigableRole navigableRole;
    private final DiscriminatedAssociationMapping discriminatorMapping;
    private final SessionFactoryImplementor sessionFactory;

    public DiscriminatedAssociationAttributeMapping(NavigableRole attributeRole, JavaType<?> baseAssociationJtd, ManagedMappingType declaringType, int stateArrayPosition, AttributeMetadataAccess attributeMetadataAccess, FetchTiming fetchTiming, PropertyAccess propertyAccess, Property bootProperty, AnyType anyType, Any bootValueMapping, MappingModelCreationProcess creationProcess) {
        super(bootProperty.getName(), stateArrayPosition, attributeMetadataAccess, fetchTiming, FetchStyle.SELECT, declaringType, propertyAccess, null);
        this.navigableRole = attributeRole;
        this.discriminatorMapping = DiscriminatedAssociationMapping.from(attributeRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
    }

    @Override
    public BasicValuedModelPart getDiscriminatorPart() {
        return this.discriminatorMapping.getDiscriminatorPart();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.discriminatorMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(discriminatorValue);
    }

    @Override
    public Object resolveDiscriminatorForEntityType(EntityMappingType entityMappingType) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(entityMappingType);
    }

    public String toString() {
        return "DiscriminatedAssociationAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState);
        this.discriminatorMapping.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        this.discriminatorMapping.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public MappingType getMappedType() {
        return this.discriminatorMapping;
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        EntityMappingType concreteMappingType = this.determineConcreteType(value, session);
        EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
        Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
        Object identifier = identifierMapping.getIdentifier(value);
        return new Object[]{this.discriminatorMapping.getDiscriminatorPart().disassemble(discriminator, session), identifierMapping.disassemble(identifier, session)};
    }

    private EntityMappingType determineConcreteType(Object entity, SharedSessionContractImplementor session) {
        String entityName = session == null ? this.sessionFactory.bestGuessEntityName(entity) : session.bestGuessEntityName(entity);
        return this.sessionFactory.getRuntimeMetamodels().getEntityMappingType(entityName);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        this.discriminatorMapping.getDiscriminatorPart().forEachSelectable(offset, consumer);
        this.discriminatorMapping.getKeyPart().forEachSelectable(offset + 1, consumer);
        return 2;
    }

    @Override
    public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
        action.accept(1, this.discriminatorMapping.getKeyPart().getJdbcMapping());
        return 2;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                valuesConsumer.consume(offset, values[0], this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
                valuesConsumer.consume(offset + 1, values[1], this.discriminatorMapping.getKeyPart().getJdbcMapping());
            } else {
                EntityMappingType concreteMappingType = this.determineConcreteType(value, session);
                Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
                Object disassembledDiscriminator = this.discriminatorMapping.getDiscriminatorPart().disassemble(discriminator, session);
                valuesConsumer.consume(offset, disassembledDiscriminator, this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
                EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
                Object identifier = identifierMapping.getIdentifier(value);
                Object disassembledKey = this.discriminatorMapping.getKeyPart().disassemble(identifier, session);
                valuesConsumer.consume(offset + 1, disassembledKey, this.discriminatorMapping.getKeyPart().getJdbcMapping());
            }
        }
        return 2;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        EntityMappingType concreteMappingType = this.determineConcreteType(domainValue, session);
        Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
        Object disassembledDiscriminator = this.discriminatorMapping.getDiscriminatorPart().disassemble(discriminator, session);
        valueConsumer.consume(disassembledDiscriminator, this.discriminatorMapping.getDiscriminatorPart());
        EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
        Object identifier = identifierMapping.getIdentifier(domainValue);
        Object disassembledKey = this.discriminatorMapping.getKeyPart().disassemble(identifier, session);
        valueConsumer.consume(disassembledKey, this.discriminatorMapping.getKeyPart());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        fetchableConsumer.accept(this.getDiscriminatorPart());
        fetchableConsumer.accept(this.getKeyPart());
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.discriminatorMapping.findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = requestedJoinType == null ? SqlAstJoinType.INNER : requestedJoinType;
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, requestedJoinType, fetched, null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        return new TableGroupJoin(navigablePath, joinType, tableGroup);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public String getSqlAliasStem() {
        return this.getAttributeName();
    }

    public static class MutabilityPlanImpl
    implements MutabilityPlan {
        private final AnyType anyType;

        public MutabilityPlanImpl(AnyType anyType) {
            this.anyType = anyType;
        }

        @Override
        public boolean isMutable() {
            return this.anyType.isMutable();
        }

        public Object deepCopy(Object value) {
            return value;
        }

        public Serializable disassemble(Object value, SharedSessionContract session) {
            SharedSessionContractImplementor persistenceContext = (SharedSessionContractImplementor)session;
            return this.anyType.disassemble(value, persistenceContext, null);
        }

        public Object assemble(Serializable cached, SharedSessionContract session) {
            SharedSessionContractImplementor persistenceContext = (SharedSessionContractImplementor)session;
            return this.anyType.assemble(cached, persistenceContext, null);
        }
    }
}

