/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderStandard
implements DynamicFetchBuilder,
NativeQuery.ReturnProperty {
    private final String fetchableName;
    private final List<String> columnNames;

    public DynamicFetchBuilderStandard(String fetchableName) {
        this.fetchableName = fetchableName;
        this.columnNames = new ArrayList<String>();
    }

    private DynamicFetchBuilderStandard(String fetchableName, List<String> columnNames) {
        this.fetchableName = fetchableName;
        this.columnNames = columnNames;
    }

    @Override
    public DynamicFetchBuilderStandard cacheKeyInstance() {
        return new DynamicFetchBuilderStandard(this.fetchableName, List.copyOf(this.columnNames));
    }

    public DynamicFetchBuilderStandard cacheKeyInstance(DynamicFetchBuilderContainer container) {
        return new DynamicFetchBuilderStandard(this.fetchableName, List.copyOf(this.columnNames));
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        Fetchable attributeMapping = (Fetchable)parent.getReferencedMappingContainer().findSubPart(this.fetchableName, null);
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(fetchPath, selectableMapping.getContainingTableExpression());
            String columnAlias = this.columnNames.get(selectionIndex);
            sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), state -> {
                int resultSetPosition = jdbcResultsMetadata.resolveColumnPosition(columnAlias);
                int valuesArrayPosition = resultSetPosition - 1;
                return new ResultSetMappingSqlSelection(valuesArrayPosition, selectableMapping.getJdbcMapping());
            }), selectableMapping.getJdbcMapping().getMappedJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        };
        if (attributeMapping instanceof BasicValuedMapping) {
            attributeMapping.forEachSelectable(selectableConsumer);
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.IMMEDIATE, true, null, creationStateImpl);
        }
        if (attributeMapping instanceof EmbeddedAttributeMapping) {
            attributeMapping.forEachSelectable(selectableConsumer);
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.IMMEDIATE, false, null, creationStateImpl);
        }
        if (attributeMapping instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
            toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature()).forEachSelectable(selectableConsumer);
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.DELAYED, false, null, creationStateImpl);
        }
        assert (attributeMapping instanceof PluralAttributeMapping);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)attributeMapping;
        pluralAttributeMapping.getKeyDescriptor().visitTargetSelectables(selectableConsumer);
        return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.DELAYED, false, null, creationStateImpl);
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnNames;
    }

    public int hashCode() {
        int result = this.fetchableName.hashCode();
        result = 31 * result + this.columnNames.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFetchBuilderStandard that = (DynamicFetchBuilderStandard)o;
        return this.fetchableName.equals(that.fetchableName) && this.columnNames.equals(that.columnNames);
    }
}

