/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSimpleCase;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCaseSimple<T, R>
extends AbstractSqmExpression<R>
implements JpaSimpleCase<T, R> {
    private final SqmExpression<T> fixture;
    private final List<WhenFragment<T, R>> whenFragments;
    private SqmExpression<R> otherwise;

    public SqmCaseSimple(SqmExpression<T> fixture, NodeBuilder nodeBuilder) {
        this(fixture, null, nodeBuilder);
    }

    public SqmCaseSimple(SqmExpression<T> fixture, SqmExpressible<R> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<T, R>>();
        this.fixture = fixture;
    }

    public SqmCaseSimple(SqmExpression<T> fixture, SqmExpressible<R> inherentType, int estimateWhenSize, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<T, R>>(estimateWhenSize);
        this.fixture = fixture;
    }

    @Override
    public SqmCaseSimple<T, R> copy(SqmCopyContext context) {
        SqmCaseSimple existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCaseSimple caseSearched = context.registerCopy(this, new SqmCaseSimple(this.fixture.copy(context), this.getNodeType(), this.whenFragments.size(), this.nodeBuilder()));
        for (WhenFragment<T, R> whenFragment : this.whenFragments) {
            caseSearched.whenFragments.add(new WhenFragment(whenFragment.checkValue.copy(context), whenFragment.result.copy(context)));
        }
        if (this.otherwise != null) {
            caseSearched.otherwise = this.otherwise.copy(context);
        }
        this.copyTo(caseSearched, context);
        return caseSearched;
    }

    public SqmExpression<T> getFixture() {
        return this.fixture;
    }

    public List<WhenFragment<T, R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<R> getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(SqmExpression<R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableResultType(otherwiseExpression.getNodeType());
    }

    public void when(SqmExpression<T> test, SqmExpression<R> result) {
        this.whenFragments.add(new WhenFragment<T, R>(test, result));
        this.applyInferableResultType(result.getNodeType());
    }

    private void applyInferableResultType(SqmExpressible<?> type) {
        if (type == null) {
            return;
        }
        SqmExpressible oldType = this.getNodeType();
        SqmExpressible newType = QueryHelper.highestPrecedenceType2(oldType, type);
        if (newType != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    protected void internalApplyInferableType(SqmExpressible newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSimpleCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<simple-case>";
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("case ");
        this.fixture.appendHqlString(sb);
        for (WhenFragment<T, R> whenFragment : this.whenFragments) {
            sb.append(" when ");
            whenFragment.checkValue.appendHqlString(sb);
            sb.append(" then ");
            whenFragment.result.appendHqlString(sb);
        }
        if (this.otherwise != null) {
            sb.append(" else ");
            this.otherwise.appendHqlString(sb);
        }
        sb.append(" end");
    }

    @Override
    public JpaExpression<T> getExpression() {
        return this.getFixture();
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, R result) {
        this.when(this.nodeBuilder().value(condition), this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, Expression<? extends R> result) {
        this.when(this.nodeBuilder().value(condition, (SqmExpression)result), (SqmExpression)result);
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(Expression<? extends T> condition, R result) {
        this.when(condition, (Expression<? extends R>)this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(Expression<? extends T> condition, Expression<? extends R> result) {
        this.when((SqmExpression)condition, (SqmExpression)result);
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(R result) {
        this.otherwise(this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<T, R> {
        private final SqmExpression<T> checkValue;
        private final SqmExpression<R> result;

        public WhenFragment(SqmExpression<T> checkValue, SqmExpression<R> result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        private WhenFragment(WhenFragment<T, R> original, SqmCopyContext context) {
            this.checkValue = original.checkValue.copy(context);
            this.result = original.result.copy(context);
        }

        public SqmExpression<T> getCheckValue() {
            return this.checkValue;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

