/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.persistence;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.persistence.IndexedKeyFormatMapper;
import org.wildfly.clustering.marshalling.spi.Formatter;
import org.wildfly.clustering.marshalling.spi.SimpleFormatter;

public class DynamicKeyFormatMapper
extends IndexedKeyFormatMapper {
    public DynamicKeyFormatMapper(ClassLoader loader) {
        super(DynamicKeyFormatMapper.load(loader));
    }

    private static List<Formatter<?>> load(ClassLoader loader) {
        LinkedList<Formatter> keyFormats = new LinkedList<Formatter>();
        for (Formatter keyFormat : ServiceLoader.load(Formatter.class, loader)) {
            keyFormats.add(keyFormat);
        }
        ArrayList result = new ArrayList(keyFormats.size() + 6);
        result.add((Formatter<?>)new SimpleFormatter(String.class, Function.identity()));
        result.add((Formatter<?>)new SimpleFormatter(Byte.class, Byte::valueOf));
        result.add((Formatter<?>)new SimpleFormatter(Short.class, Short::valueOf));
        result.add((Formatter<?>)new SimpleFormatter(Integer.class, Integer::valueOf));
        result.add((Formatter<?>)new SimpleFormatter(Long.class, Long::valueOf));
        result.add((Formatter<?>)new SimpleFormatter(UUID.class, UUID::fromString));
        result.addAll(keyFormats);
        return result;
    }
}

