/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jwt;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jwt.JWTContextResolver;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JsonSerialization {
    public static byte[] toByteArray(Object token, boolean indent) throws Exception {
        ResteasyProviderFactoryImpl factory = new ResteasyProviderFactoryImpl();
        factory.register((Object)new JWTContextResolver(indent));
        factory.register(ResteasyJackson2Provider.class);
        return JsonSerialization.toByteArray(token, (ResteasyProviderFactory)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object token, ResteasyProviderFactory factory) throws IOException {
        MessageBodyWriter writer = factory.getMessageBodyWriter(token.getClass(), null, null, MediaType.APPLICATION_JSON_TYPE);
        if (writer == null) {
            throw new NullPointerException(Messages.MESSAGES.couldNotFindMessageBodyWriterForJSON());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Providers old = (Providers)ResteasyContext.getContextData(Providers.class);
        ResteasyContext.pushContext(Providers.class, (Object)factory);
        try {
            writer.writeTo(token, token.getClass(), null, null, MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedHashMap(), (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            ResteasyContext.popContextData(Providers.class);
            if (old != null) {
                ResteasyContext.pushContext(Providers.class, (Object)old);
            }
        }
    }

    public static String toString(Object token, ResteasyProviderFactory factory) throws Exception {
        byte[] bytes = JsonSerialization.toByteArray(token, factory);
        return new String(bytes);
    }

    public static String toString(Object token, boolean indent) throws Exception {
        byte[] bytes = JsonSerialization.toByteArray(token, indent);
        return new String(bytes);
    }

    public static <T> T fromString(Class<T> type, String json) throws Exception {
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        return JsonSerialization.fromBytes(type, bytes);
    }

    public static <T> T fromString(Class<T> type, String json, ResteasyProviderFactory factory) throws Exception {
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        return JsonSerialization.fromBytes(type, bytes, factory);
    }

    public static <T> T fromBytes(Class<T> type, byte[] bytes) throws IOException {
        ResteasyProviderFactoryImpl factory = new ResteasyProviderFactoryImpl();
        factory.register(ResteasyJackson2Provider.class);
        factory.register(JWTContextResolver.class);
        return JsonSerialization.fromBytes(type, bytes, (ResteasyProviderFactory)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromBytes(Class<T> type, byte[] bytes, ResteasyProviderFactory factory) throws IOException {
        MessageBodyReader reader = factory.getMessageBodyReader(type, type, null, MediaType.APPLICATION_JSON_TYPE);
        if (reader == null) {
            throw new NullPointerException(Messages.MESSAGES.couldNotFindMessageBodyReaderForJSON());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Providers old = (Providers)ResteasyContext.getContextData(Providers.class);
        ResteasyContext.pushContext(Providers.class, (Object)factory);
        try {
            Object object = reader.readFrom(type, type, null, MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)bais);
            return (T)object;
        }
        finally {
            ResteasyContext.popContextData(Providers.class);
            if (old != null) {
                ResteasyContext.pushContext(Providers.class, (Object)old);
            }
        }
    }
}

