/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public abstract class AbstractHandlerChainsMetaDataParser {
    protected UnifiedHandlerChainsMetaData parseHandlerChains(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        return this.parseHandlerChains(reader, nsUri, nsUri, "handler-chains");
    }

    protected UnifiedHandlerChainsMetaData parseHandlerChains(XMLStreamReader reader, String nsUri, String handlerChainsElementNS, String handlerChainsElementName) throws XMLStreamException {
        ArrayList<UnifiedHandlerChainMetaData> handlerChains = new ArrayList<UnifiedHandlerChainMetaData>(1);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, handlerChainsElementNS, handlerChainsElementName)) {
                        return new UnifiedHandlerChainsMetaData(handlerChains);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, "http://java.sun.com/xml/ns/javaee", "handler-chain")) {
                        handlerChains.add(this.parseHandlerChain(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, "https://jakarta.ee/xml/ns/jakartaee", "handler-chain")) {
                        handlerChains.add(this.parseHandlerChain(reader, "https://jakarta.ee/xml/ns/jakartaee"));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private UnifiedHandlerChainMetaData parseHandlerChain(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        QName portNamePattern = null;
        QName serviceNamePattern = null;
        String protocolBindings = null;
        ArrayList<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>(4);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "handler-chain")) {
                        return new UnifiedHandlerChainMetaData(serviceNamePattern, portNamePattern, protocolBindings, handlers, false, null);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "port-name-pattern")) {
                        portNamePattern = StAXUtils.elementAsQName(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-name-pattern")) {
                        serviceNamePattern = StAXUtils.elementAsQName(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "protocol-bindings")) {
                        protocolBindings = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        handlers.add(this.parseHandler(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    protected UnifiedHandlerMetaData parseHandler(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        String handlerName = null;
        String handlerClass = null;
        LinkedList<UnifiedInitParamMetaData> initParams = new LinkedList<UnifiedInitParamMetaData>();
        HashSet<QName> soapHeaders = new HashSet<QName>(2);
        HashSet<String> soapRoles = new HashSet<String>(2);
        HashSet<String> portNames = new HashSet<String>(4);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        return new UnifiedHandlerMetaData(handlerClass, handlerName, initParams, soapHeaders, soapRoles, portNames);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "handler-name")) {
                        handlerName = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler-class")) {
                        handlerClass = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "init-param")) {
                        initParams.add(this.parseInitParam(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "soap-role")) {
                        soapRoles.add(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "soap-header")) {
                        soapHeaders.add(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private UnifiedInitParamMetaData parseInitParam(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        String paramName = null;
        String paramValue = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "init-param")) {
                        return new UnifiedInitParamMetaData(paramName, paramValue);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "param-name")) {
                        paramName = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "param-value")) {
                        paramValue = StAXUtils.elementAsString(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    protected abstract String getDescriptorForLogs();
}

