/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.webservices.dmr.Attribute;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.WSExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class WSSubsystem11Reader
implements XMLElementReader<List<ModelNode>> {
    WSSubsystem11Reader() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{WSExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)address);
        list.add(subsystem);
        this.readAttributes(reader, subsystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MODIFY_WSDL_ADDRESS: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String value = this.parseElementNoAttributes(reader);
                    Attributes.MODIFY_WSDL_ADDRESS.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block7;
                }
                case WSDL_HOST: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String value = this.parseElementNoAttributes(reader);
                    Attributes.WSDL_HOST.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block7;
                }
                case WSDL_PORT: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String value = this.parseElementNoAttributes(reader);
                    Attributes.WSDL_PORT.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block7;
                }
                case WSDL_SECURE_PORT: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String value = this.parseElementNoAttributes(reader);
                    Attributes.WSDL_SECURE_PORT.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block7;
                }
                case ENDPOINT_CONFIG: {
                    List<ModelNode> configs = this.readConfig(reader, address, false);
                    list.addAll(configs);
                    continue block7;
                }
            }
            this.handleUnknownElement(reader, address, element, list, encountered);
        }
    }

    protected void handleUnknownElement(XMLExtendedStreamReader reader, PathAddress parentAddress, Element element, List<ModelNode> list, EnumSet<Element> encountered) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    protected void readAttributes(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
    }

    protected String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }

    protected List<ModelNode> readConfig(XMLExtendedStreamReader reader, PathAddress parentAddress, boolean client) throws XMLStreamException {
        ArrayList<ModelNode> configs = new ArrayList<ModelNode>();
        String configName = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    configName = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathAddress address = parentAddress.append(client ? "client-config" : "endpoint-config", configName);
        ModelNode node = Util.createAddOperation((PathAddress)address);
        configs.add(node);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.PRE_HANDLER_CHAIN && element != Element.POST_HANDLER_CHAIN && element != Element.PROPERTY && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PRE_HANDLER_CHAIN: {
                    this.parseHandlerChain(reader, configs, true, address);
                    continue block9;
                }
                case POST_HANDLER_CHAIN: {
                    this.parseHandlerChain(reader, configs, false, address);
                    continue block9;
                }
                case PROPERTY: {
                    ModelNode operation = this.parseProperty(reader, address);
                    configs.add(operation);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return configs;
    }

    private ModelNode parseProperty(XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation(null);
        String propertyName = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block4;
                }
                case VALUE: {
                    Attributes.VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operation.get("address").set(parentAddress.append("property", propertyName).toModelNode());
        return operation;
    }

    private void parseHandlerChain(XMLExtendedStreamReader reader, List<ModelNode> operationList, boolean isPreHandlerChain, PathAddress parentAddress) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String handlerChainId = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    handlerChainId = value;
                    continue block7;
                }
                case PROTOCOL_BINDINGS: {
                    Attributes.PROTOCOL_BINDINGS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        String handlerChainType = isPreHandlerChain ? "pre-handler-chain" : "post-handler-chain";
        PathAddress address = parentAddress.append(handlerChainType, handlerChainId);
        operation.get("address").set(address.toModelNode());
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        LinkedList<ModelNode> addHandlerOperations = new LinkedList<ModelNode>();
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER: {
                    this.parseHandler(reader, addHandlerOperations, address);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operationList.add(operation);
        operationList.addAll(addHandlerOperations);
    }

    private void parseHandler(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        String handlerName = null;
        ModelNode operation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    handlerName = value;
                    continue block4;
                }
                case CLASS: {
                    Attributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operation.get("address").set(parentAddress.append("handler", handlerName).toModelNode());
        operations.add(operation);
    }
}

