/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.security.AccessController;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    static void setContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            });
        }
    }

    static void setContextClassLoader() {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(SecurityActions.class.getClassLoader());
        } else {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(SecurityActions.class.getClassLoader());
                return null;
            });
        }
    }
}

