/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.MVInDoubtTransaction;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.MetaType;
import org.h2.store.InDoubtTransaction;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public final class Store {
    private final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
    private final MVStore mvStore;
    private final TransactionStore transactionStore;
    private long statisticsStart;
    private int temporaryMapId;
    private final boolean encrypted;
    private final String fileName;

    static char[] decodePassword(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((byArray[i + i] & 0xFF) << 16 | byArray[i + i + 1] & 0xFF);
        }
        return cArray;
    }

    public Store(Database database) {
        Object object;
        byte[] byArray = database.getFileEncryptionKey();
        String string = database.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        boolean bl = false;
        if (string != null) {
            object = string + ".mv.db";
            MVStoreTool.compactCleanUp((String)object);
            builder.fileName((String)object);
            builder.pageSplitSize(database.getPageSize());
            if (database.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean bl2 = FileUtils.exists((String)object);
                if (!bl2 || FileUtils.canWrite((String)object)) {
                    String string2 = FileUtils.getParent((String)object);
                    FileUtils.createDirectories(string2);
                }
                int n = database.getSettings().autoCompactFillRate;
                if (n <= 100) {
                    builder.autoCompactFillRate(n);
                }
            }
            if (byArray != null) {
                bl = true;
                builder.encryptionKey(Store.decodePassword(byArray));
            }
            if (database.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler((thread, throwable) -> database.setBackgroundException(DbException.convert(throwable)));
            builder.autoCommitDisabled();
        }
        this.encrypted = bl;
        try {
            this.mvStore = builder.open();
            object = this.mvStore.getFileStore();
            String string3 = this.fileName = object != null ? ((FileStore)object).getFileName() : null;
            if (!database.getSettings().reuseSpace) {
                this.mvStore.setReuseSpace(false);
            }
            this.mvStore.setVersionsToKeep(0);
            this.transactionStore = new TransactionStore(this.mvStore, new MetaType<Database>(database, this.mvStore.backgroundExceptionHandler), new ValueDataType(database, null), database.getLockTimeout());
        }
        catch (MVStoreException mVStoreException) {
            throw this.convertMVStoreException(mVStoreException);
        }
    }

    DbException convertMVStoreException(MVStoreException mVStoreException) {
        switch (mVStoreException.getErrorCode()) {
            case 4: {
                throw DbException.get(90098, mVStoreException, this.fileName);
            }
            case 6: {
                if (this.encrypted) {
                    throw DbException.get(90049, mVStoreException, this.fileName);
                }
                throw DbException.get(90030, mVStoreException, this.fileName);
            }
            case 7: {
                throw DbException.get(90020, mVStoreException, this.fileName);
            }
            case 1: 
            case 2: {
                throw DbException.get(90028, mVStoreException, this.fileName);
            }
        }
        throw DbException.get(50000, mVStoreException, mVStoreException.getMessage());
    }

    public MVStore getMvStore() {
        return this.mvStore;
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public MVTable getTable(String string) {
        return this.tableMap.get(string);
    }

    public MVTable createTable(CreateTableData createTableData) {
        try {
            MVTable mVTable = new MVTable(createTableData, this);
            this.tableMap.put(mVTable.getMapName(), mVTable);
            return mVTable;
        }
        catch (MVStoreException mVStoreException) {
            throw this.convertMVStoreException(mVStoreException);
        }
    }

    public void removeTable(MVTable mVTable) {
        try {
            this.tableMap.remove(mVTable.getMapName());
        }
        catch (MVStoreException mVStoreException) {
            throw this.convertMVStoreException(mVStoreException);
        }
    }

    public void flush() {
        FileStore fileStore = this.mvStore.getFileStore();
        if (fileStore == null || fileStore.isReadOnly()) {
            return;
        }
        if (!this.mvStore.compact(50, 0x400000)) {
            this.mvStore.commit();
        }
    }

    public void closeImmediately() {
        if (!this.mvStore.isClosed()) {
            this.mvStore.closeImmediately();
        }
    }

    public void removeTemporaryMaps(BitSet bitSet) {
        for (String string : this.mvStore.getMapNames()) {
            int n;
            if (string.startsWith("temp.")) {
                this.mvStore.removeMap(string);
                continue;
            }
            if (!string.startsWith("table.") && !string.startsWith("index.") || bitSet.get(n = StringUtils.parseUInt31(string, string.indexOf(46) + 1, string.length()))) continue;
            this.mvStore.removeMap(string);
        }
    }

    public synchronized String nextTemporaryMapName() {
        return "temp." + this.temporaryMapId++;
    }

    public void prepareCommit(SessionLocal sessionLocal, String string) {
        Transaction transaction = sessionLocal.getTransaction();
        transaction.setName(string);
        transaction.prepare();
        this.mvStore.commit();
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        List<Transaction> list = this.transactionStore.getOpenTransactions();
        ArrayList<InDoubtTransaction> arrayList = Utils.newSmallArrayList();
        for (Transaction transaction : list) {
            if (transaction.getStatus() != 2) continue;
            arrayList.add(new MVInDoubtTransaction(this.mvStore, transaction));
        }
        return arrayList;
    }

    public void setCacheSize(int n) {
        this.mvStore.setCacheSize(Math.max(1, n / 1024));
    }

    public InputStream getInputStream() {
        FileChannel fileChannel = this.mvStore.getFileStore().getEncryptedFile();
        if (fileChannel == null) {
            fileChannel = this.mvStore.getFileStore().getFile();
        }
        return new FileChannelInputStream(fileChannel, false);
    }

    public void sync() {
        this.flush();
        this.mvStore.sync();
    }

    public void compactFile(int n) {
        this.mvStore.compactFile(n);
    }

    public void close(int n) {
        try {
            FileStore fileStore = this.mvStore.getFileStore();
            if (!this.mvStore.isClosed() && fileStore != null) {
                boolean bl;
                boolean bl2 = bl = n == -1;
                if (fileStore.isReadOnly()) {
                    bl = false;
                } else {
                    this.transactionStore.close();
                }
                if (bl) {
                    n = 0;
                }
                this.mvStore.close(n);
                String string = fileStore.getFileName();
                if (bl && FileUtils.exists(string)) {
                    MVStoreTool.compact(string, true);
                }
            }
        }
        catch (MVStoreException mVStoreException) {
            int n2 = mVStoreException.getErrorCode();
            if (n2 == 2 || n2 == 6) {
                // empty if block
            }
            this.mvStore.closeImmediately();
            throw DbException.get(90028, mVStoreException, "Closing");
        }
    }

    public void statisticsStart() {
        FileStore fileStore = this.mvStore.getFileStore();
        this.statisticsStart = fileStore == null ? 0L : fileStore.getReadCount();
    }

    public Map<String, Integer> statisticsEnd() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FileStore fileStore = this.mvStore.getFileStore();
        int n = fileStore == null ? 0 : (int)(fileStore.getReadCount() - this.statisticsStart);
        hashMap.put("reads", n);
        return hashMap;
    }
}

