/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected Entry[] fGrammars = null;
    protected boolean fPoolIsLocked;
    protected int fGrammarCount = 0;
    private static final boolean DEBUG = false;

    public XMLGrammarPoolImpl() {
        this.fGrammars = new Entry[11];
        this.fPoolIsLocked = false;
    }

    public XMLGrammarPoolImpl(int initialCapacity) {
        this.fGrammars = new Entry[initialCapacity];
        this.fPoolIsLocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int grammarSize = this.fGrammars.length;
            Grammar[] tempGrammars = new Grammar[this.fGrammarCount];
            int pos = 0;
            for (int i = 0; i < grammarSize; ++i) {
                Entry e = this.fGrammars[i];
                while (e != null) {
                    if (e.desc.getGrammarType().equals(grammarType)) {
                        tempGrammars[pos++] = e.grammar;
                    }
                    e = e.next;
                }
            }
            Grammar[] toReturn = new Grammar[pos];
            System.arraycopy(tempGrammars, 0, toReturn, 0, pos);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return toReturn;
        }
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        if (!this.fPoolIsLocked) {
            for (int i = 0; i < grammars.length; ++i) {
                this.putGrammar(grammars[i]);
            }
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return this.getGrammar(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putGrammar(Grammar grammar) {
        if (this.fPoolIsLocked) return;
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            XMLGrammarDescription desc = grammar.getGrammarDescription();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    entry.grammar = grammar;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                entry = entry.next;
            }
            this.fGrammars[index] = entry = new Entry(hash, desc, grammar, this.fGrammars[index]);
            ++this.fGrammarCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return entry.grammar;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar removeGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            Entry prev = null;
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    if (prev != null) {
                        prev.next = entry.next;
                    } else {
                        this.fGrammars[index] = entry.next;
                    }
                    Grammar tempGrammar = entry.grammar;
                    entry.grammar = null;
                    --this.fGrammarCount;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return tempGrammar;
                }
                prev = entry;
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public void lockPool() {
        this.fPoolIsLocked = true;
    }

    public void unlockPool() {
        this.fPoolIsLocked = false;
    }

    public void clear() {
        for (int i = 0; i < this.fGrammars.length; ++i) {
            if (this.fGrammars[i] == null) continue;
            this.fGrammars[i].clear();
            this.fGrammars[i] = null;
        }
        this.fGrammarCount = 0;
    }

    public boolean equals(XMLGrammarDescription desc1, XMLGrammarDescription desc2) {
        return desc1.equals(desc2);
    }

    public int hashCode(XMLGrammarDescription desc) {
        return desc.hashCode();
    }

    protected static final class Entry {
        public int hash;
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public Entry next;

        protected Entry(int hash, XMLGrammarDescription desc, Grammar grammar, Entry next) {
            this.hash = hash;
            this.desc = desc;
            this.grammar = grammar;
            this.next = next;
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            if (this.next != null) {
                this.next.clear();
                this.next = null;
            }
        }
    }
}

