/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.concurrent.Callable;
import org.apache.http.client.HttpClient;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.http.oidc.ClientCredentialsProviderUtils;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.HardcodedPublicKeyLocator;
import org.wildfly.security.http.oidc.HttpClientBuilder;
import org.wildfly.security.http.oidc.JWKPublicKeyLocator;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcJsonConfiguration;
import org.wildfly.security.jose.util.SystemPropertiesJsonParserFactory;
import org.wildfly.security.pem.Pem;

public class OidcClientConfigurationBuilder {
    protected OidcClientConfiguration oidcClientConfiguration = new OidcClientConfiguration();

    protected OidcClientConfigurationBuilder() {
    }

    protected OidcClientConfiguration internalBuild(OidcJsonConfiguration oidcJsonConfiguration) {
        if (oidcJsonConfiguration.getAuthServerUrl() != null && oidcJsonConfiguration.getRealm() == null) {
            throw ElytronMessages.log.keycloakRealmMissing();
        }
        if (oidcJsonConfiguration.getRealm() != null) {
            this.oidcClientConfiguration.setRealm(oidcJsonConfiguration.getRealm());
        }
        String resource = oidcJsonConfiguration.getResource();
        String clientId = oidcJsonConfiguration.getClientId();
        if (resource == null && clientId == null) {
            throw ElytronMessages.log.resourceOrClientIdMustBeSet();
        }
        this.oidcClientConfiguration.setResource(resource);
        this.oidcClientConfiguration.setClientId(clientId);
        String realmKeyPem = oidcJsonConfiguration.getRealmKey();
        if (realmKeyPem != null) {
            try {
                PublicKey realmKey = Pem.parsePemPublicKey((CodePointIterator)CodePointIterator.ofString((String)realmKeyPem));
                HardcodedPublicKeyLocator pkLocator = new HardcodedPublicKeyLocator(realmKey);
                this.oidcClientConfiguration.setPublicKeyLocator(pkLocator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JWKPublicKeyLocator pkLocator = new JWKPublicKeyLocator();
            this.oidcClientConfiguration.setPublicKeyLocator(pkLocator);
        }
        if (oidcJsonConfiguration.getSslRequired() != null) {
            this.oidcClientConfiguration.setSSLRequired(Oidc.SSLRequired.valueOf(oidcJsonConfiguration.getSslRequired().toUpperCase()));
        } else {
            this.oidcClientConfiguration.setSSLRequired(Oidc.SSLRequired.EXTERNAL);
        }
        if (oidcJsonConfiguration.getConfidentialPort() != -1) {
            this.oidcClientConfiguration.setConfidentialPort(oidcJsonConfiguration.getConfidentialPort());
        }
        if (oidcJsonConfiguration.getTokenStore() != null) {
            this.oidcClientConfiguration.setTokenStore(Oidc.TokenStore.valueOf(oidcJsonConfiguration.getTokenStore().toUpperCase()));
        } else {
            this.oidcClientConfiguration.setTokenStore(Oidc.TokenStore.SESSION);
        }
        if (oidcJsonConfiguration.getTokenCookiePath() != null) {
            this.oidcClientConfiguration.setOidcStateCookiePath(oidcJsonConfiguration.getTokenCookiePath());
        }
        if (oidcJsonConfiguration.getPrincipalAttribute() != null) {
            this.oidcClientConfiguration.setPrincipalAttribute(oidcJsonConfiguration.getPrincipalAttribute());
        }
        this.oidcClientConfiguration.setResourceCredentials(oidcJsonConfiguration.getCredentials());
        this.oidcClientConfiguration.setClientAuthenticator(ClientCredentialsProviderUtils.bootstrapClientAuthenticator(this.oidcClientConfiguration));
        this.oidcClientConfiguration.setPublicClient(oidcJsonConfiguration.isPublicClient());
        this.oidcClientConfiguration.setUseResourceRoleMappings(oidcJsonConfiguration.isUseResourceRoleMappings());
        this.oidcClientConfiguration.setUseRealmRoleMappings(oidcJsonConfiguration.isUseRealmRoleMappings());
        this.oidcClientConfiguration.setExposeToken(oidcJsonConfiguration.isExposeToken());
        if (oidcJsonConfiguration.isCors()) {
            this.oidcClientConfiguration.setCors(true);
            this.oidcClientConfiguration.setCorsMaxAge(oidcJsonConfiguration.getCorsMaxAge());
            this.oidcClientConfiguration.setCorsAllowedHeaders(oidcJsonConfiguration.getCorsAllowedHeaders());
            this.oidcClientConfiguration.setCorsAllowedMethods(oidcJsonConfiguration.getCorsAllowedMethods());
            this.oidcClientConfiguration.setCorsExposedHeaders(oidcJsonConfiguration.getCorsExposedHeaders());
        }
        if (oidcJsonConfiguration.isPkce()) {
            this.oidcClientConfiguration.setPkce(true);
        }
        this.oidcClientConfiguration.setBearerOnly(oidcJsonConfiguration.isBearerOnly());
        this.oidcClientConfiguration.setAutodetectBearerOnly(oidcJsonConfiguration.isAutodetectBearerOnly());
        this.oidcClientConfiguration.setEnableBasicAuth(oidcJsonConfiguration.isEnableBasicAuth());
        this.oidcClientConfiguration.setAlwaysRefreshToken(oidcJsonConfiguration.isAlwaysRefreshToken());
        this.oidcClientConfiguration.setRegisterNodeAtStartup(oidcJsonConfiguration.isRegisterNodeAtStartup());
        this.oidcClientConfiguration.setRegisterNodePeriod(oidcJsonConfiguration.getRegisterNodePeriod());
        this.oidcClientConfiguration.setTokenMinimumTimeToLive(oidcJsonConfiguration.getTokenMinimumTimeToLive());
        this.oidcClientConfiguration.setMinTimeBetweenJwksRequests(oidcJsonConfiguration.getMinTimeBetweenJwksRequests());
        this.oidcClientConfiguration.setPublicKeyCacheTtl(oidcJsonConfiguration.getPublicKeyCacheTtl());
        this.oidcClientConfiguration.setIgnoreOAuthQueryParameter(oidcJsonConfiguration.isIgnoreOAuthQueryParameter());
        this.oidcClientConfiguration.setRewriteRedirectRules(oidcJsonConfiguration.getRedirectRewriteRules());
        this.oidcClientConfiguration.setVerifyTokenAudience(oidcJsonConfiguration.isVerifyTokenAudience());
        if (realmKeyPem == null && oidcJsonConfiguration.isBearerOnly() && oidcJsonConfiguration.getAuthServerUrl() == null && oidcJsonConfiguration.getProviderUrl() == null) {
            throw ElytronMessages.log.invalidConfigurationForBearerAuth();
        }
        if (!(oidcJsonConfiguration.getAuthServerUrl() != null || oidcJsonConfiguration.getProviderUrl() != null || this.oidcClientConfiguration.isBearerOnly() && realmKeyPem != null)) {
            throw ElytronMessages.log.authServerUrlOrProviderUrlMustBeSet();
        }
        this.oidcClientConfiguration.setClient(this.createHttpClientProducer(oidcJsonConfiguration));
        this.oidcClientConfiguration.setAuthServerBaseUrl(oidcJsonConfiguration);
        this.oidcClientConfiguration.setProviderUrl(OidcClientConfigurationBuilder.sanitizeProviderUrl(oidcJsonConfiguration.getProviderUrl()));
        if (oidcJsonConfiguration.getTurnOffChangeSessionIdOnLogin() != null) {
            this.oidcClientConfiguration.setTurnOffChangeSessionIdOnLogin(oidcJsonConfiguration.getTurnOffChangeSessionIdOnLogin());
        }
        this.oidcClientConfiguration.setTokenSignatureAlgorithm(oidcJsonConfiguration.getTokenSignatureAlgorithm());
        return this.oidcClientConfiguration;
    }

    private static String sanitizeProviderUrl(String providerUrl) {
        if (providerUrl != null && providerUrl.endsWith("/")) {
            return providerUrl.substring(0, providerUrl.length() - 1);
        }
        return providerUrl;
    }

    private Callable<HttpClient> createHttpClientProducer(final OidcJsonConfiguration oidcJsonConfiguration) {
        return new Callable<HttpClient>(){
            private HttpClient client;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpClient call() {
                if (this.client == null) {
                    OidcClientConfiguration oidcClientConfiguration = OidcClientConfigurationBuilder.this.oidcClientConfiguration;
                    synchronized (oidcClientConfiguration) {
                        if (this.client == null) {
                            this.client = new HttpClientBuilder().build(oidcJsonConfiguration);
                        }
                    }
                }
                return this.client;
            }
        };
    }

    public static OidcClientConfiguration build(InputStream is) {
        OidcJsonConfiguration oidcJsonConfiguration = OidcClientConfigurationBuilder.loadOidcJsonConfiguration(is);
        return new OidcClientConfigurationBuilder().internalBuild(oidcJsonConfiguration);
    }

    public static OidcJsonConfiguration loadOidcJsonConfiguration(InputStream is) {
        OidcJsonConfiguration adapterConfig;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SystemPropertiesJsonParserFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            adapterConfig = (OidcJsonConfiguration)mapper.readValue(is, OidcJsonConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return adapterConfig;
    }

    public static OidcClientConfiguration build(OidcJsonConfiguration oidcJsonConfiguration) {
        return new OidcClientConfigurationBuilder().internalBuild(oidcJsonConfiguration);
    }
}

