/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMapMessageWrapper;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.junit.Assert;
import org.junit.Test;

public class AmqpManagementTest
extends AmqpClientTestSupport {
    private static final Binary BINARY_CORRELATION_ID = new Binary("mystring".getBytes(StandardCharsets.UTF_8));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testManagementQueryOverAMQP() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            String destinationAddress = this.getQueueName(1);
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("activemq.management");
            AmqpReceiver receiver = session.createReceiver(destinationAddress);
            receiver.flow(10);
            AmqpMessage request = new AmqpMessage();
            request.setApplicationProperty("_AMQ_ResourceName", (Object)"broker");
            request.setApplicationProperty("_AMQ_OperationName", (Object)"getQueueNames");
            request.setReplyToAddress(destinationAddress);
            request.setText("[]");
            sender.send(request);
            AmqpMessage response = receiver.receive(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            AmqpManagementTest.assertNotNull((Object)response);
            Section section = response.getWrappedMessage().getBody();
            AmqpManagementTest.assertTrue((boolean)(section instanceof AmqpValue));
            Object value = ((AmqpValue)section).getValue();
            AmqpManagementTest.assertTrue((boolean)(value instanceof String));
            AmqpManagementTest.assertTrue((((String)value).length() > 0 ? (byte)1 : 0) != 0);
            AmqpManagementTest.assertTrue((boolean)((String)value).contains(destinationAddress));
            response.accept();
        }
    }

    @Test(timeout=60000L)
    public void testUnsignedValues() throws Exception {
        int sequence = 42;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sequence", new UnsignedInteger(sequence));
        CoreMapMessageWrapper msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        AmqpManagementTest.assertEquals((long)msg.getInt("sequence"), (long)sequence);
        map.clear();
        map.put("sequence", new UnsignedLong((long)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        AmqpManagementTest.assertEquals((long)msg.getLong("sequence"), (long)sequence);
        map.clear();
        map.put("sequence", new UnsignedShort((short)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        AmqpManagementTest.assertEquals((long)msg.getShort("sequence"), (long)sequence);
        map.clear();
        map.put("sequence", new UnsignedByte((byte)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        AmqpManagementTest.assertEquals((long)msg.getByte("sequence"), (long)sequence);
    }

    @Test(timeout=60000L)
    public void testCorrelationByMessageIDUUID() throws Throwable {
        this.doTestReplyCorrelation(UUID.randomUUID(), false);
    }

    @Test(timeout=60000L)
    public void testCorrelationByMessageIDString() throws Throwable {
        this.doTestReplyCorrelation("mystring", false);
    }

    @Test(timeout=60000L)
    public void testCorrelationByMessageIDBinary() throws Throwable {
        this.doTestReplyCorrelation(BINARY_CORRELATION_ID, false);
    }

    @Test(timeout=60000L)
    public void testCorrelationByCorrelationIDUUID() throws Throwable {
        this.doTestReplyCorrelation(UUID.randomUUID(), true);
    }

    @Test(timeout=60000L)
    public void testCorrelationByCorrelationIDString() throws Throwable {
        this.doTestReplyCorrelation("mystring", true);
    }

    @Test(timeout=60000L)
    public void testCorrelationByCorrelationIDBinary() throws Throwable {
        this.doTestReplyCorrelation(BINARY_CORRELATION_ID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestReplyCorrelation(Object correlationId, boolean sendCorrelAsCorrelation) throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            String destinationAddress = this.getQueueName(1);
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("activemq.management");
            AmqpReceiver receiver = session.createReceiver(destinationAddress);
            receiver.flow(10);
            AmqpMessage request = new AmqpMessage();
            request.setApplicationProperty("_AMQ_ResourceName", (Object)"broker");
            request.setApplicationProperty("_AMQ_OperationName", (Object)"getQueueNames");
            request.setReplyToAddress(destinationAddress);
            if (sendCorrelAsCorrelation) {
                request.setRawCorrelationId(correlationId);
            } else {
                request.setRawMessageId(correlationId);
            }
            request.setText("[]");
            sender.send(request);
            AmqpMessage response = receiver.receive(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)correlationId, (Object)response.getRawCorrelationId());
            response.accept();
        }
    }
}

