/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Test;

public class ExpiryLargeMessageTest
extends ActiveMQTestBase {
    final SimpleString EXPIRY = new SimpleString("my-expiry");
    final SimpleString DLQ = new SimpleString("my-DLQ");
    final SimpleString MY_QUEUE = new SimpleString("MY-QUEUE");
    final int messageSize = 10240;
    final int numberOfMessages = 50;

    @Test
    public void testExpiryMessagesThenDLQ() throws Exception {
        int location;
        ClientMessage message;
        int rep;
        ActiveMQServer server = this.createServer(true);
        server.getConfiguration().setMessageExpiryScanPeriod(600000L);
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxDeliveryAttempts(5).setMaxSizeBytes(51200L).setPageSizeBytes(10240).setExpiryAddress(this.EXPIRY).setDeadLetterAddress(this.DLQ);
        server.getAddressSettingsRepository().addMatch(this.MY_QUEUE.toString(), (Object)setting);
        server.getAddressSettingsRepository().addMatch(this.EXPIRY.toString(), (Object)setting);
        server.start();
        server.createQueue(new QueueConfiguration(this.EXPIRY).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.DLQ).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.MY_QUEUE).setRoutingType(RoutingType.ANYCAST));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = sf.createSession(true, true, 0);
        byte[] bufferSample = new byte[10240];
        for (int i = 0; i < bufferSample.length; ++i) {
            bufferSample[i] = ExpiryLargeMessageTest.getSamplebyte((long)i);
        }
        ClientProducer producer = session.createProducer(this.MY_QUEUE);
        long timeToExpiry = System.currentTimeMillis() + 1000L;
        for (int i = 0; i < 50; ++i) {
            ClientMessage message2 = session.createMessage(true);
            message2.putIntProperty("count", i);
            if (i % 2 == 0) {
                message2.putBooleanProperty("tst-large", false);
                message2.getBodyBuffer().writeBytes(bufferSample);
            } else {
                message2.putBooleanProperty("tst-large", true);
                message2.setBodyInputStream(ExpiryLargeMessageTest.createFakeLargeStream((long)10240L));
            }
            message2.setExpiration(timeToExpiry);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        session.close();
        server.stop();
        server.start();
        Queue queueExpiry = server.locateQueue(this.EXPIRY);
        Queue myQueue = server.locateQueue(this.MY_QUEUE);
        sf = this.createSessionFactory(locator);
        Thread.sleep(1500L);
        Wait.assertEquals((int)50, () -> {
            myQueue.expireReferences();
            return this.getMessageCount(queueExpiry);
        });
        session = sf.createSession(false, false);
        ClientConsumer cons = session.createConsumer(this.EXPIRY);
        session.start();
        for (int i = 0; i < 25; ++i) {
            ClientMessage msg = cons.receive(5000L);
            ExpiryLargeMessageTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        cons.close();
        for (rep = 0; rep < 6; ++rep) {
            cons = session.createConsumer(this.EXPIRY);
            session.start();
            for (int i = 0; i < 25; ++i) {
                message = cons.receive(5000L);
                ExpiryLargeMessageTest.assertNotNull((Object)message);
                if (i % 10 == 0) {
                    this.instanceLog.debug((Object)("Received " + i));
                }
                for (location = 0; location < 10240; ++location) {
                    ExpiryLargeMessageTest.assertEquals((long)ExpiryLargeMessageTest.getSamplebyte((long)location), (long)message.getBodyBuffer().readByte());
                }
                message.acknowledge();
            }
            session.rollback();
            cons.close();
            session.close();
            sf.close();
            if (rep == 0) {
                server.stop();
                server.start();
            }
            sf = this.createSessionFactory(locator);
            session = sf.createSession(false, false);
            session.start();
        }
        cons = session.createConsumer(this.EXPIRY);
        session.start();
        ExpiryLargeMessageTest.assertNull((Object)cons.receiveImmediate());
        cons.close();
        session.close();
        sf.close();
        for (rep = 0; rep < 2; ++rep) {
            sf = this.createSessionFactory(locator);
            session = sf.createSession(false, false);
            cons = session.createConsumer(this.DLQ);
            session.start();
            for (int i = 0; i < 25; ++i) {
                message = cons.receive(5000L);
                ExpiryLargeMessageTest.assertNotNull((Object)message);
                if (i % 10 == 0) {
                    this.instanceLog.debug((Object)("Received " + i));
                }
                for (location = 0; location < 10240; ++location) {
                    ExpiryLargeMessageTest.assertEquals((long)ExpiryLargeMessageTest.getSamplebyte((long)location), (long)message.getBodyBuffer().readByte());
                }
                message.acknowledge();
            }
            if (rep != 0) continue;
            session.rollback();
            session.close();
            sf.close();
            server.stop();
            server.start();
        }
        session.commit();
        ExpiryLargeMessageTest.assertNull((Object)cons.receiveImmediate());
        session.close();
        sf.close();
        locator.close();
        this.validateNoFilesOnLargeDir();
    }

    @Test
    public void testExpiryMessagesAMQP() throws Exception {
        this.testExpiryMessagesAMQP(false, 307200);
    }

    @Test
    public void testExpiryMessagesAMQPRestartBeforeExpiry() throws Exception {
        this.testExpiryMessagesAMQP(true, 307200);
    }

    @Test
    public void testExpiryMessagesAMQPRegularMessageStandardMessage() throws Exception {
        this.testExpiryMessagesAMQP(false, 30);
    }

    @Test
    public void testExpiryMessagesAMQPRestartBeforeExpiryStandardMessage() throws Exception {
        this.testExpiryMessagesAMQP(true, 30);
    }

    public void testExpiryMessagesAMQP(boolean restartBefore, int bodySize) throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.getConfiguration().setMessageExpiryScanPeriod(6000L);
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxDeliveryAttempts(5).setMaxSizeBytes(51200L).setPageSizeBytes(10240).setExpiryAddress(this.EXPIRY).setDeadLetterAddress(this.DLQ);
        server.getAddressSettingsRepository().addMatch(this.MY_QUEUE.toString(), (Object)setting);
        server.getAddressSettingsRepository().addMatch(this.EXPIRY.toString(), (Object)setting);
        server.start();
        server.createQueue(new QueueConfiguration(this.EXPIRY).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.DLQ).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.MY_QUEUE).setRoutingType(RoutingType.ANYCAST));
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        byte[] bufferSample = new byte[bodySize];
        for (int i = 0; i < bufferSample.length; ++i) {
            bufferSample[i] = ExpiryLargeMessageTest.getSamplebyte((long)i);
        }
        jakarta.jms.Queue jmsQueue = session.createQueue(this.MY_QUEUE.toString());
        MessageProducer producer = session.createProducer((Destination)jmsQueue);
        producer.setTimeToLive(300L);
        for (int i = 0; i < 50; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(bufferSample);
            message.setIntProperty("count", i);
            producer.send((Message)message);
        }
        session.close();
        connection.close();
        if (restartBefore) {
            server.stop();
            server.start();
        }
        Queue queueExpiry = server.locateQueue(this.EXPIRY);
        Queue myQueue = server.locateQueue(this.MY_QUEUE);
        Wait.assertEquals((int)50, () -> {
            myQueue.expireReferences();
            return this.getMessageCount(queueExpiry);
        });
        if (!restartBefore) {
            server.stop();
            server.start();
        }
        connection = connectionFactory.createConnection();
        session = connection.createSession(true, 0);
        MessageConsumer cons = session.createConsumer((Destination)session.createQueue(this.EXPIRY.toString()));
        connection.start();
        for (int i = 0; i < 50; ++i) {
            Message msg = cons.receive(5000L);
            ExpiryLargeMessageTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        connection.close();
    }

    @Test
    public void testCompatilityWithLinks() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.getConfiguration().setMessageExpiryScanPeriod(600000L);
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxDeliveryAttempts(5).setMaxSizeBytes(-1L).setPageSizeBytes(10240).setExpiryAddress(this.EXPIRY).setDeadLetterAddress(this.DLQ);
        server.getAddressSettingsRepository().addMatch(this.MY_QUEUE.toString(), (Object)setting);
        server.getAddressSettingsRepository().addMatch(this.EXPIRY.toString(), (Object)setting);
        server.start();
        server.createQueue(new QueueConfiguration(this.EXPIRY).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.DLQ).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.MY_QUEUE).setRoutingType(RoutingType.ANYCAST));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = sf.createSession(true, true, 0);
        byte[] bufferSample = new byte[10240];
        for (int i = 0; i < bufferSample.length; ++i) {
            bufferSample[i] = ExpiryLargeMessageTest.getSamplebyte((long)i);
        }
        ClientProducer producer = session.createProducer(this.MY_QUEUE);
        long timeToExpiry = System.currentTimeMillis() + 1000L;
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("count", i);
            message.putBooleanProperty("tst-large", true);
            message.setBodyInputStream(ExpiryLargeMessageTest.createFakeLargeStream((long)10240L));
            message.setExpiration(timeToExpiry);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        server.stop();
        server.start();
        sf = this.createSessionFactory(locator);
        session = sf.createSession(true, true, 0);
        session.start();
        Thread.sleep(1500L);
        ClientConsumer cons = session.createConsumer(this.MY_QUEUE);
        ExpiryLargeMessageTest.assertNull((Object)cons.receive(1000L));
        session.close();
        session = sf.createSession(false, false);
        cons = session.createConsumer(this.EXPIRY);
        session.start();
        ClientMessage msg = cons.receive(5000L);
        ExpiryLargeMessageTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.rollback();
        server.stop();
        long messageID = msg.getMessageID();
        long oldID = msg.getLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIG_MESSAGE_ID);
        File largeMessagesFileDir = new File(this.getLargeMessagesDir());
        File oldFile = new File(largeMessagesFileDir, oldID + ".msg");
        File currentFile = new File(largeMessagesFileDir, messageID + ".msg");
        currentFile.renameTo(oldFile);
        server.start();
        sf = this.createSessionFactory(locator);
        session = sf.createSession(true, true, 0);
        session.start();
        cons = session.createConsumer(this.EXPIRY);
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = cons.receive(5000L);
            ExpiryLargeMessageTest.assertNotNull((Object)message);
            if (i % 10 == 0) {
                this.instanceLog.debug((Object)("Received " + i));
            }
            for (int location = 0; location < 10240; ++location) {
                ExpiryLargeMessageTest.assertEquals((long)ExpiryLargeMessageTest.getSamplebyte((long)location), (long)message.getBodyBuffer().readByte());
            }
            message.acknowledge();
        }
        session.commit();
        session.close();
    }
}

