/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Collection;
import java.util.Set;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.SessionState;
import org.junit.Test;

public class DisableAdvisoryTest
extends BasicOpenWireTest {
    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        Set acceptors = serverConfig.getAcceptorConfigurations();
        for (TransportConfiguration tc : acceptors) {
            if (!tc.getName().equals("netty")) continue;
            tc.getExtraParams().put("supportAdvisory", "false");
            break;
        }
    }

    @Test
    public void testAdvisoryCosnumerRemoveWarning() throws Exception {
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("This is a text message");
        producer.send((Message)message);
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        this.connection.start();
        TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
        ActiveMQSession owSession = (ActiveMQSession)session;
        RemotingService remotingService = this.server.getRemotingService();
        Set conns = remotingService.getConnections();
        DisableAdvisoryTest.assertEquals((long)1L, (long)conns.size());
        OpenWireConnection owconn = (OpenWireConnection)conns.iterator().next();
        Collection sstates = owconn.getState().getSessionStates();
        DisableAdvisoryTest.assertEquals((long)2L, (long)sstates.size());
        boolean hasAdvisoryConsumer = false;
        block0: for (SessionState state : sstates) {
            Collection cstates = state.getConsumerStates();
            for (ConsumerState cs : cstates) {
                cs.getInfo().getDestination();
                if (!AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)cs.getInfo().getDestination())) continue;
                hasAdvisoryConsumer = true;
                continue block0;
            }
        }
        DisableAdvisoryTest.assertTrue((boolean)hasAdvisoryConsumer);
    }
}

