/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer9Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)2}, {1, (byte)5}, {1, (byte)6}, {2, (byte)1}, {2, (byte)2}, {2, (byte)5}, {2, (byte)6});
    }

    public JMSConsumer9Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testMessageListenerWithConsumerWithPrefetch1() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)destination, 4);
        JMSConsumer9Test.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumer9Test.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    @Ignore
    public void testMessageListenerWithConsumer() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)destination, 4);
        JMSConsumer9Test.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumer9Test.assertEquals((long)4L, (long)counter.get());
    }
}

