/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Test;

public class RedeliveryPolicyTest
extends BasicOpenWireTest {
    @Override
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
    }

    @Test
    public void testGetNext() throws Exception {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        long delay = policy.getNextRedeliveryDelay(0L);
        RedeliveryPolicyTest.assertEquals((long)500L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)1000L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)2000L, (long)delay);
        policy.setUseExponentialBackOff(false);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)500L, (long)delay);
    }

    @Test
    public void testExponentialRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("testExponentialRedeliveryPolicyDelaysDeliveryOnRollback");
        this.makeSureCoreQueueExist("testExponentialRedeliveryPolicyDelaysDeliveryOnRollback");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(500L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
    }

    @Test
    public void testNornalRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("testNornalRedeliveryPolicyDelaysDeliveryOnRollback");
        this.makeSureCoreQueueExist("testNornalRedeliveryPolicyDelaysDeliveryOnRollback");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
    }

    @Test
    public void testDLQHandling() throws Exception {
        this.makeSureCoreQueueExist("ActiveMQ.DLQ");
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        RedeliveryPolicyTest.assertTrue((String)"cause exception has policy ref", (boolean)cause.contains("RedeliveryPolicy"));
        session.commit();
    }

    @Test
    public void testInfiniteMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testMaximumRedeliveryDelay() throws Exception {
        TextMessage m;
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(10L);
        policy.setUseExponentialBackOff(true);
        policy.setMaximumRedeliveries(-1);
        policy.setRedeliveryDelay(50L);
        policy.setMaximumRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        for (int i = 0; i < 10; ++i) {
            m = (TextMessage)consumer.receive(2000L);
            RedeliveryPolicyTest.assertNotNull((Object)m);
            RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
            session.rollback();
        }
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        RedeliveryPolicyTest.assertTrue((policy.getNextRedeliveryDelay(Long.MAX_VALUE) == 1000L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testZeroMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(0);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testInitialRedeliveryDelayZero() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        session.commit();
    }

    @Test
    public void testInitialRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    private void send(Session session, MessageProducer producer, Destination destination, String text) throws Exception {
        TextMessage message = session.createTextMessage(text);
        message.setStringProperty("texto", text);
        producer.send(destination, (Message)message);
    }

    @Test
    public void testRedeliveryPolicyPerDestination() throws Exception {
        RedeliveryPolicy queuePolicy = new RedeliveryPolicy();
        queuePolicy.setInitialRedeliveryDelay(0L);
        queuePolicy.setRedeliveryDelay(1000L);
        queuePolicy.setUseExponentialBackOff(false);
        queuePolicy.setMaximumRedeliveries(2);
        RedeliveryPolicy topicPolicy = new RedeliveryPolicy();
        topicPolicy.setInitialRedeliveryDelay(0L);
        topicPolicy.setRedeliveryDelay(1000L);
        topicPolicy.setUseExponentialBackOff(false);
        topicPolicy.setMaximumRedeliveries(3);
        RedeliveryPolicyMap map = this.connection.getRedeliveryPolicyMap();
        map.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)topicPolicy);
        map.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)queuePolicy);
        this.connection.setClientID("id1");
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQTopic topic = new ActiveMQTopic("TESTTOPIC");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        TopicSubscriber topicConsumer = session.createDurableSubscriber((Topic)topic, "tp1");
        this.send(session, producer, (Destination)queue, "1st");
        this.send(session, producer, (Destination)queue, "2nd");
        this.send(session, producer, (Destination)topic, "1st");
        this.send(session, producer, (Destination)topic, "2nd");
        session.commit();
        TextMessage m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRedlivery() throws Exception {
        try {
            Session session = this.connection.createSession(false, 2);
            this.makeSureCoreQueueExist("TEST");
            Queue queue = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
        }
        finally {
            this.connection.close();
        }
        for (int i = 0; i < 10; ++i) {
            this.connection = (ActiveMQConnection)this.factory.createConnection();
            this.connection.start();
            try {
                Session session = this.connection.createSession(false, 2);
                Queue queue = session.createQueue("TEST");
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                Message message = consumer.receive(1000L);
                RedeliveryPolicyTest.assertNotNull((String)("Message null on iteration " + i), (Object)message);
                if (i <= 0) continue;
                RedeliveryPolicyTest.assertTrue((boolean)message.getJMSRedelivered());
                continue;
            }
            finally {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyNoRedeliveryFlagAfterCloseNoReceive() throws Exception {
        Queue queue;
        Session session;
        try {
            session = this.connection.createSession(false, 2);
            this.makeSureCoreQueueExist("TEST");
            queue = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
        }
        finally {
            this.connection.close();
        }
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        try {
            session = this.connection.createSession(false, 2);
            queue = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TimeUnit.MILLISECONDS.sleep(500L);
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            RedeliveryPolicyTest.assertNotNull((String)"Message null", (Object)message);
            RedeliveryPolicyTest.assertFalse((boolean)message.getJMSRedelivered());
        }
        finally {
            this.connection.close();
        }
    }
}

