/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class NetworkAddressTestBase
extends ActiveMQTestBase {
    public static Map<NetworkInterface, InetAddress> getAddressForEachNetworkInterface() throws Exception {
        HashMap<NetworkInterface, InetAddress> map = new HashMap<NetworkInterface, InetAddress>();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        block0: while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> enumeration = iface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!(inetAddress instanceof Inet4Address)) continue;
                map.put(iface, inetAddress);
                continue block0;
            }
        }
        return map;
    }

    @Test
    public void testConnectToServerWithSameHost() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        if (map.size() > 0) {
            Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
            Iterator<Map.Entry<NetworkInterface, InetAddress>> iterator = set.iterator();
            InetAddress address = iterator.next().getValue();
            String host = address.getHostAddress();
            this.testConnection(host, host, true, 0);
        }
    }

    @Test
    public void testConnectToServerAcceptingAllHosts() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
        for (Map.Entry<NetworkInterface, InetAddress> entry : set) {
            String host = entry.getValue().getHostAddress();
            this.testConnection("0.0.0.0", host, true, 0);
        }
    }

    @Test
    public void testConnectToServerAcceptingOnlyAnotherHost() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        if (map.size() <= 1) {
            System.err.println("There must be at least 1 network interfaces: test will not be executed");
            return;
        }
        Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
        Iterator<Map.Entry<NetworkInterface, InetAddress>> iterator = set.iterator();
        Map.Entry<NetworkInterface, InetAddress> acceptorEntry = iterator.next();
        Map.Entry<NetworkInterface, InetAddress> connectorEntry = iterator.next();
        this.testConnection(acceptorEntry.getValue().getHostName(), connectorEntry.getValue().getHostAddress(), false, 0);
    }

    @Test
    public void testConnectToServerUsingLocalPort() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        if (map.size() <= 1) {
            System.err.println("There must be at least 1 network interfaces: test will not be executed");
            return;
        }
        Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
        Iterator<Map.Entry<NetworkInterface, InetAddress>> iterator = set.iterator();
        Map.Entry<NetworkInterface, InetAddress> entry = iterator.next();
        String host = entry.getValue().getHostAddress();
        this.testConnection(host, host, true, 7777);
    }

    @Test
    public void testConnectorToServerAcceptingAListOfHosts() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        if (map.size() <= 1) {
            System.err.println("There must be at least 2 network interfaces: test will not be executed");
            return;
        }
        Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
        Iterator<Map.Entry<NetworkInterface, InetAddress>> iterator = set.iterator();
        Map.Entry<NetworkInterface, InetAddress> entry1 = iterator.next();
        Map.Entry<NetworkInterface, InetAddress> entry2 = iterator.next();
        String listOfHosts = entry1.getValue().getHostAddress() + ", " + entry2.getValue().getHostAddress();
        this.testConnection(listOfHosts, entry1.getValue().getHostAddress(), true, 0);
        this.testConnection(listOfHosts, entry2.getValue().getHostAddress(), true, 0);
    }

    @Test
    public void testConnectorToServerAcceptingAListOfHosts_2() throws Exception {
        Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
        if (map.size() <= 2) {
            System.err.println("There must be at least 3 network interfaces: test will not be executed");
            return;
        }
        Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
        Iterator<Map.Entry<NetworkInterface, InetAddress>> iterator = set.iterator();
        Map.Entry<NetworkInterface, InetAddress> entry1 = iterator.next();
        Map.Entry<NetworkInterface, InetAddress> entry2 = iterator.next();
        Map.Entry<NetworkInterface, InetAddress> entry3 = iterator.next();
        String listOfHosts = entry1.getValue().getHostAddress() + ", " + entry2.getValue().getHostAddress();
        this.testConnection(listOfHosts, entry1.getValue().getHostAddress(), true, 0);
        this.testConnection(listOfHosts, entry2.getValue().getHostAddress(), true, 0);
        this.testConnection(listOfHosts, entry3.getValue().getHostAddress(), false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String acceptorHost, String connectorHost, boolean mustConnect, int localPort) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(this.getHostPropertyKey(), acceptorHost);
        TransportConfiguration acceptorConfig = new TransportConfiguration(this.getAcceptorFactoryClassName(), params);
        HashSet<TransportConfiguration> transportConfigs = new HashSet<TransportConfiguration>();
        transportConfigs.add(acceptorConfig);
        Configuration config = this.createDefaultNettyConfig();
        config.setAcceptorConfigurations(transportConfigs);
        ActiveMQServer messagingService = this.createServer(false, config);
        try {
            messagingService.start();
            params = new HashMap();
            params.put(this.getHostPropertyKey(), connectorHost);
            if (localPort != 0) {
                params.put(this.getLocalPortProperty(), localPort);
            }
            TransportConfiguration connectorConfig = new TransportConfiguration(this.getConnectorFactoryClassName(), params);
            ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{connectorConfig}));
            if (mustConnect) {
                ClientSessionFactory sf = this.createSessionFactory(locator);
                if (localPort != 0) {
                    Iterator iterator = messagingService.getRemotingService().getConnections().iterator();
                    Assert.assertTrue((String)"no connection created", (boolean)iterator.hasNext());
                    String address = ((RemotingConnection)iterator.next()).getTransportConnection().getRemoteAddress();
                    Assert.assertTrue((boolean)address.endsWith(":" + localPort));
                }
                sf.close();
            } else {
                try {
                    locator.createSessionFactory();
                    Assert.fail((String)"session creation must fail because connector must not be able to connect to the server bound to another network interface");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            messagingService.stop();
        }
    }

    protected abstract String getAcceptorFactoryClassName();

    protected abstract String getConnectorFactoryClassName();

    protected abstract String getHostPropertyKey();

    protected abstract String getLocalPortProperty();

    static {
        try {
            Map<NetworkInterface, InetAddress> map = NetworkAddressTestBase.getAddressForEachNetworkInterface();
            StringBuilder s = new StringBuilder("using network settings:\n");
            Set<Map.Entry<NetworkInterface, InetAddress>> set = map.entrySet();
            for (Map.Entry<NetworkInterface, InetAddress> entry : set) {
                s.append(entry.getKey().getDisplayName() + ": " + entry.getValue().getHostAddress() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

