/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrameV12;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompFrameFactoryV11;

public class StompFrameFactoryV12
extends StompFrameFactoryV11 {
    @Override
    public String[] handleHeaders(String header) {
        String[] result = header.split(":");
        for (int j = 0; j < result.length; ++j) {
            StringBuffer decodedHeader = new StringBuffer();
            boolean isEsc = false;
            block7: for (int i = 0; i < result[j].length(); ++i) {
                char b = result[j].charAt(i);
                switch (b) {
                    case '\\': {
                        if (isEsc) {
                            decodedHeader.append(b);
                            isEsc = false;
                            continue block7;
                        }
                        isEsc = true;
                        continue block7;
                    }
                    case 'c': {
                        if (isEsc) {
                            decodedHeader.append(":");
                            isEsc = false;
                            continue block7;
                        }
                        decodedHeader.append(b);
                        continue block7;
                    }
                    case 'n': {
                        if (isEsc) {
                            decodedHeader.append('\n');
                            isEsc = false;
                            continue block7;
                        }
                        decodedHeader.append(b);
                        continue block7;
                    }
                    case 'r': {
                        if (isEsc) {
                            decodedHeader.append('\r');
                            isEsc = false;
                            continue block7;
                        }
                        decodedHeader.append(b);
                        continue block7;
                    }
                    default: {
                        decodedHeader.append(b);
                    }
                }
            }
            result[j] = decodedHeader.toString();
        }
        return result;
    }

    @Override
    public ClientStompFrame newFrame(String command) {
        return new ClientStompFrameV12(command);
    }

    @Override
    public ClientStompFrame newAnyFrame(String command) {
        return new ClientStompFrameV12(command, true, false);
    }
}

