/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.v11;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.v11.StompFrameHandlerV11;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV11;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StompV11Test
extends StompTestBase {
    public static final String CLIENT_ID = "myclientid";
    private StompClientConnection conn;
    private URI v10Uri;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v11.stomp"}, {"tcp+v11.stomp"});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.v10Uri = new URI(this.uri.toString().replace("v11", "v10"));
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            boolean connected;
            boolean bl = connected = this.conn != null && this.conn.isConnected();
            if (connected) {
                this.conn.disconnect();
            }
        }
        finally {
            super.tearDown();
            this.conn.closeTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnection() throws Exception {
        this.server.getSecurityStore().setSecurityEnabled(true);
        StompClientConnection connection = StompClientConnectionFactory.createClientConnection(this.v10Uri);
        try {
            connection.connect(this.defUser, this.defPass);
            StompV11Test.assertTrue((boolean)connection.isConnected());
            StompV11Test.assertEquals((Object)"1.0", (Object)connection.getVersion());
            connection.disconnect();
            connection.closeTransport();
            connection = StompClientConnectionFactory.createClientConnection(this.uri);
            connection.connect(this.defUser, this.defPass);
            StompV11Test.assertTrue((boolean)connection.isConnected());
            StompV11Test.assertEquals((Object)"1.1", (Object)connection.getVersion());
            connection.disconnect();
            connection.closeTransport();
            connection = StompClientConnectionFactory.createClientConnection(this.uri);
            connection.connect();
            StompV11Test.assertFalse((boolean)connection.isConnected());
            StompClientConnectionV11 conn = (StompClientConnectionV11)StompClientConnectionFactory.createClientConnection(this.uri);
            conn.connect1(this.defUser, this.defPass);
            StompV11Test.assertTrue((boolean)conn.isConnected());
            conn.disconnect();
            conn.closeTransport();
            conn = (StompClientConnectionV11)StompClientConnectionFactory.createClientConnection(this.uri);
            ClientStompFrame frame = conn.connect("invaliduser", this.defPass);
            StompV11Test.assertFalse((boolean)conn.isConnected());
            StompV11Test.assertTrue((boolean)"ERROR".equals(frame.getCommand()));
            StompV11Test.assertTrue((boolean)frame.getBody().contains("Security Error occurred"));
            conn.closeTransport();
        }
        finally {
            connection.closeTransport();
        }
    }

    @Test
    public void testNegotiation() throws Exception {
        ClientStompFrame frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        ClientStompFrame reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals(null, (Object)reply.getHeader("version"));
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("accept-version", "1.0").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"1.0", (Object)reply.getHeader("version"));
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("accept-version", "1.1").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"1.1", (Object)reply.getHeader("version"));
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("accept-version", "1.0,1.1,1.3").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"1.1", (Object)reply.getHeader("version"));
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("accept-version", "1.3").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"ERROR", (Object)reply.getCommand());
        this.instanceLog.debug((Object)("Got error frame " + reply));
    }

    @Test
    public void testServerFrame() throws Exception {
        ClientStompFrame frame = this.conn.connect(this.defUser, this.defPass);
        this.conn.disconnect();
        StompV11Test.assertTrue((frame.getHeader("server") != null ? (byte)1 : 0) != 0);
        this.server.getRemotingService().destroyAcceptor("stomp");
        this.server.getRemotingService().createAcceptor("stomp", "tcp://localhost:61613?disableStompServerHeader=false").start();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.connect(this.defUser, this.defPass);
        this.conn.disconnect();
        StompV11Test.assertTrue((frame.getHeader("server") != null ? (byte)1 : 0) != 0);
        this.server.getRemotingService().destroyAcceptor("stomp");
        this.server.getRemotingService().createAcceptor("stomp", "tcp://localhost:61613?disableStompServerHeader=true").start();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.connect(this.defUser, this.defPass);
        this.conn.disconnect();
        StompV11Test.assertTrue((frame.getHeader("server") == null ? (byte)1 : 0) != 0);
    }

    @Test
    public void testSendAndReceive() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame response = StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World 1!");
        StompV11Test.assertNull((Object)response);
        String uuid = UUID.randomUUID().toString();
        response = StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World 2!", true);
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        newConn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(newConn, "a-sub");
        ClientStompFrame frame = newConn.receiveFrame();
        this.instanceLog.debug((Object)("received " + frame));
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        StompV11Test.assertEquals((Object)"a-sub", (Object)frame.getHeader("subscription"));
        StompV11Test.assertNotNull((Object)frame.getHeader("message-id"));
        StompV11Test.assertEquals((Object)(StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()), (Object)frame.getHeader("destination"));
        StompV11Test.assertEquals((Object)"Hello World 1!", (Object)frame.getBody());
        frame = newConn.receiveFrame();
        this.instanceLog.debug((Object)("received " + frame));
        StompV11Test.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
    }

    @Test
    public void testHeaderContentType() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "application/xml", "Hello World 1!");
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        newConn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(newConn, "a-sub");
        ClientStompFrame frame = newConn.receiveFrame();
        this.instanceLog.debug((Object)("received " + frame));
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        StompV11Test.assertEquals((Object)"application/xml", (Object)frame.getHeader("content-type"));
        StompV11Test.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
    }

    @Test
    public void testHeaderContentLength() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        String body = "Hello World 1!";
        String cLen = String.valueOf(body.getBytes(StandardCharsets.UTF_8).length);
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("content-type", "application/xml").addHeader("content-length", cLen).setBody(body + "extra");
        this.conn.sendFrame(frame);
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        newConn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(newConn, "a-sub");
        frame = newConn.receiveFrame();
        this.instanceLog.debug((Object)("received " + frame));
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        StompV11Test.assertEquals((Object)cLen, (Object)frame.getHeader("content-length"));
        StompV11Test.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
    }

    @Test
    public void testHeaderEncoding() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        String body = "Hello World 1!";
        String cLen = String.valueOf(body.getBytes(StandardCharsets.UTF_8).length);
        String hKey = "special-header\\\\\\n\\c";
        String hVal = "\\c\\\\\\ngood";
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("content-type", "application/xml").addHeader("content-length", cLen).addHeader(hKey, hVal);
        this.instanceLog.debug((Object)("key: |" + hKey + "| val: |" + hVal + "|"));
        frame.setBody(body);
        this.conn.sendFrame(frame);
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        newConn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(newConn, "a-sub");
        frame = newConn.receiveFrame();
        this.instanceLog.debug((Object)("received " + frame));
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        String value = frame.getHeader("special-header\\\n:");
        StompV11Test.assertEquals((Object)":\\\ngood", (Object)value);
        StompV11Test.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
    }

    @Test
    public void testHeaderUndefinedEscape() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = this.conn.createFrame("SEND");
        String body = "Hello World 1!";
        String cLen = String.valueOf(body.getBytes(StandardCharsets.UTF_8).length);
        frame.addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName());
        frame.addHeader("content-type", "text/plain");
        frame.addHeader("content-length", cLen);
        String hKey = "undefined-escape";
        String hVal = "is\\ttab";
        frame.addHeader(hKey, hVal);
        this.instanceLog.debug((Object)("key: |" + hKey + "| val: |" + hVal + "|"));
        frame.setBody(body);
        this.conn.sendFrame(frame);
        ClientStompFrame error = this.conn.receiveFrame();
        this.instanceLog.debug((Object)("received " + error));
        String desc = "Should have received an ERROR for undefined escape sequence";
        Assert.assertNotNull((String)desc, (Object)error);
        Assert.assertEquals((String)desc, (Object)"ERROR", (Object)error.getCommand());
    }

    @Test
    public void testHeartBeat() throws Exception {
        ClientStompFrame frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        ClientStompFrame reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        Thread.sleep(5000L);
        StompV11Test.assertEquals((long)0L, (long)this.conn.getFrameQueueSize());
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "0,0").addHeader("accept-version", "1.0,1.1");
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,30000", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(5000L);
        StompV11Test.assertEquals((long)0L, (long)this.conn.getFrameQueueSize());
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "1,0").addHeader("accept-version", "1.0,1.1");
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,500", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(2000L);
        try {
            StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World");
            StompV11Test.fail((String)"connection should have been destroyed by now");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "1,0").addHeader("accept-version", "1.0,1.1");
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,500", (Object)reply.getHeader("heart-beat"));
        this.instanceLog.debug((Object)"========== start pinger!");
        this.conn.startPinger(500L);
        Thread.sleep(2000L);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World");
        this.conn.stopPinger();
        this.conn.disconnect();
    }

    @Test
    public void testHeartBeat2() throws Exception {
        ClientStompFrame frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "1,1").addHeader("accept-version", "1.0,1.1");
        ClientStompFrame reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"500,500", (Object)reply.getHeader("heart-beat"));
        this.conn.disconnect();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "500,1000").addHeader("accept-version", "1.0,1.1");
        reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"1000,500", (Object)reply.getHeader("heart-beat"));
        this.instanceLog.debug((Object)"========== start pinger!");
        this.conn.startPinger(500L);
        Thread.sleep(10000L);
        int size = this.conn.getServerPingNumber();
        this.instanceLog.debug((Object)("ping received: " + size));
        StompV11Test.assertTrue((size > 5 ? (byte)1 : 0) != 0);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World");
        this.conn.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendWithHeartBeatsAndReceive() throws Exception {
        StompClientConnection newConn = null;
        try {
            ClientStompFrame frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "500,1000").addHeader("accept-version", "1.0,1.1");
            this.conn.sendFrame(frame);
            this.conn.startPinger(500L);
            for (int i = 0; i < 10; ++i) {
                StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World " + i + "!");
                Thread.sleep(500L);
            }
            newConn = StompClientConnectionFactory.createClientConnection(this.uri);
            newConn.connect(this.defUser, this.defPass);
            StompV11Test.subscribe(newConn, "a-sub");
            int cnt = 0;
            frame = newConn.receiveFrame();
            while (frame != null) {
                ++cnt;
                Thread.sleep(500L);
                frame = newConn.receiveFrame(5000L);
            }
            StompV11Test.assertEquals((long)10L, (long)cnt);
            StompV11Test.unsubscribe(newConn, "a-sub");
        }
        finally {
            if (newConn != null) {
                newConn.disconnect();
            }
            this.conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendAndReceiveWithHeartBeats() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        for (int i = 0; i < 10; ++i) {
            StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World " + i + "!");
            Thread.sleep(500L);
        }
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            ClientStompFrame frame = newConn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "500,1000").addHeader("accept-version", "1.0,1.1");
            newConn.sendFrame(frame);
            newConn.startPinger(500L);
            Thread.sleep(500L);
            StompV11Test.subscribe(newConn, "a-sub");
            int cnt = 0;
            frame = newConn.receiveFrame();
            while (frame != null) {
                ++cnt;
                Thread.sleep(500L);
                frame = newConn.receiveFrame(5000L);
            }
            StompV11Test.assertEquals((long)10L, (long)cnt);
            StompV11Test.unsubscribe(newConn, "a-sub");
        }
        finally {
            newConn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendWithHeartBeatsAndReceiveWithHeartBeats() throws Exception {
        StompClientConnection newConn = null;
        try {
            ClientStompFrame frame = this.conn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "500,1000").addHeader("accept-version", "1.0,1.1");
            this.conn.sendFrame(frame);
            this.conn.startPinger(500L);
            for (int i = 0; i < 10; ++i) {
                StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World " + i + "!");
                Thread.sleep(500L);
            }
            newConn = StompClientConnectionFactory.createClientConnection(this.uri);
            frame = newConn.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "500,1000").addHeader("accept-version", "1.0,1.1");
            newConn.sendFrame(frame);
            newConn.startPinger(500L);
            Thread.sleep(500L);
            StompV11Test.subscribe(newConn, "a-sub");
            int cnt = 0;
            frame = newConn.receiveFrame();
            while (frame != null) {
                ++cnt;
                Thread.sleep(500L);
                frame = newConn.receiveFrame(5000L);
            }
            StompV11Test.assertEquals((long)10L, (long)cnt);
            StompV11Test.unsubscribe(newConn, "a-sub");
        }
        finally {
            if (newConn != null) {
                newConn.disconnect();
            }
            this.conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartBeatToTTL() throws Exception {
        int port = 61614;
        this.uri = StompV11Test.createStompClientUri(this.scheme, this.hostname, port);
        this.server.getRemotingService().createAcceptor("test", "tcp://127.0.0.1:" + port + "?connectionTtl=1000&connectionTtlMin=5000&connectionTtlMax=10000").start();
        StompClientConnection connection = StompClientConnectionFactory.createClientConnection(this.uri);
        ClientStompFrame frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass);
        ClientStompFrame reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        Thread.sleep(3000L);
        StompV11Test.assertEquals((Object)"ERROR", (Object)connection.receiveFrame(1000L).getCommand());
        StompV11Test.assertEquals((long)0L, (long)connection.getFrameQueueSize());
        try {
            StompV11Test.assertFalse((boolean)connection.isConnected());
        }
        catch (Exception exception) {
        }
        finally {
            connection.closeTransport();
        }
        connection = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "0,0").addHeader("accept-version", "1.0,1.1");
        reply = connection.sendFrame(frame);
        this.instanceLog.debug((Object)("Reply: " + reply));
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,500", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(3000L);
        StompV11Test.assertEquals((Object)"ERROR", (Object)connection.receiveFrame(1000L).getCommand());
        StompV11Test.assertEquals((long)0L, (long)connection.getFrameQueueSize());
        try {
            StompV11Test.assertFalse((boolean)connection.isConnected());
        }
        catch (Exception exception) {
        }
        finally {
            connection.closeTransport();
        }
        connection = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "1,0").addHeader("accept-version", "1.0,1.1");
        reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,2500", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(7000L);
        try {
            StompV11Test.assertFalse((boolean)connection.isConnected());
        }
        catch (Exception exception) {
        }
        finally {
            connection.closeTransport();
        }
        connection = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "1,0").addHeader("accept-version", "1.0,1.1");
        reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,2500", (Object)reply.getHeader("heart-beat"));
        this.instanceLog.debug((Object)"========== start pinger!");
        connection.startPinger(2500L);
        Thread.sleep(7000L);
        StompV11Test.send(connection, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World");
        connection.stopPinger();
        connection.disconnect();
        connection = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "20000,0").addHeader("accept-version", "1.0,1.1");
        reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,5000", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(12000L);
        try {
            StompV11Test.assertFalse((boolean)connection.isConnected());
        }
        catch (Exception exception) {
        }
        finally {
            connection.closeTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartBeatToConnectionTTLModifier() throws Exception {
        int port = 61614;
        this.server.getRemotingService().createAcceptor("test", "tcp://127.0.0.1:" + port + "?heartBeatToConnectionTtlModifier=1").start();
        StompClientConnection connection = StompClientConnectionFactory.createClientConnection(this.uri);
        ClientStompFrame frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "5000,0").addHeader("accept-version", "1.0,1.1");
        ClientStompFrame reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,5000", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(6000L);
        try {
            StompV11Test.assertFalse((boolean)connection.isConnected());
        }
        finally {
            connection.closeTransport();
        }
        this.server.getRemotingService().destroyAcceptor("test");
        this.server.getRemotingService().createAcceptor("test", "tcp://127.0.0.1:" + port + "?heartBeatToConnectionTtlModifier=1.5").start();
        connection = StompClientConnectionFactory.createClientConnection(this.uri);
        frame = connection.createFrame("CONNECT").addHeader("host", "127.0.0.1").addHeader("login", this.defUser).addHeader("passcode", this.defPass).addHeader("heart-beat", "5000,0").addHeader("accept-version", "1.0,1.1");
        reply = connection.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"0,5000", (Object)reply.getHeader("heart-beat"));
        Thread.sleep(6000L);
        connection.disconnect();
    }

    @Test
    public void testNack() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        StompV11Test.nack(this.conn, "sub1", messageID);
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testNackWithWrongSubId() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        StompV11Test.nack(this.conn, "sub2", messageID);
        ClientStompFrame error = this.conn.receiveFrame();
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testNackWithWrongMessageId() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        frame.getHeader("message-id");
        StompV11Test.nack(this.conn, "sub2", "someother");
        ClientStompFrame error = this.conn.receiveFrame();
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testAck() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        StompV11Test.ack(this.conn, "sub1", messageID, null);
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testAckWithWrongSubId() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        StompV11Test.ack(this.conn, "sub2", messageID, null);
        ClientStompFrame error = this.conn.receiveFrame();
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testAckWithWrongMessageId() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        frame.getHeader("message-id");
        StompV11Test.ack(this.conn, "sub2", "someother", null);
        ClientStompFrame error = this.conn.receiveFrame();
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testErrorWithReceipt() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        ClientStompFrame ackFrame = this.conn.createFrame("ACK").addHeader("subscription", "sub2").addHeader("message-id", messageID).addHeader("receipt", "answer-me");
        ClientStompFrame error = this.conn.sendFrame(ackFrame);
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.assertEquals((Object)"ERROR", (Object)error.getCommand());
        StompV11Test.assertEquals((Object)"answer-me", (Object)error.getHeader("receipt-id"));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testErrorWithReceipt2() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        String messageID = frame.getHeader("message-id");
        ClientStompFrame ackFrame = this.conn.createFrame("ACK").addHeader("subscription", "sub1").addHeader("message-id", String.valueOf(Long.valueOf(messageID) + 1L)).addHeader("receipt", "answer-me");
        ClientStompFrame error = this.conn.sendFrame(ackFrame);
        this.instanceLog.debug((Object)("Receiver error: " + error));
        StompV11Test.assertEquals((Object)"ERROR", (Object)error.getCommand());
        StompV11Test.assertEquals((Object)"answer-me", (Object)error.getHeader("receipt-id"));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testAckModeClient() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        int num = 50;
        for (int i = 0; i < num; ++i) {
            this.sendJmsMessage("client-ack" + i);
        }
        ClientStompFrame frame = null;
        for (int i = 0; i < num; ++i) {
            frame = this.conn.receiveFrame();
            StompV11Test.assertNotNull((Object)frame);
        }
        StompV11Test.ack(this.conn, "sub1", frame);
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testAckModeClient2() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        Thread.sleep(1000L);
        int num = 50;
        for (int i = 0; i < num; ++i) {
            this.sendJmsMessage("client-ack" + i);
        }
        ClientStompFrame frame = null;
        for (int i = 0; i < num; ++i) {
            frame = this.conn.receiveFrame();
            StompV11Test.assertNotNull((Object)frame);
            if (i != num - 2) continue;
            StompV11Test.ack(this.conn, "sub1", frame);
        }
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(10000L);
        Assert.assertNotNull((Object)message);
        message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testAckModeAuto() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        int num = 50;
        for (int i = 0; i < num; ++i) {
            this.sendJmsMessage("auto-ack" + i);
        }
        ClientStompFrame frame = null;
        for (int i = 0; i < num; ++i) {
            frame = this.conn.receiveFrame();
            StompV11Test.assertNotNull((Object)frame);
        }
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testAckModeClientIndividual() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client-individual");
        int num = 50;
        for (int i = 0; i < num; ++i) {
            this.sendJmsMessage("client-individual-ack" + i);
        }
        ClientStompFrame frame = null;
        for (int i = 0; i < num; ++i) {
            frame = this.conn.receiveFrame();
            StompV11Test.assertNotNull((Object)frame);
            this.instanceLog.debug((Object)(i + " == received: " + frame));
            if (i % 2 != 0) continue;
            StompV11Test.ack(this.conn, "sub1", frame);
        }
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        TextMessage message = null;
        for (int i = 0; i < num / 2; ++i) {
            message = (TextMessage)consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            this.instanceLog.debug((Object)("Legal: " + message.getText()));
        }
        message = (TextMessage)consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testTwoSubscribers() throws Exception {
        this.conn.connect(this.defUser, this.defPass, CLIENT_ID);
        StompV11Test.subscribeTopic(this.conn, "sub1", "auto", null);
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(this.uri);
        newConn.connect(this.defUser, this.defPass, "myclientid2");
        StompV11Test.subscribeTopic(newConn, "sub2", "auto", null);
        StompV11Test.send(newConn, StompV11Test.getTopicPrefix() + StompV11Test.getTopicName(), null, "Hello World");
        ClientStompFrame frame = this.conn.receiveFrame(5000L);
        this.instanceLog.debug((Object)("received frame : " + frame));
        StompV11Test.assertEquals((Object)"Hello World", (Object)frame.getBody());
        StompV11Test.assertEquals((Object)"sub1", (Object)frame.getHeader("subscription"));
        frame = newConn.receiveFrame(5000L);
        this.instanceLog.debug((Object)("received 2 frame : " + frame));
        StompV11Test.assertEquals((Object)"Hello World", (Object)frame.getBody());
        StompV11Test.assertEquals((Object)"sub2", (Object)frame.getHeader("subscription"));
        StompV11Test.unsubscribe(this.conn, "sub1", true);
        StompV11Test.unsubscribe(newConn, "sub2", true);
        this.conn.disconnect();
        newConn.disconnect();
    }

    @Test
    public void testSendAndReceiveOnDifferentConnections() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World");
        StompClientConnection connV11_2 = StompClientConnectionFactory.createClientConnection(this.uri);
        connV11_2.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(connV11_2, "sub1", "auto");
        ClientStompFrame frame = connV11_2.receiveFrame(2000L);
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        StompV11Test.assertEquals((Object)"Hello World", (Object)frame.getBody());
        this.conn.disconnect();
        connV11_2.disconnect();
    }

    @Test
    public void testBeginSameTransactionTwice() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.beginTransaction(this.conn, "tx1");
        StompV11Test.beginTransaction(this.conn, "tx1");
        ClientStompFrame f = this.conn.receiveFrame();
        Assert.assertTrue((boolean)f.getCommand().equals("ERROR"));
    }

    @Test
    public void testBodyWithUTF8() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, this.getName(), "auto");
        String text = "A\u00ea\u00f1\u00fcC";
        this.instanceLog.debug((Object)text);
        this.sendJmsMessage(text);
        ClientStompFrame frame = this.conn.receiveFrame();
        this.instanceLog.debug((Object)frame);
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertNotNull((Object)frame.getHeader("destination"));
        Assert.assertTrue((boolean)frame.getBody().equals(text));
        this.conn.disconnect();
    }

    @Test
    public void testClientAckNotPartOfTransaction() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, this.getName(), "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertNotNull((Object)frame.getHeader("destination"));
        Assert.assertTrue((boolean)frame.getBody().equals(this.getName()));
        Assert.assertNotNull((Object)frame.getHeader("message-id"));
        String messageID = frame.getHeader("message-id");
        StompV11Test.beginTransaction(this.conn, "tx1");
        StompV11Test.ack(this.conn, this.getName(), messageID, "tx1");
        StompV11Test.abortTransaction(this.conn, "tx1");
        frame = this.conn.receiveFrame(100L);
        StompV11Test.assertNull((Object)frame);
        StompV11Test.unsubscribe(this.conn, this.getName());
        this.conn.disconnect();
    }

    @Test
    public void testDisconnectAndError() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, this.getName(), "client");
        String uuid = UUID.randomUUID().toString();
        ClientStompFrame frame = this.conn.createFrame("DISCONNECT").addHeader("receipt", uuid);
        ClientStompFrame result = this.conn.sendFrame(frame);
        if (result == null || !"RECEIPT".equals(result.getCommand()) || !uuid.equals(result.getHeader("receipt-id"))) {
            StompV11Test.fail((String)("Disconnect failed! " + result));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thr = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (latch.getCount() != 0L) {
                    try {
                        StompTestBase.send(StompV11Test.this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ClosedChannelException e) {
                        latch.countDown();
                        return;
                    }
                    catch (IOException e) {
                        latch.countDown();
                        return;
                    }
                    finally {
                        StompV11Test.this.conn.destroy();
                    }
                }
            }
        };
        thr.start();
        latch.await(10L, TimeUnit.SECONDS);
        long count = latch.getCount();
        if (count != 0L) {
            latch.countDown();
        }
        thr.join();
        StompV11Test.assertTrue((String)"Server failed to disconnect.", (count == 0L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testDurableSubscriber() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client", this.getName());
        StompV11Test.subscribe(this.conn, "sub1", "client", this.getName(), false);
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("ERROR"));
        this.conn.disconnect();
    }

    @Test
    public void testDurableSubscriberWithReconnection() throws Exception {
        this.conn.connect(this.defUser, this.defPass, CLIENT_ID);
        StompV11Test.subscribeTopic(this.conn, "sub1", "auto", this.getName());
        String uuid = UUID.randomUUID().toString();
        ClientStompFrame frame = this.conn.createFrame("DISCONNECT").addHeader("receipt", uuid);
        ClientStompFrame result = this.conn.sendFrame(frame);
        if (result == null || !"RECEIPT".equals(result.getCommand()) || !uuid.equals(result.getHeader("receipt-id"))) {
            StompV11Test.fail((String)("Disconnect failed! " + result));
        }
        this.sendJmsMessage(this.getName(), (Destination)this.topic);
        this.conn.destroy();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        this.conn.connect(this.defUser, this.defPass, CLIENT_ID);
        StompV11Test.subscribeTopic(this.conn, "sub1", "auto", this.getName());
        frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertNotNull((Object)frame.getHeader("destination"));
        Assert.assertEquals((Object)this.getName(), (Object)frame.getBody());
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
    }

    @Test
    public void testDurableUnSubscribe() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)("myclientid." + this.getName()));
        this.conn.connect(this.defUser, this.defPass, CLIENT_ID);
        StompV11Test.subscribeTopic(this.conn, null, "auto", this.getName());
        Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
        this.conn.disconnect();
        this.conn.destroy();
        Queue queue = this.server.locateQueue(queueName);
        Assert.assertNotNull((Object)queue);
        Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount(), (long)10000L, (long)10L);
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        this.conn.connect(this.defUser, this.defPass, CLIENT_ID);
        StompV11Test.unsubscribe(this.conn, this.getName(), null, false, true);
        Wait.assertTrue(() -> this.server.locateQueue(queueName) == null);
        this.conn.disconnect();
    }

    @Test
    public void testJMSXGroupIdCanBeSet() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("JMSXGroupID", "TEST").setBody("Hello World");
        this.conn.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((Object)"TEST", (Object)message.getStringProperty("JMSXGroupID"));
    }

    @Test
    public void testMessagesAreInOrder() throws Exception {
        int i;
        int ctr = 10;
        String[] data = new String[ctr];
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        for (int i2 = 0; i2 < ctr; ++i2) {
            data[i2] = this.getName() + i2;
            this.sendJmsMessage(data[i2]);
        }
        ClientStompFrame frame = null;
        for (i = 0; i < ctr; ++i) {
            frame = this.conn.receiveFrame();
            Assert.assertTrue((String)"Message not in order", (boolean)frame.getBody().equals(data[i]));
        }
        for (i = 0; i < ctr; ++i) {
            data[i] = this.getName() + ":second:" + i;
            this.sendJmsMessage(data[i]);
        }
        for (i = 0; i < ctr; ++i) {
            frame = this.conn.receiveFrame();
            Assert.assertTrue((String)"Message not in order", (boolean)frame.getBody().equals(data[i]));
        }
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeWithAutoAckAndSelector() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto", null, "foo = 'zzz'");
        this.sendJmsMessage("Ignored message", "foo", "1234");
        this.sendJmsMessage("Real message", "foo", "zzz");
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((String)("Should have received the real message but got: " + frame), (boolean)frame.getBody().equals("Real message"));
        this.conn.disconnect();
    }

    @Test
    public void testRedeliveryWithClientAck() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "subscriptionId", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        StompV11Test.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((boolean)message.getJMSRedelivered());
    }

    @Test
    public void testSendManyMessages() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        int count = 1000;
        final CountDownLatch latch = new CountDownLatch(count);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message arg0) {
                latch.countDown();
            }
        });
        for (int i = 1; i <= count; ++i) {
            StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World");
        }
        StompV11Test.assertTrue((boolean)latch.await(60L, TimeUnit.SECONDS));
        this.conn.disconnect();
    }

    @Test
    public void testSendMessage() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World");
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((String)"getJMSPriority", (long)4L, (long)message.getJMSPriority());
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        Assert.assertTrue((Math.abs(tnow - tmsg) < 1000L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testSendMessageWithContentLength() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        byte[] data = new byte[]{1, 0, 0, 4};
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).setBody(new String(data, StandardCharsets.UTF_8)).addHeader("content-length", String.valueOf(data.length));
        this.conn.sendFrame(frame);
        BytesMessage message = (BytesMessage)consumer.receive(10000L);
        Assert.assertNotNull((Object)message);
        StompV11Test.assertEquals((long)data.length, (long)message.getBodyLength());
        StompV11Test.assertEquals((long)data[0], (long)message.readByte());
        StompV11Test.assertEquals((long)data[1], (long)message.readByte());
        StompV11Test.assertEquals((long)data[2], (long)message.readByte());
        StompV11Test.assertEquals((long)data[3], (long)message.readByte());
    }

    @Test
    public void testSendMessageWithCustomHeadersAndSelector() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue, "foo = 'abc'");
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("foo", "abc").addHeader("bar", "123").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).setBody("Hello World");
        this.conn.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((String)"foo", (Object)"abc", (Object)message.getStringProperty("foo"));
        Assert.assertEquals((String)"bar", (Object)"123", (Object)message.getStringProperty("bar"));
    }

    @Test
    public void testSendMessageWithLeadingNewLine() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Thread.sleep(1000L);
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).setBody("Hello World");
        this.conn.sendWickedFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        Assert.assertTrue((Math.abs(tnow - tmsg) < 1000L ? (byte)1 : 0) != 0);
        StompV11Test.assertNull((Object)consumer.receive(100L));
        this.conn.disconnect();
    }

    @Test
    public void testSendMessageWithReceipt() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World", true);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        Assert.assertTrue((Math.abs(tnow - tmsg) < 1000L ? (byte)1 : 0) != 0);
        this.conn.disconnect();
    }

    @Test
    public void testSendMessageWithStandardHeaders() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("correlation-id", "c123").addHeader("persistent", "true").addHeader("priority", "3").addHeader("type", "t345").addHeader("JMSXGroupID", "abc").addHeader("foo", "abc").addHeader("bar", "123").setBody("Hello World");
        frame = this.conn.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((String)"JMSCorrelationID", (Object)"c123", (Object)message.getJMSCorrelationID());
        Assert.assertEquals((String)"getJMSType", (Object)"t345", (Object)message.getJMSType());
        Assert.assertEquals((String)"getJMSPriority", (long)3L, (long)message.getJMSPriority());
        Assert.assertEquals((long)2L, (long)message.getJMSDeliveryMode());
        Assert.assertEquals((String)"foo", (Object)"abc", (Object)message.getStringProperty("foo"));
        Assert.assertEquals((String)"bar", (Object)"123", (Object)message.getStringProperty("bar"));
        Assert.assertEquals((String)"JMSXGroupID", (Object)"abc", (Object)message.getStringProperty("JMSXGroupID"));
        this.conn.disconnect();
    }

    @Test
    public void testSendMessageWithLongHeaders() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 2048; ++i) {
            buffer.append("a");
        }
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("correlation-id", "c123").addHeader("persistent", "true").addHeader("priority", "3").addHeader("type", "t345").addHeader("JMSXGroupID", "abc").addHeader("foo", "abc").addHeader("longHeader", buffer.toString()).setBody("Hello World");
        frame = this.conn.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((String)"JMSCorrelationID", (Object)"c123", (Object)message.getJMSCorrelationID());
        Assert.assertEquals((String)"getJMSType", (Object)"t345", (Object)message.getJMSType());
        Assert.assertEquals((String)"getJMSPriority", (long)3L, (long)message.getJMSPriority());
        Assert.assertEquals((long)2L, (long)message.getJMSDeliveryMode());
        Assert.assertEquals((String)"foo", (Object)"abc", (Object)message.getStringProperty("foo"));
        Assert.assertEquals((String)"longHeader", (long)2048L, (long)message.getStringProperty("longHeader").length());
        Assert.assertEquals((String)"JMSXGroupID", (Object)"abc", (Object)message.getStringProperty("JMSXGroupID"));
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeToTopic() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribeTopic(this.conn, "sub1", null, null, true);
        this.sendJmsMessage(this.getName(), (Destination)this.topic);
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertTrue((boolean)frame.getHeader("destination").equals(StompV11Test.getTopicPrefix() + StompV11Test.getTopicName()));
        Assert.assertTrue((boolean)frame.getBody().equals(this.getName()));
        StompV11Test.unsubscribe(this.conn, "sub1", true);
        this.sendJmsMessage(this.getName(), (Destination)this.topic);
        frame = this.conn.receiveFrame(100L);
        StompV11Test.assertNull((Object)frame);
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeToTopicWithNoLocal() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribeTopic(this.conn, "sub1", null, null, true, true);
        StompV11Test.send(this.conn, StompV11Test.getTopicPrefix() + StompV11Test.getTopicName(), null, "Hello World");
        ClientStompFrame frame = this.conn.receiveFrame(100L);
        StompV11Test.assertNull((Object)frame);
        this.sendJmsMessage(this.getName(), (Destination)this.topic);
        frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertTrue((boolean)frame.getHeader("destination").equals(StompV11Test.getTopicPrefix() + StompV11Test.getTopicName()));
        Assert.assertTrue((boolean)frame.getBody().equals(this.getName()));
        StompV11Test.unsubscribe(this.conn, "sub1");
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeWithAutoAck() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        Assert.assertNotNull((Object)frame.getHeader("destination"));
        Assert.assertEquals((Object)this.getName(), (Object)frame.getBody());
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testSubscribeWithAutoAckAndBytesMessage() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        byte[] payload = new byte[]{1, 2, 3, 4, 5};
        this.sendJmsMessage(payload, (Destination)this.queue);
        ClientStompFrame frame = this.conn.receiveFrame();
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        this.instanceLog.debug((Object)("Message: " + frame));
        StompV11Test.assertEquals((Object)"5", (Object)frame.getHeader("content-length"));
        StompV11Test.assertEquals(null, (Object)frame.getHeader("type"));
        StompV11Test.assertEquals((Object)frame.getBody(), (Object)new String(payload, StandardCharsets.UTF_8));
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeWithClientAck() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        StompV11Test.assertEquals((long)this.getName().length(), (long)Integer.parseInt(frame.getHeader("content-length")));
        StompV11Test.ack(this.conn, "sub1", frame);
        this.conn.disconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        Message message = consumer.receive(100L);
        Assert.assertNull((Object)message);
    }

    @Test
    public void testSubscribeWithClientAckThenConsumingAgainWithAutoAckWithExplicitDisconnect() throws Exception {
        this.assertSubscribeWithClientAckThenConsumeWithAutoAck(true);
    }

    @Test
    public void testSubscribeWithClientAckThenConsumingAgainWithAutoAckWithNoDisconnectFrame() throws Exception {
        this.assertSubscribeWithClientAckThenConsumeWithAutoAck(false);
    }

    @Test
    public void testSubscribeWithID() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "mysubid", "auto");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((frame.getHeader("subscription") != null ? (byte)1 : 0) != 0);
        this.conn.disconnect();
    }

    @Test
    public void testSubscribeWithMessageSentWithProperties() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        BytesMessage message = this.session.createBytesMessage();
        message.setStringProperty("S", "value");
        message.setBooleanProperty("n", false);
        message.setByteProperty("byte", (byte)9);
        message.setDoubleProperty("d", 2.0);
        message.setFloatProperty("f", 6.0f);
        message.setIntProperty("i", 10);
        message.setLongProperty("l", 121L);
        message.setShortProperty("s", (short)12);
        message.writeBytes("Hello World".getBytes(StandardCharsets.UTF_8));
        producer.send((Message)message);
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertNotNull((Object)frame);
        Assert.assertTrue((frame.getHeader("S") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("n") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("byte") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("d") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("f") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("i") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("l") != null ? (byte)1 : 0) != 0);
        Assert.assertTrue((frame.getHeader("s") != null ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"Hello World", (Object)frame.getBody());
        this.conn.disconnect();
    }

    @Test
    public void testSuccessiveTransactionsWithSameID() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.beginTransaction(this.conn, "tx1");
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("transaction", "tx1").setBody("Hello World");
        this.conn.sendFrame(frame);
        StompV11Test.commitTransaction(this.conn, "tx1");
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((String)"Should have received a message", (Object)message);
        StompV11Test.beginTransaction(this.conn, "tx1");
        frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("transaction", "tx1").setBody("Hello World");
        this.conn.sendFrame(frame);
        StompV11Test.commitTransaction(this.conn, "tx1");
        message = consumer.receive(1000L);
        Assert.assertNotNull((String)"Should have received a message", (Object)message);
        this.conn.disconnect();
    }

    @Test
    public void testTransactionCommit() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.beginTransaction(this.conn, "tx1");
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("transaction", "tx1").addHeader("receipt", "123").setBody("Hello World");
        frame = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"123", (Object)frame.getHeader("receipt-id"));
        StompV11Test.assertNull((Object)consumer.receive(100L));
        StompV11Test.commitTransaction(this.conn, "tx1", true);
        Message message = consumer.receive(1000L);
        Assert.assertNotNull((String)"Should have received a message", (Object)message);
        this.conn.disconnect();
    }

    @Test
    public void testTransactionRollback() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.beginTransaction(this.conn, "tx1");
        ClientStompFrame frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("transaction", "tx1").setBody("first message");
        this.conn.sendFrame(frame);
        StompV11Test.abortTransaction(this.conn, "tx1");
        StompV11Test.beginTransaction(this.conn, "tx1");
        frame = this.conn.createFrame("SEND").addHeader("destination", StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()).addHeader("transaction", "tx1").setBody("second message");
        this.conn.sendFrame(frame);
        StompV11Test.commitTransaction(this.conn, "tx1", true);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"second message", (Object)message.getText());
        this.conn.disconnect();
    }

    @Test
    public void testUnsubscribe() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        this.sendJmsMessage("first message");
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        StompV11Test.unsubscribe(this.conn, "sub1", true);
        this.sendJmsMessage("second message");
        frame = this.conn.receiveFrame(100L);
        StompV11Test.assertNull((Object)frame);
        this.conn.disconnect();
    }

    @Test
    public void testHeartBeat3() throws Exception {
        this.connection.close();
        ClientStompFrame frame = this.conn.createFrame("CONNECT");
        frame.addHeader("host", "127.0.0.1");
        frame.addHeader("login", this.defUser);
        frame.addHeader("passcode", this.defPass);
        frame.addHeader("heart-beat", "500,500");
        frame.addHeader("accept-version", "1.0,1.1");
        ClientStompFrame reply = this.conn.sendFrame(frame);
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        StompV11Test.assertEquals((Object)"500,500", (Object)reply.getHeader("heart-beat"));
        this.instanceLog.debug((Object)"========== start pinger!");
        this.conn.startPinger(100L);
        Assert.assertEquals((long)1L, (long)this.server.getRemotingService().getConnections().size());
        StompConnection stompConnection = (StompConnection)this.server.getRemotingService().getConnections().iterator().next();
        StompFrameHandlerV11 stompFrameHandler = (StompFrameHandlerV11)stompConnection.getStompVersionHandler();
        Thread.sleep(1000L);
        int size = this.conn.getServerPingNumber();
        this.conn.stopPinger();
        Wait.waitFor(() -> this.server.getRemotingService().getConnections().size() == 0);
        Assert.assertFalse((boolean)stompFrameHandler.getHeartBeater().isStarted());
    }

    @Test
    public void testHeartBeat4() throws Exception {
        this.connection.close();
        ClientStompFrame frame = this.conn.createFrame("CONNECT");
        frame.addHeader("host", "127.0.0.1");
        frame.addHeader("login", this.defUser);
        frame.addHeader("passcode", this.defPass);
        frame.addHeader("heart-beat", "500,500");
        frame.addHeader("accept-version", "1.1,1.2");
        ClientStompFrame reply = this.conn.sendFrame(frame);
        this.instanceLog.debug((Object)("Reply: " + reply.toString()));
        StompV11Test.assertEquals((Object)"CONNECTED", (Object)reply.getCommand());
        RemotingConnection remotingConnection2 = null;
        StompConnection stompConnection = null;
        for (RemotingConnection remotingConnection2 : this.server.getRemotingService().getConnections()) {
            if (!(remotingConnection2 instanceof StompConnection)) continue;
            stompConnection = (StompConnection)remotingConnection2;
        }
        StompFrameHandlerV11 stompFrameHandler = (StompFrameHandlerV11)stompConnection.getStompVersionHandler();
        this.instanceLog.debug((Object)"========== start pinger!");
        this.conn.startPinger(100L);
        ClientStompFrame subFrame = this.conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("destination", StompV11Test.getTopicPrefix() + StompV11Test.getTopicName());
        subFrame.addHeader("id", "0");
        ClientStompFrame f = this.conn.sendFrame(subFrame);
        f = this.conn.sendFrame(subFrame);
        f = this.conn.sendFrame(subFrame);
        f = this.conn.receiveFrame(1000L);
        this.instanceLog.debug((Object)("Received " + f.toString()));
        Assert.assertTrue((boolean)f.getCommand().equals("ERROR"));
        this.conn.stopPinger();
        Thread.sleep(2000L);
        Wait.waitFor(() -> this.server.getRemotingService().getConnections().size() == 0);
        Assert.assertFalse((String)"HeartBeater is still running!!", (boolean)stompFrameHandler.getHeartBeater().isStarted());
    }

    protected void assertSubscribeWithClientAckThenConsumeWithAutoAck(boolean sendDisconnect) throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "client");
        this.sendJmsMessage(this.getName());
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        this.instanceLog.info((Object)"Reconnecting!");
        if (sendDisconnect) {
            this.conn.disconnect();
            this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        } else {
            this.conn.destroy();
            this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        }
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", null);
        frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        this.conn.disconnect();
        this.conn.destroy();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", null, null, true);
        this.sendJmsMessage("shouldBeNextMessage");
        frame = this.conn.receiveFrame();
        Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        Assert.assertEquals((Object)"shouldBeNextMessage", (Object)frame.getBody());
    }

    @Test
    public void testSendMessageToNonExistentQueueWithAutoCreation() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, "NonExistentQueue" + UUID.randomUUID().toString(), null, "Hello World", true, RoutingType.ANYCAST);
        this.conn.disconnect();
    }

    @Test
    public void testSendAndReceiveWithEscapedCharactersInSenderId() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), null, "Hello World 1!");
        StompV11Test.subscribe(this.conn, "ID\\cMYMACHINE-50616-635482262727823605-1\\c1\\c1\\c1");
        ClientStompFrame frame = this.conn.receiveFrame();
        StompV11Test.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        StompV11Test.assertEquals((Object)"ID:MYMACHINE-50616-635482262727823605-1:1:1:1", (Object)frame.getHeader("subscription"));
        StompV11Test.assertNotNull((Object)frame.getHeader("message-id"));
        StompV11Test.assertEquals((Object)(StompV11Test.getQueuePrefix() + StompV11Test.getQueueName()), (Object)frame.getHeader("destination"));
        StompV11Test.assertEquals((Object)"Hello World 1!", (Object)frame.getBody());
        StompV11Test.unsubscribe(this.conn, "ID\\cMYMACHINE-50616-635482262727823605-1\\c1\\c1\\c1");
        this.conn.disconnect();
    }

    @Test
    public void testReceiveContentType() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.conn.connect(this.defUser, this.defPass);
        ClientStompFrame response = StompV11Test.send(this.conn, StompV11Test.getQueuePrefix() + StompV11Test.getQueueName(), "text/plain", "Hello World");
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"text/plain", (Object)message.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_CONTENT_TYPE.toString()));
    }

    @Test
    public void testSendContentType() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompV11Test.subscribe(this.conn, "sub1", "auto");
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        BytesMessage message = this.session.createBytesMessage();
        message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_CONTENT_TYPE.toString(), "text/plain");
        message.writeBytes("Hello World".getBytes(StandardCharsets.UTF_8));
        producer.send((Message)message);
        ClientStompFrame frame = this.conn.receiveFrame();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)"text/plain", (Object)frame.getHeader("content-type"));
        this.conn.disconnect();
    }
}

