/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ActiveMQBufferTestBase
extends ActiveMQTestBase {
    private ActiveMQBuffer wrapper;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.wrapper = this.createBuffer();
    }

    @After
    public void tearDown() throws Exception {
        this.wrapper = null;
        super.tearDown();
    }

    protected abstract ActiveMQBuffer createBuffer();

    @Test
    public void testNullString() throws Exception {
        Assert.assertNull((Object)this.putAndGetNullableString(null));
    }

    @Test
    public void testEmptyString() throws Exception {
        String result = this.putAndGetNullableString("");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testNonEmptyString() throws Exception {
        String junk = RandomUtil.randomString();
        String result = this.putAndGetNullableString(junk);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)junk, (Object)result);
    }

    @Test
    public void testNullSimpleString() throws Exception {
        Assert.assertNull((Object)this.putAndGetNullableSimpleString(null));
    }

    @Test
    public void testEmptySimpleString() throws Exception {
        SimpleString emptySimpleString = new SimpleString("");
        SimpleString result = this.putAndGetNullableSimpleString(emptySimpleString);
        Assert.assertNotNull((Object)result);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])emptySimpleString.getData(), (byte[])result.getData());
    }

    @Test
    public void testNonEmptySimpleString() throws Exception {
        SimpleString junk = RandomUtil.randomSimpleString();
        SimpleString result = this.putAndGetNullableSimpleString(junk);
        Assert.assertNotNull((Object)result);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])junk.getData(), (byte[])result.getData());
    }

    @Test
    public void testByte() throws Exception {
        byte b = RandomUtil.randomByte();
        this.wrapper.writeByte(b);
        Assert.assertEquals((long)b, (long)this.wrapper.readByte());
    }

    @Test
    public void testUnsignedByte() throws Exception {
        byte b = -1;
        this.wrapper.writeByte(b);
        Assert.assertEquals((long)255L, (long)this.wrapper.readUnsignedByte());
        b = 15;
        this.wrapper.writeByte(b);
        Assert.assertEquals((long)b, (long)this.wrapper.readUnsignedByte());
    }

    @Test
    public void testBytes() throws Exception {
        byte[] bytes = RandomUtil.randomBytes();
        this.wrapper.writeBytes(bytes);
        byte[] b = new byte[bytes.length];
        this.wrapper.readBytes(b);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])bytes, (byte[])b);
    }

    @Test
    public void testBytesWithLength() throws Exception {
        byte[] bytes = RandomUtil.randomBytes();
        this.wrapper.writeBytes(bytes, 0, bytes.length / 2);
        byte[] b = new byte[bytes.length / 2];
        this.wrapper.readBytes(b, 0, b.length);
        ActiveMQTestBase.assertEqualsByteArrays((int)b.length, (byte[])bytes, (byte[])b);
    }

    @Test
    public void testPutTrueBoolean() throws Exception {
        this.wrapper.writeBoolean(true);
        Assert.assertTrue((boolean)this.wrapper.readBoolean());
    }

    @Test
    public void testPutFalseBoolean() throws Exception {
        this.wrapper.writeBoolean(false);
        Assert.assertFalse((boolean)this.wrapper.readBoolean());
    }

    @Test
    public void testPutNullableTrueBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testPutNullableFalseBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testNullBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(null);
        Assert.assertNull((Object)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testChar() throws Exception {
        this.wrapper.writeChar('a');
        Assert.assertEquals((long)97L, (long)this.wrapper.readChar());
    }

    @Test
    public void testInt() throws Exception {
        int i = RandomUtil.randomInt();
        this.wrapper.writeInt(i);
        Assert.assertEquals((long)i, (long)this.wrapper.readInt());
    }

    @Test
    public void testIntAtPosition() throws Exception {
        int firstInt = RandomUtil.randomInt();
        int secondInt = RandomUtil.randomInt();
        this.wrapper.writeInt(secondInt);
        this.wrapper.writeInt(secondInt);
        this.wrapper.setInt(0, firstInt);
        Assert.assertEquals((long)firstInt, (long)this.wrapper.readInt());
        Assert.assertEquals((long)secondInt, (long)this.wrapper.readInt());
    }

    @Test
    public void testLong() throws Exception {
        long l = RandomUtil.randomLong();
        this.wrapper.writeLong(l);
        Assert.assertEquals((long)l, (long)this.wrapper.readLong());
    }

    @Test
    public void testNullableLong() throws Exception {
        Long l = RandomUtil.randomLong();
        this.wrapper.writeNullableLong(l);
        Assert.assertEquals((Object)l, (Object)this.wrapper.readNullableLong());
    }

    @Test
    public void testNullLong() throws Exception {
        this.wrapper.writeNullableLong(null);
        Assert.assertNull((Object)this.wrapper.readNullableLong());
    }

    @Test
    public void testUnsignedShort() throws Exception {
        short s1 = Short.MAX_VALUE;
        this.wrapper.writeShort(s1);
        int s2 = this.wrapper.readUnsignedShort();
        Assert.assertEquals((long)s1, (long)s2);
        s1 = Short.MIN_VALUE;
        this.wrapper.writeShort(s1);
        s2 = this.wrapper.readUnsignedShort();
        Assert.assertEquals((long)(s1 * -1), (long)s2);
        s1 = -1;
        this.wrapper.writeShort(s1);
        s2 = this.wrapper.readUnsignedShort();
        Assert.assertEquals((long)s2, (long)65535L);
    }

    @Test
    public void testShort() throws Exception {
        this.wrapper.writeShort((short)1);
        Assert.assertEquals((long)1L, (long)this.wrapper.readShort());
    }

    @Test
    public void testDouble() throws Exception {
        double d = RandomUtil.randomDouble();
        this.wrapper.writeDouble(d);
        Assert.assertEquals((double)d, (double)this.wrapper.readDouble(), (double)1.0E-6);
    }

    @Test
    public void testFloat() throws Exception {
        float f = RandomUtil.randomFloat();
        this.wrapper.writeFloat(f);
        Assert.assertEquals((double)f, (double)this.wrapper.readFloat(), (double)1.0E-6);
    }

    @Test
    public void testUTF() throws Exception {
        String str = RandomUtil.randomString();
        this.wrapper.writeUTF(str);
        Assert.assertEquals((Object)str, (Object)this.wrapper.readUTF());
    }

    @Test
    public void testArray() throws Exception {
        byte[] bytes = RandomUtil.randomBytes((int)128);
        this.wrapper.writeBytes(bytes);
        byte[] array = this.wrapper.toByteBuffer().array();
        Assert.assertEquals((long)this.wrapper.capacity(), (long)array.length);
        ActiveMQTestBase.assertEqualsByteArrays((int)128, (byte[])bytes, (byte[])this.wrapper.toByteBuffer().array());
    }

    @Test
    public void testRewind() throws Exception {
        int i = RandomUtil.randomInt();
        this.wrapper.writeInt(i);
        Assert.assertEquals((long)i, (long)this.wrapper.readInt());
        this.wrapper.resetReaderIndex();
        Assert.assertEquals((long)i, (long)this.wrapper.readInt());
    }

    @Test
    public void testRemaining() throws Exception {
        int capacity = this.wrapper.capacity();
        int fill = capacity / 3;
        byte[] bytes = RandomUtil.randomBytes((int)fill);
        this.wrapper.writeBytes(bytes);
        Assert.assertEquals((long)(capacity - fill), (long)this.wrapper.writableBytes());
    }

    @Test
    public void testPosition() throws Exception {
        Assert.assertEquals((long)0L, (long)this.wrapper.writerIndex());
        byte[] bytes = RandomUtil.randomBytes((int)128);
        this.wrapper.writeBytes(bytes);
        Assert.assertEquals((long)bytes.length, (long)this.wrapper.writerIndex());
        this.wrapper.writerIndex(0);
        Assert.assertEquals((long)0L, (long)this.wrapper.writerIndex());
    }

    private String putAndGetNullableString(String nullableString) throws Exception {
        this.wrapper.writeNullableString(nullableString);
        return this.wrapper.readNullableString();
    }

    private SimpleString putAndGetNullableSimpleString(SimpleString nullableSimpleString) throws Exception {
        this.wrapper.writeNullableSimpleString(nullableSimpleString);
        return this.wrapper.readNullableSimpleString();
    }
}

