/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import io.netty.util.collection.LongObjectHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedListTest
extends ActiveMQTestBase {
    private LinkedListImpl<Integer> list;
    Comparator<Integer> integerComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1.intValue() == o2.intValue()) {
                return 0;
            }
            if (o2 > o1) {
                return 1;
            }
            return -1;
        }
    };

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.list = new LinkedListImpl(this.integerComparator);
    }

    @Test
    public void addSorted() {
        this.list.addSorted((Object)1);
        this.list.addSorted((Object)3);
        this.list.addSorted((Object)2);
        this.list.addSorted((Object)0);
        this.validateOrder(null);
        Assert.assertEquals((long)4L, (long)this.list.size());
    }

    @Test
    public void randomSorted() {
        HashSet<Integer> values = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            int value = RandomUtil.randomInt();
            if (values.contains(value)) continue;
            values.add(value);
            this.list.addSorted((Object)value);
        }
        Assert.assertEquals((long)values.size(), (long)this.list.size());
        this.validateOrder(values);
        Assert.assertEquals((long)0L, (long)values.size());
    }

    private void validateOrder(HashSet<Integer> values) {
        Integer previous = null;
        LinkedListIterator integerIterator = this.list.iterator();
        while (integerIterator.hasNext()) {
            Integer value = (Integer)integerIterator.next();
            if (previous != null) {
                Assert.assertTrue((String)(value + " should be > " + previous), (this.integerComparator.compare(previous, value) > 0 ? (byte)1 : 0) != 0);
                Assert.assertTrue((String)(value + " should be > " + previous), (value > previous ? (byte)1 : 0) != 0);
            }
            if (values != null) {
                values.remove(value);
            }
            previous = value;
        }
        integerIterator.close();
    }

    @Test
    public void testAddAndRemove() {
        LinkedListImpl objs = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode o = new ObservableNode(null, i);
            objs.addTail((Object)o);
        }
        try (LinkedListIterator iter = objs.iterator();){
            for (int i = 0; i < 500; ++i) {
                for (int add = 0; add < 1000; ++add) {
                    ObservableNode o = new ObservableNode(null, add);
                    objs.addTail((Object)o);
                    LinkedListTest.assertNotNull((String)"prev", o.publicPrev());
                    LinkedListTest.assertNull((String)"next", o.publicNext());
                }
                for (int remove = 0; remove < 1000; ++remove) {
                    ObservableNode next = (ObservableNode)((Object)iter.next());
                    LinkedListTest.assertNotNull((Object)((Object)next));
                    LinkedListTest.assertNotNull((String)"prev", next.publicPrev());
                    LinkedListTest.assertNotNull((String)"next", next.publicNext());
                    iter.remove();
                    LinkedListTest.assertNull((String)"prev", next.publicPrev());
                    LinkedListTest.assertNull((String)"next", next.publicNext());
                }
                LinkedListTest.assertEquals((long)100L, (long)objs.size());
            }
            while (iter.hasNext()) {
                ObservableNode next = (ObservableNode)((Object)iter.next());
                LinkedListTest.assertNotNull((Object)((Object)next));
                iter.remove();
                LinkedListTest.assertNull((String)"prev", next.publicPrev());
                LinkedListTest.assertNull((String)"next", next.publicNext());
            }
        }
        LinkedListTest.assertEquals((long)0L, (long)objs.size());
    }

    @Test
    public void testAddAndRemoveWithIDs() {
        this.internalAddWithID(true);
    }

    @Test
    public void testAddAndRemoveWithIDsDeferredSupplier() {
        this.internalAddWithID(false);
    }

    private void internalAddWithID(boolean deferSupplier) {
        for (int sid = 1; sid <= 2; ++sid) {
            int i;
            LinkedListImpl objs = new LinkedListImpl();
            objs.clearID();
            String serverID = sid == 1 ? null : "" + sid;
            ListNodeStore nodeStore = new ListNodeStore();
            if (!deferSupplier) {
                objs.setNodeStore((NodeStore)nodeStore);
            }
            for (i = 1; i <= 1000; ++i) {
                ObservableNode o = new ObservableNode(serverID, i);
                objs.addTail((Object)o);
            }
            Assert.assertEquals((long)1000L, (long)objs.size());
            if (deferSupplier) {
                Assert.assertEquals((long)0L, (long)nodeStore.size());
                objs.setNodeStore((NodeStore)nodeStore);
            } else {
                objs.clearID();
                Assert.assertEquals((long)0L, (long)nodeStore.size());
                nodeStore = new ListNodeStore();
                objs.setNodeStore((NodeStore)nodeStore);
                Assert.assertEquals((long)1000L, (long)objs.size());
            }
            Assert.assertEquals((long)1000L, (long)nodeStore.size());
            for (i = 1; i <= 1000; i += 2) {
                objs.removeWithID(serverID, (long)i);
            }
            Assert.assertEquals((long)500L, (long)objs.size());
            Assert.assertEquals((long)500L, (long)nodeStore.size());
            LinkedListIterator iterator = objs.iterator();
            int i2 = 2;
            while (iterator.hasNext()) {
                ObservableNode value = (ObservableNode)((Object)iterator.next());
                Assert.assertEquals((long)i2, (long)value.id);
                i2 += 2;
            }
            for (i2 = 2; i2 <= 1000; i2 += 2) {
                Assert.assertNotNull((Object)objs.removeWithID(serverID, (long)i2));
            }
            Assert.assertEquals((long)0L, (long)nodeStore.size());
            Assert.assertEquals((long)0L, (long)objs.size());
        }
    }

    @Test
    public void testAddHeadAndRemove() {
        ObservableNode obj;
        LinkedListImpl objs = new LinkedListImpl();
        for (int i = 0; i < 1001; ++i) {
            ObservableNode o = new ObservableNode(null, i);
            objs.addHead((Object)o);
        }
        LinkedListTest.assertEquals((long)1001L, (long)objs.size());
        int countLoop = 0;
        try (LinkedListIterator iter = objs.iterator();){
            int removed = 0;
            for (countLoop = 0; countLoop <= 1000; ++countLoop) {
                obj = (ObservableNode)((Object)iter.next());
                Assert.assertNotNull((Object)((Object)obj));
                if (countLoop != 500 && countLoop != 1000) continue;
                LinkedListTest.assertNotNull((String)"prev", obj.publicPrev());
                iter.remove();
                LinkedListTest.assertNull((String)"prev", obj.publicPrev());
                LinkedListTest.assertNull((String)"next", obj.publicNext());
                ++removed;
            }
            LinkedListTest.assertEquals((long)(1001 - removed), (long)objs.size());
        }
        int expectedSize = objs.size();
        try (LinkedListIterator iter = objs.iterator();){
            countLoop = 0;
            while (iter.hasNext()) {
                obj = (ObservableNode)((Object)iter.next());
                LinkedListTest.assertNotNull((Object)((Object)obj));
                ++countLoop;
            }
            Assert.assertEquals((long)expectedSize, (long)countLoop);
        }
        objs.clear();
    }

    @Test
    public void testAddTail() {
        int i;
        int num = 10;
        LinkedListTest.assertEquals((long)0L, (long)this.list.size());
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
            LinkedListTest.assertEquals((long)(i + 1), (long)this.list.size());
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
            LinkedListTest.assertEquals((long)(num - i - 1), (long)this.list.size());
        }
    }

    @Test
    public void testAddHead() {
        int i;
        int num = 10;
        LinkedListTest.assertEquals((long)0L, (long)this.list.size());
        for (i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
            LinkedListTest.assertEquals((long)(i + 1), (long)this.list.size());
        }
        for (i = num - 1; i >= 0; --i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
            LinkedListTest.assertEquals((long)i, (long)this.list.size());
        }
    }

    @Test
    public void testAddHeadAndTail() {
        int i;
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num * 2; i < num * 3; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num * 3; i < num * 4; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num * 3 - 1; i >= num * 2; --i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        for (i = num - 1; i >= 0; --i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        for (i = num; i < num * 2; ++i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        for (i = num * 3; i < num * 4; ++i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
    }

    @Test
    public void testPoll() {
        int i;
        int num = 10;
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
        for (i = num; i < num * 2; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num * 2 - 1; i >= num; --i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertNull((Object)this.list.poll());
    }

    @Test
    public void testIterateNoElements() {
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertNotNull((Object)iter);
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateIteratorBeforeAddElements() {
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertNotNull((Object)iter);
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        this.testIterate1(num, (LinkedListIterator<Integer>)iter);
    }

    @Test
    public void testCreateIteratorAfterAddElements() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertNotNull((Object)iter);
        this.testIterate1(num, (LinkedListIterator<Integer>)iter);
    }

    @Test
    public void testIterateThenAddMoreAndIterateAgain() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertNotNull((Object)iter);
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        for (i = num * 2; i < num * 3; ++i) {
            this.list.addHead((Object)i);
        }
        iter = this.list.iterator();
        for (i = num * 3 - 1; i >= num * 2; --i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        for (i = 0; i < num * 2; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    private void testIterate1(int num, LinkedListIterator<Integer> iter) {
        for (int i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown(iter);
    }

    private void assertNoSuchElementIsThrown(LinkedListIterator<Integer> iter) {
        try {
            iter.next();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAll() {
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListTest.assertEquals((long)num, (long)this.list.size());
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        for (int i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
            LinkedListTest.assertEquals((long)(num - i - 1), (long)this.list.size());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveOdd() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException i2) {
            // empty catch block
        }
        int size = num;
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            if (i % 2 == 0) {
                iter.remove();
                --size;
            }
            LinkedListTest.assertEquals((long)this.list.size(), (long)size);
        }
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            if (i % 2 != 1) continue;
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead1() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        iter.next();
        iter.remove();
        for (i = 1; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        iter.next();
        iter.remove();
        iter = this.list.iterator();
        for (int i = 1; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead3() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
    }

    @Test
    public void testRemoveTail1() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        iter.remove();
        iter = this.list.iterator();
        for (i = 0; i < num - 1; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveMiddle() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num / 2; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        iter.remove();
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            if (i == num / 2 - 1) continue;
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveTail2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        for (int i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        iter.remove();
        try {
            iter.remove();
            LinkedListTest.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        iter = this.list.iterator();
        for (int i = 0; i < num - 1; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveTail3() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        iter.remove();
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)8L, (long)((Integer)iter.next()).intValue());
        for (i = num; i < num * 2; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
    }

    @Test
    public void testRemoveHeadAndTail1() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
    }

    @Test
    public void testRemoveHeadAndTail2() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
            LinkedListTest.assertEquals((long)1L, (long)this.list.size());
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
    }

    @Test
    public void testRemoveHeadAndTail3() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            if (i % 2 == 0) {
                this.list.addHead((Object)i);
            } else {
                this.list.addTail((Object)i);
            }
            LinkedListTest.assertEquals((long)1L, (long)this.list.size());
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
    }

    @Test
    public void testRemoveInTurn() {
        int i;
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
            iter.remove();
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testGCNepotismPoll() {
        ObservableNode node;
        int count = 100;
        LinkedListImpl list = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode node2 = new ObservableNode(null, i);
            LinkedListTest.assertNull(node2.publicPrev());
            LinkedListTest.assertNull(node2.publicNext());
            list.addTail((Object)node2);
            LinkedListTest.assertNotNull(node2.publicPrev());
        }
        int removed = 0;
        while ((node = (ObservableNode)((Object)list.poll())) != null) {
            LinkedListTest.assertNull(node.publicPrev());
            LinkedListTest.assertNull(node.publicNext());
            ++removed;
        }
        LinkedListTest.assertEquals((long)100L, (long)removed);
        LinkedListTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testGCNepotismClear() {
        int count = 100;
        ObservableNode[] nodes = new ObservableNode[100];
        LinkedListImpl list = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode node = new ObservableNode(null, i);
            LinkedListTest.assertNull(node.publicPrev());
            LinkedListTest.assertNull(node.publicNext());
            nodes[i] = node;
            list.addTail((Object)node);
            LinkedListTest.assertNotNull(node.publicPrev());
        }
        list.clear();
        for (ObservableNode node : nodes) {
            LinkedListTest.assertNull(node.publicPrev());
            LinkedListTest.assertNull(node.publicNext());
        }
        LinkedListTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testClear() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        LinkedListTest.assertEquals((long)num, (long)this.list.size());
        this.list.clear();
        LinkedListTest.assertEquals((long)0L, (long)this.list.size());
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListTest.assertEquals((long)num, (long)this.list.size());
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertTrue((boolean)iter.hasNext());
            LinkedListTest.assertEquals((long)i, (long)((Integer)iter.next()).intValue());
        }
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < num; ++i) {
            LinkedListTest.assertEquals((long)i, (long)((Integer)this.list.poll()).intValue());
        }
        LinkedListTest.assertNull((Object)this.list.poll());
        LinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testMultipleIterators1() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        LinkedListIterator iter3 = this.list.iterator();
        int i = 0;
        while (i < num) {
            LinkedListTest.assertTrue((boolean)iter1.hasNext());
            LinkedListTest.assertEquals((long)i++, (long)((Integer)iter1.next()).intValue());
            iter1.remove();
            if (i == 10) break;
            LinkedListTest.assertTrue((boolean)iter2.hasNext());
            LinkedListTest.assertEquals((long)i++, (long)((Integer)iter2.next()).intValue());
            iter2.remove();
            LinkedListTest.assertTrue((boolean)iter3.hasNext());
            LinkedListTest.assertEquals((long)i++, (long)((Integer)iter3.next()).intValue());
            iter3.remove();
        }
    }

    @Test
    public void testRepeat() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter.next()).intValue());
        iter.repeat();
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter.next()).intValue());
        iter.next();
        iter.next();
        iter.next();
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter.next()).intValue());
        iter.repeat();
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter.next()).intValue());
        iter.next();
        iter.next();
        iter.next();
        iter.next();
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter.next()).intValue());
        LinkedListTest.assertFalse((boolean)iter.hasNext());
        iter.repeat();
        LinkedListTest.assertTrue((boolean)iter.hasNext());
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter.next()).intValue());
        LinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRepeatAndRemove() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter2.next()).intValue());
        iter2.remove();
        iter1.repeat();
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter1.next()).intValue());
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter1.next()).intValue());
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter2.next()).intValue());
        iter1.remove();
        iter2.repeat();
        LinkedListTest.assertEquals((long)8L, (long)((Integer)iter2.next()).intValue());
    }

    @Test
    public void testMultipleIterators2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        LinkedListIterator iter3 = this.list.iterator();
        LinkedListIterator iter4 = this.list.iterator();
        LinkedListIterator iter5 = this.list.iterator();
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertTrue((boolean)iter3.hasNext());
        LinkedListTest.assertTrue((boolean)iter4.hasNext());
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertEquals((long)0L, (long)((Integer)iter1.next()).intValue());
        iter1.remove();
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)1L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter4.hasNext());
        LinkedListTest.assertEquals((long)2L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)3L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)5L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)6L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)8L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertFalse((boolean)iter4.hasNext());
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)2L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertEquals((long)3L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertEquals((long)5L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertEquals((long)6L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter3.hasNext());
        LinkedListTest.assertEquals((long)2L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertEquals((long)3L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)2L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertEquals((long)3L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)2L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertEquals((long)3L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertEquals((long)4L, (long)((Integer)iter1.next()).intValue());
        iter2.remove();
        LinkedListTest.assertEquals((long)5L, (long)((Integer)iter2.next()).intValue());
        iter2.remove();
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)6L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)6L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter3.hasNext());
        LinkedListTest.assertEquals((long)6L, (long)((Integer)iter3.next()).intValue());
        iter5.remove();
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter1.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter3.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)8L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)9L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertFalse((boolean)iter5.hasNext());
        iter5.remove();
        iter4.remove();
        this.list.addTail((Object)10);
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter5.hasNext());
        LinkedListTest.assertEquals((long)10L, (long)((Integer)iter5.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter4.hasNext());
        LinkedListTest.assertEquals((long)7L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter4.hasNext());
        LinkedListTest.assertEquals((long)10L, (long)((Integer)iter4.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter3.hasNext());
        LinkedListTest.assertEquals((long)10L, (long)((Integer)iter3.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter2.hasNext());
        LinkedListTest.assertEquals((long)10L, (long)((Integer)iter2.next()).intValue());
        LinkedListTest.assertTrue((boolean)iter1.hasNext());
        LinkedListTest.assertEquals((long)10L, (long)((Integer)iter1.next()).intValue());
    }

    @Test
    public void testResizing() {
        int i;
        int numIters = 1000;
        LinkedList<LinkedListIterator> iters = new LinkedList<LinkedListIterator>();
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < numIters; ++i) {
            LinkedListIterator iter = this.list.iterator();
            iters.add(iter);
            for (int j = 0; j < num / 2; ++j) {
                LinkedListTest.assertTrue((boolean)iter.hasNext());
                LinkedListTest.assertEquals((long)j, (long)((Integer)iter.next()).intValue());
            }
        }
        LinkedListTest.assertEquals((long)numIters, (long)this.list.numIters());
        boolean b = false;
        for (LinkedListIterator iter : iters) {
            if (b) {
                iter.close();
            }
            b = !b;
        }
        LinkedListTest.assertEquals((long)(numIters / 2), (long)this.list.numIters());
        b = true;
        for (LinkedListIterator iter : iters) {
            if (b) {
                iter.close();
            }
            b = !b;
        }
        LinkedListTest.assertEquals((long)0L, (long)this.list.numIters());
    }

    static class ListNodeStore
    implements NodeStore<ObservableNode> {
        LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> nodeLongObjectHashMap = new LongObjectHashMap();
        HashMap<Object, LongObjectHashMap<LinkedListImpl.Node<ObservableNode>>> mapList = new HashMap();

        ListNodeStore() {
        }

        public void storeNode(ObservableNode element, LinkedListImpl.Node<ObservableNode> node) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(element.serverID);
            map.put((long)element.id, node);
        }

        public LinkedListImpl.Node<ObservableNode> getNode(String listID, long id) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(listID);
            if (map == null) {
                return null;
            }
            return (LinkedListImpl.Node)map.get(id);
        }

        public void removeNode(ObservableNode element, LinkedListImpl.Node<ObservableNode> node) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(element.serverID);
            if (map != null) {
                map.remove((long)element.id);
            }
        }

        private LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> getNodesMap(String listID) {
            if (listID == null) {
                return this.nodeLongObjectHashMap;
            }
            LongObjectHashMap theMap = this.mapList.get(listID);
            if (theMap == null) {
                theMap = new LongObjectHashMap();
                this.mapList.put(listID, (LongObjectHashMap<LinkedListImpl.Node<ObservableNode>>)theMap);
            }
            return theMap;
        }

        public void clear() {
            this.nodeLongObjectHashMap.clear();
            this.mapList.clear();
        }

        public int size() {
            int size = 0;
            for (LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> list : this.mapList.values()) {
                size = list.size();
            }
            return this.nodeLongObjectHashMap.size() + size;
        }
    }

    private static final class ObservableNode
    extends LinkedListImpl.Node<ObservableNode> {
        public String serverID;
        public int id;

        ObservableNode(String serverID, int id) {
            this.id = id;
            this.serverID = serverID;
        }

        public LinkedListImpl.Node<ObservableNode> publicNext() {
            return this.next();
        }

        public LinkedListImpl.Node<ObservableNode> publicPrev() {
            return this.prev();
        }
    }
}

