/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Filter;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class FilterHelper {
    private static final Pattern FILTER_PARAMETER_PATTERN = Pattern.compile(":(\\S+)(\\w+)");
    private final String[] filterNames;
    private final String[] filterConditions;
    private final boolean[] filterAutoAliasFlags;
    private final Map<String, String>[] filterAliasTableMaps;
    private final List<String>[] parameterNames;

    public FilterHelper(List<FilterConfiguration> filters, SessionFactoryImplementor factory) {
        int filterCount = filters.size();
        this.filterNames = new String[filterCount];
        this.filterConditions = new String[filterCount];
        this.filterAutoAliasFlags = new boolean[filterCount];
        this.filterAliasTableMaps = new Map[filterCount];
        this.parameterNames = new List[filterCount];
        filterCount = 0;
        for (FilterConfiguration filter : filters) {
            String filterName;
            this.filterNames[filterCount] = filterName = StringHelper.safeInterning(filter.getName());
            this.filterConditions[filterCount] = StringHelper.safeInterning(filter.getCondition());
            this.filterAliasTableMaps[filterCount] = filter.getAliasTableMap(factory);
            this.filterAutoAliasFlags[filterCount] = false;
            if ((this.filterAliasTableMaps[filterCount].isEmpty() || FilterHelper.isTableFromPersistentClass(this.filterAliasTableMaps[filterCount])) && filter.useAutoAliasInjection()) {
                String autoAliasedCondition = Template.renderWhereStringTemplate(filter.getCondition(), "$FILTER_PLACEHOLDER$", factory.getJdbcServices().getDialect(), factory.getTypeConfiguration(), factory.getQueryEngine().getSqmFunctionRegistry());
                this.filterConditions[filterCount] = StringHelper.safeInterning(autoAliasedCondition);
                this.filterAutoAliasFlags[filterCount] = true;
            }
            Matcher matcher = FILTER_PARAMETER_PATTERN.matcher(this.filterConditions[filterCount]);
            String copy = this.filterConditions[filterCount];
            ArrayList<String> filterParamNames = new ArrayList<String>();
            this.parameterNames[filterCount] = filterParamNames;
            boolean foundAny = false;
            while (matcher.find()) {
                String parameterLabel = this.filterConditions[filterCount].substring(matcher.start() + 1, matcher.end());
                filterParamNames.add(parameterLabel);
                copy = copy.replace(":" + parameterLabel, ":" + filterName + "." + parameterLabel);
                foundAny = true;
            }
            if (foundAny) {
                this.filterConditions[filterCount] = StringHelper.safeInterning(copy);
            }
            ++filterCount;
        }
    }

    private static boolean isTableFromPersistentClass(Map<String, String> aliasTableMap) {
        return aliasTableMap.size() == 1 && aliasTableMap.containsKey(null);
    }

    public boolean isAffectedBy(Map<String, Filter> enabledFilters) {
        for (String filterName : this.filterNames) {
            if (!enabledFilters.containsKey(filterName)) continue;
            return true;
        }
        return false;
    }

    public static void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, Restrictable restrictable, TableGroup rootTableGroup, boolean useIdentificationVariable, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationState astCreationState) {
        restrictable.applyBaseRestrictions(predicateConsumer, rootTableGroup, useIdentificationVariable, loadQueryInfluencers.getEnabledFilters(), null, astCreationState);
    }

    public void applyEnabledFilters(Consumer<Predicate> predicateConsumer, FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        FilterPredicate predicate = this.generateFilterPredicate(aliasGenerator, enabledFilters);
        if (predicate != null) {
            predicateConsumer.accept(predicate);
        }
    }

    private FilterPredicate generateFilterPredicate(FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        FilterPredicate filterPredicate = new FilterPredicate();
        int max = this.filterNames.length;
        for (int i = 0; i < max; ++i) {
            String filterName = this.filterNames[i];
            FilterImpl enabledFilter = (FilterImpl)enabledFilters.get(filterName);
            if (enabledFilter == null) continue;
            String condition = this.render(aliasGenerator, i);
            List<String> filterParameterNames = this.parameterNames[i];
            if (CollectionHelper.isNotEmpty(filterParameterNames)) {
                for (int paramPos = 0; paramPos < filterParameterNames.size(); ++paramPos) {
                    String parameterName = filterParameterNames.get(paramPos);
                    JdbcMapping jdbcMapping = enabledFilter.getFilterDefinition().getParameterJdbcMapping(parameterName);
                    Object parameterValue = enabledFilter.getParameter(parameterName);
                    if (parameterValue == null) {
                        throw new MappingException(String.format("unknown parameter [%s] for filter [%s]", parameterName, filterName));
                    }
                    StringBuilder paramMarkers = new StringBuilder("?");
                    if (parameterValue instanceof Iterable && !jdbcMapping.getJavaTypeDescriptor().isInstance(parameterValue)) {
                        Iterator iterator = ((Iterable)parameterValue).iterator();
                        if (iterator.hasNext()) {
                            Object value = iterator.next();
                            FilterJdbcParameter jdbcParameter = new FilterJdbcParameter(jdbcMapping, value);
                            filterPredicate.applyParameter(jdbcParameter);
                            while (iterator.hasNext()) {
                                paramMarkers.append(",?");
                                filterPredicate.applyParameter(new FilterJdbcParameter(jdbcMapping, iterator.next()));
                            }
                        } else {
                            filterPredicate.applyParameter(new FilterJdbcParameter(jdbcMapping, null));
                        }
                    } else {
                        filterPredicate.applyParameter(new FilterJdbcParameter(jdbcMapping, parameterValue));
                    }
                    String marker = ":" + this.filterNames[i] + "." + parameterName;
                    condition = condition.replaceAll(marker, paramMarkers.toString());
                }
            }
            filterPredicate.applyFragment(condition);
        }
        if (filterPredicate.isEmpty()) {
            return null;
        }
        return filterPredicate;
    }

    public String render(FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        StringBuilder buffer = new StringBuilder();
        this.render(buffer, aliasGenerator, enabledFilters);
        return buffer.toString();
    }

    public void render(StringBuilder buffer, FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        if (CollectionHelper.isEmpty(this.filterNames)) {
            return;
        }
        int max = this.filterNames.length;
        for (int i = 0; i < max; ++i) {
            String condition;
            if (!enabledFilters.containsKey(this.filterNames[i]) || !StringHelper.isNotEmpty(condition = this.filterConditions[i])) continue;
            if (buffer.length() > 0) {
                buffer.append(" and ");
            }
            buffer.append(this.render(aliasGenerator, i));
        }
    }

    private String render(FilterAliasGenerator aliasGenerator, int filterIndex) {
        Map<String, String> aliasTableMap = this.filterAliasTableMaps[filterIndex];
        String condition = this.filterConditions[filterIndex];
        if (aliasGenerator == null) {
            return StringHelper.replace(condition, "$FILTER_PLACEHOLDER$.", "");
        }
        if (this.filterAutoAliasFlags[filterIndex]) {
            return StringHelper.replace(condition, "$FILTER_PLACEHOLDER$", aliasGenerator.getAlias(aliasTableMap.get(null)));
        }
        if (FilterHelper.isTableFromPersistentClass(aliasTableMap)) {
            return StringHelper.replace(condition, "{alias}", aliasGenerator.getAlias(aliasTableMap.get(null)));
        }
        for (Map.Entry<String, String> entry : aliasTableMap.entrySet()) {
            condition = StringHelper.replace(condition, "{" + entry.getKey() + "}", aliasGenerator.getAlias(entry.getValue()));
        }
        return condition;
    }
}

