/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JaxbXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jaxb";
    public static final JaxbXmlFormatMapper INSTANCE = new JaxbXmlFormatMapper();

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                } else {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                MapWrapper mapWrapper = (MapWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                List<Object> elements = mapWrapper.elements;
                LinkedHashMap<Object, Object> map = CollectionHelper.linkedMapOfSize(elements.size() >> 1);
                for (int i = 0; i < elements.size(); i += 2) {
                    Object keyElement = unmarshaller.unmarshal((Node)elements.get(i), keyClass).getValue();
                    Object valueElement = unmarshaller.unmarshal((Node)elements.get(i + 1), valueClass).getValue();
                    Object key = keyElement instanceof Element ? ((Element)keyElement).getFirstChild().getTextContent() : keyElement;
                    Object value = valueElement instanceof Element ? ((Element)valueElement).getFirstChild().getTextContent() : valueElement;
                    map.put(key, value);
                }
                return (T)map;
            }
            if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else {
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                CollectionWrapper collectionWrapper = (CollectionWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                List<Object> elements = collectionWrapper.elements;
                ArrayList<Object> collection = new ArrayList<Object>(elements.size() >> 1);
                for (int i = 0; i < elements.size(); ++i) {
                    Object valueElement = unmarshaller.unmarshal((Node)elements.get(i), valueClass).getValue();
                    Object value = valueElement instanceof Element ? ((Element)valueElement).getFirstChild().getTextContent() : valueElement;
                    collection.add(value);
                }
                return (T)collection;
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
            return (T)context.createUnmarshaller().unmarshal((Reader)new StringReader(charSequence.toString()));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            StringWriter stringWriter = new StringWriter();
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                MapWrapper mapWrapper = new MapWrapper();
                Map map = (Map)value;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                } else if (map.isEmpty()) {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class});
                } else {
                    Map.Entry firstEntry = map.entrySet().iterator().next();
                    keyClass = firstEntry.getKey().getClass();
                    valueClass = firstEntry.getValue().getClass();
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                }
                for (Map.Entry entry : map.entrySet()) {
                    mapWrapper.elements.add(new JAXBElement(new QName("key"), keyClass, entry.getKey()));
                    mapWrapper.elements.add(new JAXBElement(new QName("value"), valueClass, entry.getValue()));
                }
                this.createMarshaller(context).marshal((Object)mapWrapper, (Writer)stringWriter);
            } else if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Collection collection = (Collection)value;
                CollectionWrapper collectionWrapper = new CollectionWrapper(new ArrayList<Object>(collection));
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    Class valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else if (collection.isEmpty()) {
                    Class<Object> valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                } else {
                    Class<?> valueClass = collection.iterator().next().getClass();
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                }
                this.createMarshaller(context).marshal((Object)collectionWrapper, (Writer)stringWriter);
            } else {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
                this.createMarshaller(context).marshal(value, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }

    private Marshaller createMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        return marshaller;
    }

    @XmlRootElement(name="Collection")
    public static class CollectionWrapper {
        @XmlAnyElement
        List<Object> elements = new ArrayList<Object>();

        public CollectionWrapper() {
        }

        public CollectionWrapper(List<Object> elements) {
            this.elements = elements;
        }
    }

    @XmlRootElement(name="Map")
    public static class MapWrapper {
        @XmlAnyElement
        List<Object> elements = new ArrayList<Object>();
    }
}

