/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;

public class LabelRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTLABEL);
    private static final String RENDER_END_ELEMENT = "com.sun.faces.RENDER_END_ELEMENT";
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.RESOLVE_SINGLE_COMPONENT, SearchExpressionHint.IGNORE_NO_RESULT);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String forClientId = null;
        String forValue = (String)component.getAttributes().get("for");
        if (forValue != null) {
            SearchExpressionContext searchExpressionContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, EXPRESSION_HINTS, null);
            forClientId = context.getApplication().getSearchExpressionHandler().resolveClientId(searchExpressionContext, forValue);
            if (forClientId == null) {
                forClientId = this.getForComponentClientId(component, context, forValue);
            }
        }
        component.getAttributes().put(RENDER_END_ELEMENT, "yes");
        writer.startElement("label", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (forClientId != null) {
            writer.writeAttribute("for", (Object)forClientId, "for");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        String value = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + value);
        }
        if (value != null && value.length() != 0) {
            boolean escape;
            Object val = component.getAttributes().get("escape");
            boolean bl = escape = val != null && Boolean.valueOf(val.toString()) != false;
            if (escape) {
                writer.writeText((Object)value, component, "value");
            } else {
                writer.write(value);
            }
        }
        writer.flush();
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        String render = (String)component.getAttributes().get(RENDER_END_ELEMENT);
        if ("yes".equals(render)) {
            component.getAttributes().remove(RENDER_END_ELEMENT);
            ResponseWriter writer = context.getResponseWriter();
            assert (writer != null);
            writer.endElement("label");
        }
    }

    protected String getForComponentClientId(UIComponent component, FacesContext context, String forValue) {
        UIComponent parent;
        String result = null;
        for (parent = component.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        if (parent == null) {
            return result;
        }
        String parentClientId = parent.getClientId(context);
        result = parentClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + forValue;
        return result;
    }
}

