/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.IdProjectionBuilder;

public class ElasticsearchIdProjection<I>
extends AbstractElasticsearchProjection<String, I> {
    private final ProjectionExtractionHelper<String> extractionHelper;
    private final ProjectionConverter<String, ? extends I> converter;

    private ElasticsearchIdProjection(ElasticsearchSearchIndexScope<?> scope, ProjectionExtractionHelper<String> extractionHelper, ProjectionConverter<String, ? extends I> converter) {
        super(scope);
        this.extractionHelper = extractionHelper;
        this.converter = converter;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        this.extractionHelper.request(requestBody, context);
    }

    @Override
    public String extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        return this.extractionHelper.extract(hit, context);
    }

    @Override
    public I transform(LoadingResult<?, ?> loadingResult, String extractedData, SearchProjectionTransformContext context) {
        return (I)this.converter.fromDocumentValue((Object)extractedData, context.fromDocumentValueConvertContext());
    }

    static class Builder<I>
    extends AbstractElasticsearchProjection.AbstractBuilder<I>
    implements IdProjectionBuilder<I> {
        private final ElasticsearchIdProjection<I> projection;

        Builder(ElasticsearchSearchIndexScope<?> scope, ProjectionExtractionHelper<String> extractionHelper, ProjectionConverter<String, I> converter) {
            super(scope);
            this.projection = new ElasticsearchIdProjection(scope, extractionHelper, converter);
        }

        public SearchProjection<I> build() {
            return this.projection;
        }
    }
}

