/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.NamedDynamicTemplate;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.validation.impl.AbstractTypeMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.NamedDynamicTemplateListValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.PropertyMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

public class RootTypeMappingValidator
extends AbstractTypeMappingValidator<RootTypeMapping> {
    private final Validator<List<NamedDynamicTemplate>> dynamicTemplatesValidator = new NamedDynamicTemplateListValidator();
    private final Validator<PropertyMapping> propertyMappingValidator = new PropertyMappingValidator();

    @Override
    public void validate(ValidationErrorCollector errorCollector, RootTypeMapping expectedMapping, RootTypeMapping actualMapping) {
        if (expectedMapping == null) {
            return;
        }
        if (actualMapping == null) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.mappingMissing());
            return;
        }
        super.validate(errorCollector, expectedMapping, actualMapping);
        this.dynamicTemplatesValidator.validate(errorCollector, expectedMapping.getDynamicTemplates(), actualMapping.getDynamicTemplates());
    }

    @Override
    protected Validator<PropertyMapping> getPropertyMappingValidator() {
        return this.propertyMappingValidator;
    }
}

