/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.Collections;
import java.util.List;

public class RequestControllerState {
    private final boolean paused;
    private final int outstandingRequests;
    private final int maxRequests;
    private final List<EntryPointState> entryPoints;

    public RequestControllerState(boolean paused, int outstandingRequests, int maxRequests, List<EntryPointState> entryPoints) {
        this.paused = paused;
        this.outstandingRequests = outstandingRequests;
        this.maxRequests = maxRequests;
        this.entryPoints = entryPoints;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getOutstandingRequests() {
        return this.outstandingRequests;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public List<EntryPointState> getEntryPoints() {
        return Collections.unmodifiableList(this.entryPoints);
    }

    public static class EntryPointState {
        private final String deployment;
        private final String endpoint;
        private final boolean paused;
        private final int outstandingRequests;

        public EntryPointState(String deployment, String endpoint, boolean paused, int outstandingRequests) {
            this.deployment = deployment;
            this.endpoint = endpoint;
            this.paused = paused;
            this.outstandingRequests = outstandingRequests;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public int isOutstandingRequests() {
            return this.outstandingRequests;
        }
    }
}

