/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.jboss.as.appclient.deployment.ActiveApplicationClientProcessor;
import org.jboss.as.appclient.deployment.AppClientJBossAllParser;
import org.jboss.as.appclient.deployment.ApplicationClientDependencyProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientManifestProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientParsingDeploymentProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStartProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStructureProcessor;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.subsystem.AppClientSubsystemResourceDefinition;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

class AppClientSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final ServiceName APP_CLIENT_URI_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext", "appClientUri"});
    public static final ServiceName APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext", "appClientEjbProperties"});
    static final AppClientSubsystemAdd INSTANCE = new AppClientSubsystemAdd();
    private final String[] EMPTY_STRING = new String[0];

    private AppClientSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : AppClientSubsystemResourceDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String deployment = AppClientSubsystemResourceDefinition.DEPLOYMENT.resolveModelAttribute(context, model).asString();
        File file = new File(AppClientSubsystemResourceDefinition.FILE.resolveModelAttribute(context, model).asString());
        if (!file.exists()) {
            context.setRollbackOnly();
            throw AppClientLogger.ROOT_LOGGER.cannotFindAppClientFile(file.getAbsoluteFile());
        }
        String hostUrl = model.hasDefined("host-url") ? AppClientSubsystemResourceDefinition.HOST_URL.resolveModelAttribute(context, model).asString() : null;
        String connectionPropertiesUrl = model.hasDefined("connection-properties-url") ? AppClientSubsystemResourceDefinition.CONNECTION_PROPERTIES_URL.resolveModelAttribute(context, model).asString() : null;
        final List parameters = AppClientSubsystemResourceDefinition.PARAMETERS.unwrap((ExpressionResolver)context, model);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                if (deployment != null && !deployment.isEmpty()) {
                    processorTarget.addDeploymentProcessor("appclient", Phase.STRUCTURE, 3840, (DeploymentUnitProcessor)new ApplicationClientStructureProcessor(deployment));
                }
                processorTarget.addDeploymentProcessor("appclient", Phase.STRUCTURE, 2576, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(AppClientJBossAllParser.ROOT_ELEMENT, AppClientJBossAllParser.ATTACHMENT_KEY, (JBossAllXMLParser)new AppClientJBossAllParser()));
                processorTarget.addDeploymentProcessor("appclient", Phase.PARSE, 4353, (DeploymentUnitProcessor)new ApplicationClientParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.POST_MODULE, 7936, (DeploymentUnitProcessor)new ApplicationClientManifestProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.POST_MODULE, 8192, (DeploymentUnitProcessor)new ActiveApplicationClientProcessor(deployment));
                processorTarget.addDeploymentProcessor("appclient", Phase.DEPENDENCIES, 8192, (DeploymentUnitProcessor)new ApplicationClientDependencyProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.INSTALL, 8208, (DeploymentUnitProcessor)new ApplicationClientStartProcessor(parameters.toArray(AppClientSubsystemAdd.this.EMPTY_STRING)));
            }
        }, OperationContext.Stage.RUNTIME);
        ApplicationClientDeploymentService service = new ApplicationClientDeploymentService(file);
        context.getServiceTarget().addService(ApplicationClientDeploymentService.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getControllerValue()).install();
        try {
            if (connectionPropertiesUrl != null) {
                context.getServiceTarget().addService(APP_CLIENT_URI_SERVICE_NAME, new ConstantService<Object>(null)).install();
                context.getServiceTarget().addService(APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME, new ConstantService<String>(connectionPropertiesUrl)).install();
            } else {
                URI uri = hostUrl == null ? new URI("remote+http://localhost:8080") : new URI(hostUrl);
                context.getServiceTarget().addService(APP_CLIENT_URI_SERVICE_NAME, new ConstantService<URI>(uri)).install();
                context.getServiceTarget().addService(APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME, new ConstantService<String>(connectionPropertiesUrl)).install();
            }
        }
        catch (URISyntaxException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static final class ConstantService<T>
    implements Service<T> {
        private final T value;

        private ConstantService(T value) {
            this.value = value;
        }

        public void start(StartContext startContext) throws StartException {
        }

        public void stop(StopContext stopContext) {
        }

        public T getValue() throws IllegalStateException, IllegalArgumentException {
            return this.value;
        }
    }
}

