/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.Arrays;
import org.jboss.as.patching.metadata.ContentType;

public abstract class ContentItem {
    private final String name;
    private final byte[] contentHash;
    private final ContentType contentType;

    protected ContentItem(String name, byte[] contentHash, ContentType contentType) {
        this.name = name;
        this.contentHash = contentHash;
        this.contentType = contentType;
    }

    public byte[] getContentHash() {
        return this.contentHash;
    }

    public String getName() {
        return this.name;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public abstract String getRelativePath();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.contentHash);
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentItem other = (ContentItem)obj;
        if (!Arrays.equals(this.contentHash, other.contentHash)) {
            return false;
        }
        if (this.contentType != other.contentType) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

