/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jwt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import jakarta.ws.rs.ext.ContextResolver;
import org.jboss.resteasy.jwt.JsonWebToken;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;

public class JWTContextResolver
implements ContextResolver<ObjectMapper> {
    protected ObjectMapper mapper = new ObjectMapper();

    public JWTContextResolver() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        this.mapper.setPolymorphicTypeValidator((PolymorphicTypeValidator)new WhiteListPolymorphicTypeValidatorBuilder().build());
    }

    public JWTContextResolver(boolean indent) {
        this();
        if (indent) {
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public ObjectMapper getContext(Class<?> type) {
        if (JsonWebToken.class.isAssignableFrom(type)) {
            return this.mapper;
        }
        return null;
    }
}

