/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ApplicationException;

class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = Logger.getLogger(DefaultExceptionMapper.class);
    static final DefaultExceptionMapper INSTANCE = new DefaultExceptionMapper();

    DefaultExceptionMapper() {
    }

    public Response toResponse(Throwable exception) {
        Throwable cause;
        if (exception instanceof ApplicationException && (cause = exception.getCause()) != null) {
            return this.process(cause);
        }
        return this.process(exception);
    }

    private Response process(Throwable exception) {
        LOGGER.debug((Object)"Processing exception with the default exception mapper.", exception);
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        return Response.serverError().entity((Object)exception.getMessage()).build();
    }
}

