/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaType<J> domainJtd;
    private final JavaType<?> relationalJtd;
    private final JdbcType jdbcType;
    private final JpaAttributeConverter<J, ?> valueConverter;
    private final MutabilityPlan<J> mutabilityPlan;
    private final JdbcMapping jdbcMapping;
    private final BasicType<J> legacyResolvedType;

    public static <T> NamedConverterResolution<T> from(ConverterDescriptor converterDescriptor, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, NamedConverterResolution.converter(converterCreationContext, converterDescriptor), sqlTypeIndicators, context);
    }

    public static <T> NamedConverterResolution<T> from(String name, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(context.getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class).classForName(converterClassName), context.getBootstrapContext().getClassmateContext());
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, NamedConverterResolution.converter(converterCreationContext, converterDescriptor), sqlTypeIndicators, context);
    }

    private static <T> JpaAttributeConverter<T, ?> converter(JpaAttributeConverterCreationContext converterCreationContext, ConverterDescriptor converterDescriptor) {
        return converterDescriptor.createJpaAttributeConverter(converterCreationContext);
    }

    private static <T> NamedConverterResolution<T> fromInternal(Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JpaAttributeConverter<T, ?> converter, JdbcTypeIndicators sqlTypeIndicators, MetadataBuildingContext context) {
        ImmutableMutabilityPlan explicitMutabilityPlan;
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType explicitJtd = explicitJtdAccess != null ? (JavaType)explicitJtdAccess.apply(typeConfiguration) : null;
        JavaType domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaType();
        JdbcType explicitJdbcType = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
        JavaType relationalJtd = converter.getRelationalJavaType();
        JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(sqlTypeIndicators);
        ImmutableMutabilityPlan immutableMutabilityPlan = explicitMutabilityPlan = explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null;
        MutabilityPlan<Object> mutabilityPlan = explicitMutabilityPlan != null ? explicitMutabilityPlan : (!domainJtd.getMutabilityPlan().isMutable() ? ImmutableMutabilityPlan.instance() : new AttributeConverterMutabilityPlanImpl(converter, true));
        return new NamedConverterResolution(domainJtd, relationalJtd, jdbcType, converter, mutabilityPlan, context.getBootstrapContext().getTypeConfiguration());
    }

    public NamedConverterResolution(JavaType<J> domainJtd, JavaType<?> relationalJtd, JdbcType jdbcType, JpaAttributeConverter<J, ?> valueConverter, MutabilityPlan<J> mutabilityPlan, TypeConfiguration typeConfiguration) {
        assert (domainJtd != null);
        this.domainJtd = domainJtd;
        assert (relationalJtd != null);
        this.relationalJtd = relationalJtd;
        assert (jdbcType != null);
        this.jdbcType = jdbcType;
        assert (valueConverter != null);
        this.valueConverter = valueConverter;
        assert (mutabilityPlan != null);
        this.mutabilityPlan = mutabilityPlan;
        this.jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType);
        this.legacyResolvedType = new AttributeConverterTypeAdapter<J>("converted::" + valueConverter.getConverterJavaType().getJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getJavaType().getTypeName(), relationalJtd.getJavaType().getTypeName()), valueConverter, jdbcType, relationalJtd, domainJtd, mutabilityPlan);
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.legacyResolvedType;
    }

    @Override
    public JavaType<J> getDomainJavaType() {
        return this.domainJtd;
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.relationalJtd;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JpaAttributeConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.valueConverter.getConverterBean().getBeanClass().getName() + ")";
    }
}

