/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;

public class ClientDefinedAnycastConsumerTest
extends AmqpClientTestSupport {
    SimpleString address = new SimpleString("testAddress");

    @Test(timeout=60000L)
    public void testConsumeFromSingleQueueOnAddressSameName() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        this.sendMessages(this.address.toString(), 1);
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedAnycastConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedAnycastConsumerTest.assertEquals((long)1L, (long)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }
}

