/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class BackupAuthenticationTest
extends FailoverTestBase {
    private static CountDownLatch latch;

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        latch = new CountDownLatch(1);
        super.setUp();
    }

    @Test
    public void testWrongPasswordSetting() throws Exception {
        FakeServiceComponent fakeServiceComponent = new FakeServiceComponent("fake web server");
        Wait.assertTrue(() -> ((ActiveMQServer)this.liveServer.getServer()).isActive());
        this.waitForServerToStart(this.liveServer.getServer());
        this.backupServer.start();
        this.backupServer.getServer().addExternalComponent((ActiveMQComponent)fakeServiceComponent, true);
        BackupAuthenticationTest.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Wait.waitFor(() -> !this.backupServer.isStarted());
        BackupAuthenticationTest.assertFalse((String)"backup should have stopped", (boolean)this.backupServer.isStarted());
        Wait.assertFalse(fakeServiceComponent::isStarted);
        this.backupServer.stop();
        this.liveServer.stop();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
        this.backupConfig.setClusterPassword("crocodile");
        this.liveConfig.setIncomingInterceptorClassNames(Arrays.asList(NotifyingInterceptor.class.getName()));
        this.backupConfig.setSecurityEnabled(true);
        this.liveConfig.setSecurityEnabled(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    public static final class NotifyingInterceptor
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 115) {
                latch.countDown();
            } else if (packet.getType() == 125) {
                latch.countDown();
            }
            return true;
        }
    }
}

