/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor2;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor3;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FailoverTest
extends FailoverTestBase {
    private static final Logger log = Logger.getLogger(FailoverTest.class);
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    protected static final int NUM_MESSAGES = 100;
    protected ServerLocator locator;
    protected ClientSessionFactoryInternal sf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks, ackBatchSize));
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks));
    }

    protected ClientSession createSession(ClientSessionFactory sf1) throws Exception {
        return this.addClientSession(sf1.createSession());
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailover() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 500L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        final ClientSession session = this.createSession((ClientSessionFactory)sf1, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        final ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        final CountDownLatch latch = new CountDownLatch(10);
        final CountDownLatch latchFailed = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 500; ++i) {
                    ClientMessage message = session.createMessage(true);
                    message.putIntProperty("counter", i);
                    try {
                        producer.send((Message)message);
                        if (i >= 10) continue;
                        latch.countDown();
                        if (latch.getCount() != 0L) continue;
                        latchFailed.await(10L, TimeUnit.SECONDS);
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            if (producer.isClosed()) continue;
                            producer.send((Message)message);
                            continue;
                        }
                        catch (ActiveMQException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        Assert.assertTrue((String)"latch released", (boolean)latch.await(10L, TimeUnit.SECONDS));
        this.crash(session);
        latchFailed.countDown();
        t.join(30000L);
        if (t.isAlive()) {
            t.interrupt();
            Assert.fail((String)"Thread still alive");
        }
        Assert.assertTrue((boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS));
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage m = consumer.receive(1000L);
            Assert.assertNotNull((String)("message #=" + i), (Object)m);
        }
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailoverConsume() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setBlockOnAcknowledge(true).setReconnectAttempts(-1).setRetryInterval(10L).setAckBatchSize(0);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        final ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(1);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        final HashMap received = new HashMap();
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                Integer counter = message.getIntProperty("counter");
                received.put(counter, message);
                try {
                    log.debug((Object)("acking message = id = " + message.getMessageID() + ", counter = " + message.getIntProperty("counter")));
                    message.acknowledge();
                    session.commit();
                }
                catch (ActiveMQException e) {
                    try {
                        session.rollback();
                    }
                    catch (Exception e2) {
                        e.printStackTrace();
                    }
                    e.printStackTrace();
                    return;
                }
                log.debug((Object)("Acked counter = " + counter));
                if (counter.equals(10)) {
                    latch.countDown();
                }
                if (received.size() == 100) {
                    endLatch.countDown();
                }
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        log.debug((Object)"crashing session");
        this.crash(session);
        Assert.assertTrue((boolean)endLatch.await(60L, TimeUnit.SECONDS));
        session.close();
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailoverConsumeBlocked() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setConsumerWindowSize(0).setBlockOnDurableSend(true).setAckBatchSize(0).setBlockOnAcknowledge(true).setReconnectAttempts(-1).setAckBatchSize(0).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 200L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            message.putBooleanProperty("end", i == 499);
            producer.send((Message)message);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(1);
        final ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        final HashMap received = new HashMap();
        Thread t = new Thread(){

            @Override
            public void run() {
                ClientMessage message = null;
                try {
                    while ((message = this.getMessage()) != null) {
                        Integer counter = message.getIntProperty("counter");
                        received.put(counter, message);
                        try {
                            log.debug((Object)("acking message = id = " + message.getMessageID() + ", counter = " + message.getIntProperty("counter")));
                            message.acknowledge();
                        }
                        catch (ActiveMQException e) {
                            e.printStackTrace();
                            continue;
                        }
                        log.debug((Object)("Acked counter = " + counter));
                        if (counter.equals(10)) {
                            latch.countDown();
                        }
                        if (received.size() == 500) {
                            endLatch.countDown();
                        }
                        if (!message.getBooleanProperty("end").booleanValue()) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)("failing due to exception " + e));
                }
            }

            private ClientMessage getMessage() {
                while (true) {
                    try {
                        ClientMessage msg = consumer.receive(20000L);
                        if (msg == null) {
                            log.debug((Object)"Returning null message on consuming");
                        }
                        return msg;
                    }
                    catch (ActiveMQObjectClosedException oce) {
                        throw new RuntimeException(oce);
                    }
                    catch (ActiveMQException ignored) {
                        ignored.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
        latch.await(10L, TimeUnit.SECONDS);
        log.debug((Object)"crashing session");
        this.crash(session);
        endLatch.await(60L, TimeUnit.SECONDS);
        t.join();
        Assert.assertTrue((String)("received only " + received.size()), (received.size() == 500 ? (byte)1 : 0) != 0);
        session.close();
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailoverTransactionCommit() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        final CountDownLatch connectionFailed = new CountDownLatch(1);
        session.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                connectionFailed.countDown();
            }
        });
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.start((Xid)xid, 0);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        this.crash(true, session);
        try {
            session.commit((Xid)xid, false);
        }
        catch (XAException e) {
            Assert.assertTrue((boolean)connectionFailed.await(10L, TimeUnit.SECONDS));
            session.commit((Xid)xid, false);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage m = consumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getIntProperty("counter").intValue());
        }
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailoverTransactionCommitTimeoutCommunication() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(50L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, false, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        final CountDownLatch connectionFailed = new CountDownLatch(1);
        session.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                connectionFailed.countDown();
            }
        });
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage m = null;
        for (int i = 0; i < 500; ++i) {
            m = consumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getIntProperty("counter").intValue());
        }
        m.acknowledge();
        this.crash(false, session);
        try {
            session.commit();
            FailoverTest.fail((String)"Exception expected");
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        Thread.sleep(1000L);
        m = null;
        for (int i = 0; i < 500; ++i) {
            m = consumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getIntProperty("counter").intValue());
        }
        m.acknowledge();
        session.commit();
    }

    @Test(timeout=120000L)
    public void testTimeoutOnFailoverTransactionRollback() throws Exception {
        this.locator.setCallTimeout(2000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 1000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.start((Xid)xid, 0);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        this.crash(true, session);
        try {
            session.rollback((Xid)xid);
        }
        catch (XAException e) {
            try {
                session.rollback((Xid)xid);
            }
            catch (Exception ignored) {
                log.trace((Object)ignored.getMessage(), (Throwable)ignored);
            }
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage m = consumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test(timeout=120000L)
    public void testNonTransactedWithZeroConsumerWindowSize() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        this.createClientSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            this.setBody(i, message);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        final CountDownLatch latch = new CountDownLatch(100);
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                latch.countDown();
            }
        });
        session.start();
        this.crash(session);
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    protected void createClientSessionFactory() throws Exception {
        this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
    }

    @Test(timeout=120000L)
    public void testNonTransacted() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        session.close();
        this.sf.close();
        Assert.assertEquals((long)0L, (long)this.sf.numSessions());
        Assert.assertEquals((long)0L, (long)this.sf.numConnections());
    }

    @Test(timeout=60000L)
    public void testFailBothRestartLive() throws Exception {
        ServerLocatorInternal locator = this.getServerLocator();
        locator.setReconnectAttempts(-1).setRetryInterval(10L);
        this.sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        this.backupServer.getServer().fail(true);
        this.decrementActivationSequenceForForceRestartOf(this.liveServer);
        this.liveServer.start();
        consumer.close();
        producer.close();
        producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.sf.close();
        Assert.assertEquals((long)0L, (long)this.sf.numSessions());
        Assert.assertEquals((long)0L, (long)this.sf.numConnections());
    }

    @Test
    public void testFailLiveTooSoon() throws Exception {
        ServerLocatorInternal locator = this.getServerLocator();
        locator.setReconnectAttempts(-1);
        locator.setRetryInterval(10L);
        this.sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.waitForBackupConfig(this.sf);
        TransportConfiguration initialLive = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        TransportConfiguration initialBackup = this.getFieldFromSF(this.sf, "backupConnectorConfig");
        this.instanceLog.debug((Object)("initlive: " + initialLive));
        this.instanceLog.debug((Object)("initback: " + initialBackup));
        TransportConfiguration last = this.getFieldFromSF(this.sf, "connectorConfig");
        TransportConfiguration current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        this.instanceLog.debug((Object)("now last: " + last));
        this.instanceLog.debug((Object)("now current: " + current));
        FailoverTest.assertTrue((boolean)current.equals((Object)initialLive));
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        this.crash(new ClientSession[0]);
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        last = this.getFieldFromSF(this.sf, "connectorConfig");
        current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        this.instanceLog.debug((Object)("now after live crashed last: " + last));
        this.instanceLog.debug((Object)("now current: " + current));
        FailoverTest.assertTrue((boolean)current.equals((Object)initialBackup));
        this.beforeRestart(this.liveServer);
        this.adaptLiveConfigForReplicatedFailBack(this.liveServer);
        this.liveServer.getServer().start();
        Assert.assertTrue((String)"live initialized...", (boolean)this.liveServer.getServer().waitForActivation(40L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
        this.liveServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.backupServer.isStarted());
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        last = this.getFieldFromSF(this.sf, "connectorConfig");
        current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        this.instanceLog.debug((Object)("now after live back again last: " + last));
        this.instanceLog.debug((Object)("now current: " + current));
        FailoverTest.assertTrue((boolean)current.isSameParams(initialLive));
        this.setSFFieldValue(this.sf, "backupConnectorConfig", null);
        this.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        this.sf.close();
        Assert.assertEquals((long)0L, (long)this.sf.numSessions());
        Assert.assertEquals((long)0L, (long)this.sf.numConnections());
    }

    protected void waitForBackupConfig(ClientSessionFactoryInternal sf) throws NoSuchFieldException, IllegalAccessException, InterruptedException {
        TransportConfiguration initialBackup = this.getFieldFromSF(sf, "backupConnectorConfig");
        for (int cnt = 50; initialBackup == null && cnt > 0; --cnt) {
            Thread.sleep(200L);
            initialBackup = this.getFieldFromSF(sf, "backupConnectorConfig");
        }
    }

    protected void setSFFieldValue(ClientSessionFactoryInternal sf, String tcName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field tcField = ClientSessionFactoryImpl.class.getDeclaredField(tcName);
        tcField.setAccessible(true);
        tcField.set(sf, value);
    }

    protected TransportConfiguration getFieldFromSF(ClientSessionFactoryInternal sf, String tcName) throws NoSuchFieldException, IllegalAccessException {
        Field tcField = ClientSessionFactoryImpl.class.getDeclaredField(tcName);
        tcField.setAccessible(true);
        return (TransportConfiguration)tcField.get(sf);
    }

    @Test(timeout=120000L)
    public void testFailBack() throws Exception {
        boolean doFailBack = true;
        HAPolicy haPolicy = this.backupServer.getServer().getHAPolicy();
        if (haPolicy instanceof ReplicaPolicy) {
            ((ReplicaPolicy)haPolicy).setMaxSavedReplicatedJournalsSize(1);
        }
        this.simpleFailover(haPolicy instanceof ReplicaPolicy || haPolicy instanceof ReplicationBackupPolicy, doFailBack);
    }

    @Test(timeout=120000L)
    public void testFailBackLiveRestartsBackupIsGone() throws Exception {
        boolean replication;
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        SimpleString liveId = this.liveServer.getServer().getNodeID();
        this.crash(session);
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        session.commit();
        Assert.assertEquals((String)"backup must be running with the same nodeID", (Object)liveId, (Object)this.backupServer.getServer().getNodeID());
        this.sf.close();
        this.backupServer.crash(new ClientSession[0]);
        Thread.sleep(100L);
        Assert.assertFalse((String)"backup is not running", (boolean)this.backupServer.isStarted());
        boolean isBackup = this.liveServer.getServer().getHAPolicy() instanceof BackupPolicy || this.liveServer.getServer().getHAPolicy() instanceof ReplicationBackupPolicy;
        Assert.assertFalse((String)"must NOT be a backup", (boolean)isBackup);
        this.adaptLiveConfigForReplicatedFailBack(this.liveServer);
        this.beforeRestart(this.liveServer);
        this.decrementActivationSequenceForForceRestartOf(this.liveServer);
        this.liveServer.start();
        Assert.assertTrue((String)"live initialized...", (boolean)this.liveServer.getServer().waitForActivation(15L, TimeUnit.SECONDS));
        this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        boolean bl = replication = this.liveServer.getServer().getHAPolicy() instanceof ReplicatedPolicy || this.liveServer.getServer().getHAPolicy() instanceof ReplicationPrimaryPolicy;
        if (replication) {
            this.receiveMessages(consumer2, 0, 100, true);
        }
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    @Test(timeout=120000L)
    public void testSimpleFailover() throws Exception {
        HAPolicy haPolicy = this.backupServer.getServer().getHAPolicy();
        this.simpleFailover(haPolicy instanceof ReplicaPolicy || haPolicy instanceof ReplicationBackupPolicy, false);
    }

    @Test(timeout=120000L)
    public void testWithoutUsingTheBackup() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        this.backupServer.stop();
        this.backupServer.start();
        FailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        session.commit();
        session.start();
        producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        this.backupServer.stop();
        this.beforeRestart(this.backupServer);
        this.backupServer.start();
        FailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
        this.backupServer.stop();
        this.liveServer.stop();
        this.beforeRestart(this.liveServer);
        this.liveServer.start();
        this.liveServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        this.receiveMessages(consumer2, 0, 100, true);
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    private void simpleFailover(boolean isReplicated, boolean doFailBack) throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        SimpleString liveId = this.liveServer.getServer().getNodeID();
        this.crash(session);
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        Assert.assertEquals((String)"backup must be running with the same nodeID", (Object)liveId, (Object)this.backupServer.getServer().getNodeID());
        if (doFailBack) {
            Assert.assertFalse((String)"must NOT be a backup", (boolean)this.liveServer.getServer().getHAPolicy().isBackup());
            this.adaptLiveConfigForReplicatedFailBack(this.liveServer);
            this.beforeRestart(this.liveServer);
            this.liveServer.start();
            Assert.assertTrue((String)"live initialized...", (boolean)this.liveServer.getServer().waitForActivation(40L, TimeUnit.SECONDS));
            if (isReplicated) {
                Wait.assertTrue(() -> this.backupServer.getServer().getHAPolicy().isBackup());
                Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
                Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer.getServer()).isReplicaSync());
            } else {
                Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
                this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
                Assert.assertTrue((boolean)this.backupServer.isStarted());
            }
            if (isReplicated) {
                FileMoveManager moveManager = new FileMoveManager(this.backupServer.getServer().getConfiguration().getJournalLocation(), 0, new String[0]);
                Wait.assertTrue(() -> moveManager.getNumberOfFolders() <= 2);
            }
        } else {
            this.backupServer.stop();
            this.beforeRestart(this.backupServer);
            this.backupServer.start();
            Assert.assertTrue((boolean)this.backupServer.getServer().waitForActivation(10L, TimeUnit.SECONDS));
        }
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        this.receiveMessages(consumer2, 0, 100, true);
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    private void assertNoMoreMessages(ClientConsumer consumer) throws ActiveMQException {
        ClientMessage msg = consumer.receiveImmediate();
        Assert.assertNull((String)("there should be no more messages to receive! " + msg), (Object)msg);
    }

    protected void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
    }

    @Test(timeout=120000L)
    public void testConsumeTransacted() throws Exception {
        ClientMessage message;
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 10;
        this.sendMessages(session, producer, 10);
        session.commit();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertNotNull((String)("Just crashed? " + (i == 6) + " " + i), (Object)message);
            message.acknowledge();
            if (i != 5) continue;
            this.crash(session);
        }
        try {
            session.commit();
            Assert.fail((String)"session must have rolled back on failover");
        }
        catch (ActiveMQTransactionRolledBackException i) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        consumer.close();
        consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertNotNull((String)("Expecting message #" + i), (Object)message);
            message.acknowledge();
        }
        session.commit();
        session.close();
    }

    protected ClientSession createSessionAndQueue() throws Exception {
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        return session;
    }

    @Test(timeout=120000L)
    public void testFailoverOnInitialConnection() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        this.crash(new ClientSession[0]);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session, producer, 100);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        session.close();
    }

    @Test(timeout=120000L)
    public void testTransactedMessagesSentSoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        Assert.assertTrue((boolean)session.isRollbackOnly());
        try {
            session.commit();
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((String)("message should be null! Was: " + message), (Object)message);
        session.close();
    }

    @Test(timeout=120000L)
    public void testTransactedMessagesSentSoRollbackAndContinueWork() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        Assert.assertTrue((boolean)session.isRollbackOnly());
        try {
            session.commit();
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientMessage message = session.createMessage(false);
        int counter = RandomUtil.randomInt();
        message.putIntProperty("counter", counter);
        producer.send((Message)message);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        message = consumer.receive(1000L);
        Assert.assertNotNull((String)"expecting a message", (Object)message);
        Assert.assertEquals((long)counter, (long)message.getIntProperty("counter").intValue());
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTransactedMessagesNotSentSoNoRollback() throws Exception {
        try {
            this.createSessionFactory();
            ClientSession session = this.createSessionAndQueue();
            ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
            this.sendMessagesSomeDurable(session, producer);
            session.commit();
            this.crash(session);
            Assert.assertFalse((boolean)session.isRollbackOnly());
            session.commit();
            ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
            session.start();
            this.receiveDurableMessages(consumer);
            Assert.assertNull((Object)consumer.receiveImmediate());
            session.commit();
            session.close();
        }
        finally {
            try {
                this.liveServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test(timeout=120000L)
    public void testTransactedMessagesWithConsumerStartedBeforeFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        session.commit();
        Assert.assertFalse((boolean)session.isRollbackOnly());
        this.crash(session);
        session.commit();
        session.close();
        session = this.createSession((ClientSessionFactory)this.sf, false, false);
        consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.commit();
    }

    @Test(timeout=120000L)
    public void testTransactedMessagesConsumedSoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        this.crash(session2);
        Assert.assertTrue((boolean)session2.isRollbackOnly());
        try {
            session2.commit();
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test(timeout=120000L)
    public void testTransactedMessagesNotConsumedSoNoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session1, producer, 100);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer, 0, 50, true);
        session2.commit();
        consumer.close();
        this.crash(session2);
        Assert.assertFalse((boolean)session2.isRollbackOnly());
        consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        for (int i = 50; i < 100; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((String)("expecting message " + i), (Object)message);
            this.assertMessageBody(i, message);
            Assert.assertEquals((long)i, (long)message.getIntProperty("counter").intValue());
            message.acknowledge();
        }
        session2.commit();
        Assert.assertNull((Object)consumer.receiveImmediate());
    }

    @Test(timeout=120000L)
    public void testXAMessagesSentSoRollbackOnEnd() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        try {
            session.end((Xid)xid, 0x4000000);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-7L, (long)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test(timeout=120000L)
    public void testXAMessagesSentSoRollbackOnEnd2() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.crash(session);
        producer.send((Message)this.createMessage(session, 1, true));
        try {
            session.end((Xid)xid, 0x4000000);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException xAException) {
            // empty catch block
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test(timeout=120000L)
    public void testXAMessagesSentSoRollbackOnPrepare() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        this.crash(session);
        try {
            session.prepare((Xid)xid);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-7L, (long)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        producer.close();
        consumer.close();
    }

    @Test(timeout=120000L)
    public void testXAMessagesSentSoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        this.crash(session);
        try {
            session.commit((Xid)xid, false);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-4L, (long)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test(timeout=120000L)
    public void testXAMessagesNotSentSoNoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        XidImpl xid2 = new XidImpl("tfytftyf".getBytes(), 54654, "iohiuohiuhgiu".getBytes());
        session.start((Xid)xid2, 0);
        this.receiveDurableMessages(consumer);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
    }

    @Test(timeout=120000L)
    public void testXAMessagesConsumedSoRollbackOnEnd() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        this.crash(session2);
        try {
            session2.end((Xid)xid, 0x4000000);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-7L, (long)e.errorCode);
        }
    }

    @Test(timeout=120000L)
    public void testXAMessagesConsumedSoRollbackOnEnd2() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)this.createMessage(session1, i, true));
        }
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.crash(session2);
        this.receiveMessages(consumer);
        try {
            session2.end((Xid)xid, 0x4000000);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException xAException) {
            // empty catch block
        }
        this.receiveMessages(consumer);
    }

    @Test(timeout=120000L)
    public void testXAMessagesConsumedSoRollbackOnPrepare() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        session2.end((Xid)xid, 0x4000000);
        this.crash(session2);
        try {
            session2.prepare((Xid)xid);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-7L, (long)e.errorCode);
        }
    }

    @Test(timeout=120000L)
    public void testXAMessagesConsumedSoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        session2.end((Xid)xid, 0x4000000);
        this.crash(session2);
        try {
            session2.commit((Xid)xid, false);
            Assert.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assert.assertEquals((long)-4L, (long)e.errorCode);
        }
        session1.close();
        session2.close();
    }

    @Test(timeout=120000L)
    public void testCreateNewFactoryAfterFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.crash(true, session);
        session.close();
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                this.createClientSessionFactory();
                break;
            }
            catch (Exception e) {
                Thread.sleep(100L);
            }
        }
        session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
    }

    @Test(timeout=120000L)
    public void testFailoverMultipleSessionsWithConsumers() throws Exception {
        this.createSessionFactory();
        int numSessions = 5;
        int numConsumersPerSession = 5;
        HashMap sessionConsumerMap = new HashMap();
        for (int i = 0; i < 5; ++i) {
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>();
            for (int j = 0; j < 5; ++j) {
                SimpleString queueName = new SimpleString("queue" + i + "-" + j);
                session.createQueue(new QueueConfiguration(queueName).setAddress(FailoverTestBase.ADDRESS));
                ClientConsumer consumer = session.createConsumer(queueName);
                consumers.add(consumer);
            }
            sessionConsumerMap.put(session, consumers);
        }
        ClientSession sendSession = this.createSession((ClientSessionFactory)this.sf, true, true);
        ClientProducer producer = sendSession.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(sendSession, producer, 100);
        Set sessionSet = sessionConsumerMap.keySet();
        ClientSession[] sessions = new ClientSession[sessionSet.size()];
        sessionSet.toArray(sessions);
        this.crash(sessions);
        for (ClientSession session : sessionConsumerMap.keySet()) {
            session.start();
        }
        for (List consumerList : sessionConsumerMap.values()) {
            for (ClientConsumer consumer : consumerList) {
                this.receiveMessages(consumer);
            }
        }
    }

    @Test(timeout=120000L)
    public void testFailWithBrowser() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS, true);
        session.start();
        this.receiveMessages(consumer, 0, 100, false);
        this.crash(session);
        this.receiveDurableMessages(consumer);
    }

    protected void sendMessagesSomeDurable(ClientSession session, ClientProducer producer) throws Exception {
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)this.createMessage(session, i, this.isDurable(i)));
        }
    }

    @Test(timeout=120000L)
    public void testFailThenReceiveMoreMessagesAfterFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            this.assertMessageBody(i, message);
            Assert.assertEquals((long)i, (long)message.getIntProperty("counter").intValue());
        }
        this.crash(session);
        this.receiveDurableMessages(consumer);
    }

    protected void receiveDurableMessages(ClientConsumer consumer) throws ActiveMQException {
        ClientMessage repeatMessage = null;
        for (int i = 0; i < 100; ++i) {
            int msgInternalCounter;
            ClientMessage message;
            if (repeatMessage != null) {
                message = repeatMessage;
                repeatMessage = null;
            } else {
                message = consumer.receive(50L);
            }
            if (message != null && (msgInternalCounter = message.getIntProperty("counter").intValue()) == i + 1) {
                Assert.assertFalse((String)("a message on counter=" + i + " was expected"), (boolean)this.isDurable(i));
                repeatMessage = message;
                continue;
            }
            if (this.isDurable(i)) {
                Assert.assertNotNull((Object)message);
            }
            if (message == null) continue;
            this.assertMessageBody(i, message);
            Assert.assertEquals((long)i, (long)message.getIntProperty("counter").intValue());
            message.acknowledge();
        }
    }

    private boolean isDurable(int i) {
        return i % 2 == 0;
    }

    @Test(timeout=120000L)
    public void testFailThenReceiveMoreMessagesAfterFailover2() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        this.crash(session);
        for (int i = 100; i < 200; ++i) {
            producer.send((Message)this.createMessage(session, i, this.isDurable(i)));
        }
        this.receiveMessages(consumer, 100, 200, true);
    }

    protected void receiveMessages(ClientConsumer consumer) throws ActiveMQException {
        this.receiveMessages(consumer, 0, 100, true);
    }

    @Test(timeout=120000L)
    public void testSimpleSendAfterFailoverDurableTemporary() throws Exception {
        this.doSimpleSendAfterFailover(true, true);
    }

    @Test(timeout=120000L)
    public void testSimpleSendAfterFailoverNonDurableTemporary() throws Exception {
        this.doSimpleSendAfterFailover(false, true);
    }

    @Test(timeout=120000L)
    public void testSimpleSendAfterFailoverDurableNonTemporary() throws Exception {
        this.doSimpleSendAfterFailover(true, false);
    }

    @Test(timeout=120000L)
    public void testSimpleSendAfterFailoverNonDurableNonTemporary() throws Exception {
        this.doSimpleSendAfterFailover(false, false);
    }

    private void doSimpleSendAfterFailover(boolean durable, boolean temporary) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(durable && !temporary)).setTemporary(Boolean.valueOf(temporary)));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.crash(session);
        this.sendMessagesSomeDurable(session, producer);
        this.receiveMessages(consumer);
    }

    @Test(timeout=120000L)
    public void testMultipleSessionFailover() throws Exception {
        String address = "TEST";
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session1 = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        this.backupServer.addInterceptor(new Interceptor(){
            private int index = 0;

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getType() == 30) {
                    ++this.index;
                    if (this.index == 2 || this.index == 3) {
                        Channel sessionChannel = ((RemotingConnectionImpl)connection).getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
                        sessionChannel.send((Packet)new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException()));
                        return false;
                    }
                }
                return true;
            }
        });
        session1.start();
        session2.start();
        this.crash(session1, session2);
        session1.createQueue(new QueueConfiguration("TEST").setAddress("TEST"));
        ClientProducer clientProducer = session1.createProducer("TEST");
        clientProducer.send((Message)session1.createMessage(false));
        ClientConsumer clientConsumer = session2.createConsumer("TEST");
        ClientMessage message = clientConsumer.receive(3000L);
        Assert.assertNotNull((Object)message);
    }

    @Test(timeout=120000L)
    public void testChannelStateDuringFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        final AtomicBoolean channelLockedDuringFailover = new AtomicBoolean(false);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        this.backupServer.addInterceptor(new Interceptor(){
            private int index = 0;

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (this.index < 1 && packet.getType() == 30) {
                    FailoverTest.this.sf.getConnection().addCloseListener(() -> {
                        ++this.index;
                        ActiveMQSessionContext sessionContext = (ActiveMQSessionContext)((ClientSessionInternal)session).getSessionContext();
                        channelLockedDuringFailover.set(sessionContext.getSessionChannel().isLocked());
                    });
                    Channel sessionChannel = ((RemotingConnectionImpl)connection).getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
                    sessionChannel.send((Packet)new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException()));
                    return false;
                }
                return true;
            }
        });
        session.start();
        this.crash(session);
        Assert.assertTrue((boolean)channelLockedDuringFailover.get());
    }

    @Test(timeout=120000L)
    public void testForceBlockingReturn() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.createClientSessionFactory();
        DelayInterceptor interceptor = new DelayInterceptor();
        this.liveServer.getServer().getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        final ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        class Sender
        extends Thread {
            volatile ActiveMQException e;

            Sender() {
            }

            @Override
            public void run() {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeString("message");
                try {
                    producer.send((Message)message);
                }
                catch (ActiveMQException e1) {
                    this.e = e1;
                }
            }
        }
        Sender sender = new Sender();
        sender.start();
        FailoverTest.assertTrue((boolean)interceptor.await());
        this.crash(session);
        sender.join();
        Assert.assertNotNull((Object)((Object)sender.e));
        Assert.assertNotNull((Object)sender.e.getCause());
        Assert.assertEquals((Object)sender.e.getType(), (Object)ActiveMQExceptionType.UNBLOCKED);
        Assert.assertEquals((Object)((ActiveMQException)sender.e.getCause()).getType(), (Object)ActiveMQExceptionType.DISCONNECTED);
        session.close();
    }

    @Test(timeout=120000L)
    public void testCommitOccurredUnblockedAndResendNoDuplicates() throws Exception {
        ClientMessage message;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        String txID = "my-tx-id";
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = session.createMessage(true);
            if (i == 0) {
                message2.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, new SimpleString(txID));
            }
            this.setBody(i, message2);
            message2.putIntProperty("counter", i);
            producer.send((Message)message2);
        }
        class Committer
        extends Thread {
            DelayInterceptor2 interceptor = new DelayInterceptor2();
            volatile boolean failed = true;

            Committer() {
            }

            @Override
            public void run() {
                try {
                    FailoverTest.this.sf.getServerLocator().addIncomingInterceptor((Interceptor)this.interceptor);
                    session.commit();
                }
                catch (ActiveMQTransactionRolledBackException trbe) {
                    FailoverTest.this.sf.getServerLocator().removeIncomingInterceptor((Interceptor)this.interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (ActiveMQTransactionOutcomeUnknownException toue) {
                    FailoverTest.this.sf.getServerLocator().removeIncomingInterceptor((Interceptor)this.interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }
        Committer committer = new Committer();
        committer.start();
        Assert.assertTrue((boolean)committer.interceptor.await());
        this.crash(session);
        committer.join();
        Assert.assertFalse((String)"second attempt succeed?", (boolean)committer.failed);
        session.close();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        producer = session2.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            message = session2.createMessage(true);
            if (i == 0) {
                message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, new SimpleString(txID));
            }
            this.setBody(i, message);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        try {
            session2.commit();
            Assert.fail((String)"expecting DUPLICATE_ID_REJECTED exception");
        }
        catch (ActiveMQDuplicateIdException i) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test(timeout=120000L)
    public void testCommitDidNotOccurUnblockedAndResend() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session, producer, 100);
        class Committer
        extends Thread {
            volatile boolean failed = true;

            Committer() {
            }

            @Override
            public void run() {
                DelayInterceptor3 interceptor = new DelayInterceptor3();
                try {
                    FailoverTest.this.liveServer.addInterceptor(interceptor);
                    session.commit();
                }
                catch (ActiveMQTransactionRolledBackException trbe) {
                    FailoverTest.this.liveServer.removeInterceptor(interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException activeMQException) {}
                }
                catch (ActiveMQTransactionOutcomeUnknownException toue) {
                    FailoverTest.this.liveServer.removeInterceptor(interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException activeMQException) {}
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }
        Committer committer = new Committer();
        committer.start();
        this.crash(session);
        committer.join();
        Assert.assertFalse((String)"commiter failed should be false", (boolean)committer.failed);
        session.close();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        producer = session2.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session2, producer, 100);
        session2.commit();
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((String)"expecting null message", (Object)message);
    }

    @Test(timeout=120000L)
    public void testBackupServerNotRemoved() throws Exception {
        if (!(this.backupServer.getServer().getHAPolicy() instanceof SharedStoreSlavePolicy)) {
            return;
        }
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.backupServer.stop();
        this.liveServer.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        this.backupServer.start();
        Assert.assertTrue((String)"session failure listener", (boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
    }

    @Test(timeout=120000L)
    public void testLiveAndBackupLiveComesBack() throws Exception {
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        this.backupServer.stop();
        this.liveServer.crash(new ClientSession[0]);
        this.beforeRestart(this.liveServer);
        this.beforeRestart(this.liveServer);
        this.liveServer.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
    }

    @Test(timeout=120000L)
    public void testLiveAndBackupLiveComesBackNewFactory() throws Exception {
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        this.backupServer.stop();
        this.liveServer.crash(new ClientSession[0]);
        this.beforeRestart(this.liveServer);
        this.liveServer.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.close();
        this.sf.close();
        this.createClientSessionFactory();
        session = this.createSession((ClientSessionFactory)this.sf);
        ClientConsumer cc = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage cm = cc.receive(5000L);
        Assert.assertNotNull((Object)cm);
        Assert.assertEquals((Object)"message0", (Object)cm.getBodyBuffer().readString());
    }

    @Test(timeout=120000L)
    public void testLiveAndBackupBackupComesBackNewFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.backupServer.stop();
        this.liveServer.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        if (!this.backupServer.getServer().getHAPolicy().isSharedStore()) {
            this.backupServer.getServer().setHAPolicy((HAPolicy)new SharedStoreMasterPolicy());
        }
        this.backupServer.start();
        Assert.assertTrue((String)"session failure listener", (boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.close();
        this.sf.close();
        this.createClientSessionFactory();
        session = this.createSession((ClientSessionFactory)this.sf);
        ClientConsumer cc = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage cm = cc.receive(5000L);
        Assert.assertNotNull((Object)cm);
        Assert.assertEquals((Object)"message0", (Object)cm.getBodyBuffer().readString());
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    protected void beforeRestart(TestableServer liveServer1) {
    }

    protected void decrementActivationSequenceForForceRestartOf(TestableServer liveServer) throws Exception {
    }

    protected ClientSession sendAndConsume(ClientSessionFactory sf1, boolean createQueue) throws Exception {
        ClientSession session = this.createSession(sf1, false, true, true);
        if (createQueue) {
            session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive();
            Assert.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assert.assertEquals((Object)i, (Object)message2.getObjectProperty(new SimpleString("count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        Assert.assertNull((Object)message3);
        return session;
    }
}

