/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManualReconnectionToSingleServerTest
extends ActiveMQTestBase {
    public static final String BROKER_URL = "tcp://localhost:61616?minLargeMessageSize=10000&HA=true&retryInterval=100&reconnectAttempts=20&producerWindowSize=10000";
    private Connection connection;
    private MessageConsumer consumer;
    private CountDownLatch exceptionLatch;
    private CountDownLatch reconnectionLatch;
    private CountDownLatch allMessagesReceived;
    private static final String QUEUE_NAME = ManualReconnectionToSingleServerTest.class.getSimpleName() + ".queue";
    private static final int NUM = 20;
    private final ExceptionListener exceptionListener = new ExceptionListener(){

        public void onException(JMSException e) {
            ManualReconnectionToSingleServerTest.this.exceptionLatch.countDown();
            ManualReconnectionToSingleServerTest.this.disconnect();
            ManualReconnectionToSingleServerTest.this.connect();
            ManualReconnectionToSingleServerTest.this.reconnectionLatch.countDown();
        }
    };
    private Listener listener;
    private ActiveMQServer server;

    @Test
    public void testExceptionListener() throws Exception {
        this.connect();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(BROKER_URL);
        Queue dest = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        Connection conn = cf.createConnection();
        Session sess = conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer((Destination)dest);
        for (int i = 0; i < 20; ++i) {
            TextMessage message = sess.createTextMessage(new Date().toString());
            message.setIntProperty("counter", i + 1);
            prod.send((Message)message);
            if (i != 10) continue;
            conn.close();
            this.server.stop();
            this.server.start();
            cf = new ActiveMQConnectionFactory(BROKER_URL);
            dest = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
            conn = cf.createConnection();
            sess = conn.createSession(false, 1);
            prod = sess.createProducer((Destination)dest);
        }
        conn.close();
        boolean gotException = this.exceptionLatch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)gotException);
        boolean clientReconnected = this.reconnectionLatch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"client did not reconnect after server was restarted", (boolean)clientReconnected);
        boolean gotAllMessages = this.allMessagesReceived.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)gotAllMessages);
        this.connection.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.getQueueConfigs().add(new QueueConfiguration(QUEUE_NAME));
        ArrayList<TransportConfiguration> configs = new ArrayList<TransportConfiguration>();
        configs.add(new TransportConfiguration(NETTY_CONNECTOR_FACTORY));
        this.server.start();
        this.listener = new Listener();
        this.exceptionLatch = new CountDownLatch(1);
        this.reconnectionLatch = new CountDownLatch(1);
        this.allMessagesReceived = new CountDownLatch(1);
    }

    protected void disconnect() {
        this.instanceLog.debug((Object)"calling disconnect");
        if (this.connection == null) {
            this.instanceLog.debug((Object)"connection is null");
            return;
        }
        try {
            this.connection.setExceptionListener(null);
            this.instanceLog.debug((Object)"closing the connection");
            this.connection.close();
            this.connection = null;
            this.instanceLog.debug((Object)"connection closed");
        }
        catch (Exception e) {
            this.instanceLog.debug((Object)"** got exception");
            e.printStackTrace();
        }
    }

    protected void connect() {
        block8: {
            int retries = 0;
            int retryLimit = 1000;
            try {
                ActiveMQConnectionFactory cf;
                while (true) {
                    try {
                        cf = new ActiveMQConnectionFactory(BROKER_URL);
                    }
                    catch (Exception e) {
                        if (retries++ > 1000) {
                            throw e;
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
                this.connection = cf.createConnection();
                this.connection.setExceptionListener(this.exceptionListener);
                Session session = this.connection.createSession(false, 1);
                Queue queue = session.createQueue(QUEUE_NAME);
                this.consumer = session.createConsumer((Destination)queue);
                this.consumer.setMessageListener((MessageListener)this.listener);
                this.connection.start();
            }
            catch (Exception e) {
                if (this.connection == null) break block8;
                try {
                    this.connection.close();
                }
                catch (JMSException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private class Listener
    implements MessageListener {
        private int count = 0;

        private Listener() {
        }

        public void onMessage(Message msg) {
            ++this.count;
            try {
                msg.getIntProperty("counter");
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            if (this.count == 20) {
                ManualReconnectionToSingleServerTest.this.allMessagesReceived.countDown();
            }
        }
    }
}

