/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.DayCounterInfo;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.integration.jms.server.management.JMSUtil;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QueueControlTest
extends ManagementTestBase {
    private static final String NULL_DATE = DateFormat.getDateTimeInstance(3, 2).format(new Date(0L));
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    private ActiveMQServer server;
    private ClientSession session;
    private ServerLocator locator;
    private final boolean durable;

    @Parameterized.Parameters(name="durable={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public QueueControlTest(boolean durable) {
        this.durable = durable;
    }

    @Test
    public void testGetPreparedTransactionMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)this.session.createMessage(true));
        }
        producer.close();
        ClientSession xaSession = this.locator.createSessionFactory().createXASession();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        XidImpl xid = this.newXID();
        xaSession.start((Xid)xid, 0);
        xaSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage receive = consumer.receive();
            receive.acknowledge();
        }
        xaSession.end((Xid)xid, 0x4000000);
        xaSession.prepare((Xid)xid);
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assert.assertEquals((long)10L, (long)count);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetPreparedTransactionMessageCountDifferentQueues() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString address2 = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString queue2 = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(queue2).setAddress(address2).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientProducer producer2 = this.session.createProducer(address2);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)this.session.createMessage(true));
            producer2.send((Message)this.session.createMessage(true));
        }
        producer.close();
        producer2.close();
        ClientSession xaSession = this.locator.createSessionFactory().createXASession();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        ClientConsumer consumer2 = xaSession.createConsumer(queue2);
        XidImpl xid = this.newXID();
        xaSession.start((Xid)xid, 0);
        xaSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage receive = consumer.receive();
            receive.acknowledge();
            receive = consumer2.receive();
            receive.acknowledge();
        }
        xaSession.end((Xid)xid, 0x4000000);
        xaSession.prepare((Xid)xid);
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assert.assertEquals((long)10L, (long)count);
        consumer.close();
        consumer2.close();
        this.session.deleteQueue(queue);
        this.session.deleteQueue(queue2);
    }

    @Test
    public void testGetPreparedTransactionMessageCountNoTX() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assert.assertEquals((long)0L, (long)count);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testAttributes() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString filter = new SimpleString("color = 'blue'");
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setFilterString(filter).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((Object)queue.toString(), (Object)queueControl.getName());
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)filter.toString(), (Object)queueControl.getFilter());
        Assert.assertEquals((Object)this.durable, (Object)queueControl.isDurable());
        Assert.assertFalse((boolean)queueControl.isTemporary());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGroupAttributes() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(address, RoutingType.MULTICAST, queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertFalse((boolean)queueControl.isGroupRebalance());
        Assert.assertEquals((long)-1L, (long)queueControl.getGroupBuckets());
        Assert.assertEquals(null, (Object)queueControl.getGroupFirstKey());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRetroactiveResourceAttribute() throws Exception {
        SimpleString baseAddress = RandomUtil.randomSimpleString();
        String internalNamingPrefix = this.server.getInternalNamingPrefix();
        String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
        SimpleString address = ResourceNames.getRetroactiveResourceAddressName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress);
        SimpleString multicastQueue = ResourceNames.getRetroactiveResourceQueueName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress, (RoutingType)RoutingType.MULTICAST);
        SimpleString anycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress, (RoutingType)RoutingType.ANYCAST);
        this.session.createQueue(new QueueConfiguration(multicastQueue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(anycastQueue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, multicastQueue);
        Assert.assertTrue((boolean)queueControl.isRetroactiveResource());
        queueControl = this.createManagementControl(address, anycastQueue);
        Assert.assertTrue((boolean)queueControl.isRetroactiveResource());
        this.session.deleteQueue(multicastQueue);
        this.session.deleteQueue(anycastQueue);
    }

    @Test
    public void testGetNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((Object)queue.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        final SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertNull((Object)queueControl.getDeadLetterAddress());
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings(){
            private static final long serialVersionUID = -4919035864731465338L;

            public SimpleString getDeadLetterAddress() {
                return deadLetterAddress;
            }
        });
        Assert.assertEquals((Object)deadLetterAddress.toString(), (Object)queueControl.getDeadLetterAddress());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testSetDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        String deadLetterAddress = RandomUtil.randomString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(new SimpleString(deadLetterAddress));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assert.assertEquals((Object)deadLetterAddress, (Object)queueControl.getDeadLetterAddress());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        final SimpleString expiryAddress = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertNull((Object)queueControl.getExpiryAddress());
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings(){
            private static final long serialVersionUID = 6745306517827764680L;

            public SimpleString getExpiryAddress() {
                return expiryAddress;
            }
        });
        Assert.assertEquals((Object)expiryAddress.toString(), (Object)queueControl.getExpiryAddress());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testSetExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        String expiryAddress = RandomUtil.randomString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(new SimpleString(expiryAddress));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assert.assertEquals((Object)expiryAddress, (Object)queueControl.getExpiryAddress());
        Queue serverqueue = this.server.locateQueue(queue);
        QueueControlTest.assertEquals((Object)expiryAddress, (Object)serverqueue.getExpiryAddress().toString());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetConsumerCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getConsumerCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        Wait.assertEquals((int)1, () -> queueControl.getConsumerCount());
        consumer.close();
        Wait.assertEquals((int)0, () -> queueControl.getConsumerCount());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetConsumerJSON() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((int)0, () -> queueControl.getConsumerCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        Wait.assertEquals((int)1, () -> queueControl.getConsumerCount());
        JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        QueueControlTest.assertEquals((long)1L, (long)obj.size());
        consumer.close();
        Assert.assertEquals((long)0L, (long)queueControl.getConsumerCount());
        obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        QueueControlTest.assertEquals((long)0L, (long)obj.size());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetFirstMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        QueueControlTest.assertEquals((Object)"[{}]", (Object)queueControl.getFirstMessageAsJSON());
        long beforeSend = System.currentTimeMillis();
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(false).putStringProperty("x", "valueX").putStringProperty("y", "valueY"));
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
        long firstMessageTimestamp = queueControl.getFirstMessageTimestamp();
        QueueControlTest.assertTrue((beforeSend <= firstMessageTimestamp ? (byte)1 : 0) != 0);
        QueueControlTest.assertTrue((firstMessageTimestamp <= System.currentTimeMillis() ? (byte)1 : 0) != 0);
        long firstMessageAge = queueControl.getFirstMessageAge();
        QueueControlTest.assertTrue((firstMessageAge <= System.currentTimeMillis() - firstMessageTimestamp ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageAttributeLimits() throws Exception {
        CompositeData[] browseResult;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementMessageAttributeSizeLimit(100);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        byte[] twoKBytes = new byte[2048];
        for (int i = 0; i < 2048; ++i) {
            twoKBytes[i] = 42;
        }
        String twoKString = new String(twoKBytes);
        ClientMessage clientMessage = this.session.createMessage(false);
        clientMessage.putStringProperty("y", "valueY");
        clientMessage.putStringProperty("bigString", twoKString);
        clientMessage.putBytesProperty("bigBytes", twoKBytes);
        clientMessage.putObjectProperty("bigObject", (Object)twoKString);
        clientMessage.getBodyBuffer().writeBytes(twoKBytes);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)clientMessage);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        QueueControlTest.assertTrue((this.server.getPagingManager().getPageStore(address).getAddressSize() > 2048L ? (byte)1 : 0) != 0);
        Map[] messages = queueControl.listMessages("");
        QueueControlTest.assertEquals((long)1L, (long)messages.length);
        for (String key : messages[0].keySet()) {
            Object value = messages[0].get(key);
            System.err.println(key + " " + value);
            QueueControlTest.assertTrue((value.toString().length() <= 150 ? (byte)1 : 0) != 0);
            if (!(value instanceof byte[])) continue;
            QueueControlTest.assertTrue((((byte[])value).length <= 150 ? (byte)1 : 0) != 0);
        }
        String all = queueControl.listMessagesAsJSON("");
        QueueControlTest.assertTrue((all.length() < 1024 ? (byte)1 : 0) != 0);
        String first = queueControl.getFirstMessageAsJSON();
        QueueControlTest.assertTrue((first.length() < 1024 ? (byte)1 : 0) != 0);
        for (CompositeData compositeData : browseResult = queueControl.browse(1, 100)) {
            for (String key : compositeData.getCompositeType().keySet()) {
                Object value = compositeData.get(key);
                System.err.println("" + key + ", " + value);
                if (value == null) continue;
                if (key.equals("StringProperties")) {
                    QueueControlTest.assertTrue((String)(value.toString().length() + " truncated? " + key), (value.toString().length() <= 2048 ? (byte)1 : 0) != 0);
                } else {
                    QueueControlTest.assertTrue((String)(value.toString().length() + " truncated? " + key), (value.toString().length() <= 512 ? (byte)1 : 0) != 0);
                }
                if (!(value instanceof byte[])) continue;
                QueueControlTest.assertTrue((String)("truncated? " + key), (((byte[])value).length <= 150 ? (byte)1 : 0) != 0);
            }
        }
        this.session.deleteQueue(queue);
    }

    @Test
    public void testTextMessageAttributeLimits() throws Exception {
        CompositeData[] browseResult;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementMessageAttributeSizeLimit(10);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        String twentyBytes = new String(new char[20]).replace("\u0000", "#");
        ClientMessage clientMessage = this.session.createMessage((byte)3, this.durable);
        clientMessage.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString((String)twentyBytes));
        clientMessage.putStringProperty("x", twentyBytes);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)clientMessage);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages("");
        QueueControlTest.assertEquals((long)1L, (long)messages.length);
        QueueControlTest.assertTrue((String)"truncated? ", (boolean)((String)messages[0].get("x")).contains("more"));
        for (CompositeData compositeData : browseResult = queueControl.browse(1, 100)) {
            for (String key : new String[]{"text", "PropertiesText", "StringProperties"}) {
                QueueControlTest.assertTrue((String)("truncated? : " + key), (boolean)compositeData.get(key).toString().contains("more"));
            }
        }
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetMessagesAdded() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessagesAdded(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)1L, () -> this.getMessagesAdded(queueControl));
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        QueueControlTest.consumeMessages(2, this.session, queue);
        Assert.assertEquals((long)2L, (long)this.getMessagesAdded(queueControl));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetMessagesAcknowledged() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(false));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Wait.assertEquals((long)1L, () -> queueControl.getMessagesAcknowledged());
        producer.send((Message)this.session.createMessage(false));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Wait.assertEquals((long)2L, () -> queueControl.getMessagesAcknowledged());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetMessagesAcknowledgedOnXARollback() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        ClientSessionFactory xaFactory = this.createSessionFactory(this.locator);
        ClientSession xaSession = this.addClientSession(xaFactory.createSession(true, false, false));
        xaSession.start();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        int tries = 10;
        for (int i = 0; i < tries; ++i) {
            XidImpl xid = this.newXID();
            xaSession.start((Xid)xid, 0);
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            xaSession.end((Xid)xid, 0x4000000);
            Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            xaSession.prepare((Xid)xid);
            Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            if (i + 1 == tries) {
                xaSession.commit((Xid)xid, false);
                continue;
            }
            xaSession.rollback((Xid)xid);
        }
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessagesAcknowledged());
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getAcknowledgeAttempts());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetMessagesAcknowledgedOnRegularRollback() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        ClientSessionFactory xaFactory = this.createSessionFactory(this.locator);
        ClientSession txSession = this.addClientSession(xaFactory.createSession(false, false, false));
        txSession.start();
        ClientConsumer consumer = txSession.createConsumer(queue);
        int tries = 10;
        for (int i = 0; i < tries; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            if (i + 1 == tries) {
                txSession.commit();
                continue;
            }
            txSession.rollback();
        }
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessagesAcknowledged());
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getAcknowledgeAttempts());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetScheduledCount() throws Exception {
        long delay = 500L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        producer.send((Message)message);
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && queueControl.getScheduledCount() != 1L) {
            Thread.sleep(100L);
        }
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(0, this.session, queue);
        Thread.sleep(delay * 2L);
        Assert.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.assertScheduledMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListDeliveringMessagesWithRASession() throws Exception {
        ServerLocator locator1 = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setConsumerWindowSize(10240).setAckBatchSize(0);
        ClientSessionFactory sf = locator1.createSessionFactory();
        ClientSession transSession = sf.createSession(false, true, false);
        ClientConsumer consumer = null;
        SimpleString queue = null;
        int numMsg = 10;
        try {
            transSession.addMetaData("resource-adapter", "inbound");
            transSession.addMetaData("jms-session", "");
            SimpleString address = RandomUtil.randomSimpleString();
            queue = RandomUtil.randomSimpleString();
            transSession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            QueueControl queueControl = this.createManagementControl(address, queue);
            ClientProducer producer = transSession.createProducer(address);
            for (int i = 0; i < numMsg; ++i) {
                ClientMessage message = transSession.createMessage(this.durable);
                message.putIntProperty(new SimpleString("seqno"), i);
                producer.send((Message)message);
            }
            consumer = transSession.createConsumer(queue);
            transSession.start();
            final CountDownLatch latch1 = new CountDownLatch(1);
            final CountDownLatch latch2 = new CountDownLatch(1);
            final CountDownLatch latch3 = new CountDownLatch(10);
            consumer.setMessageHandler(new MessageHandler(){

                public void onMessage(ClientMessage message) {
                    try {
                        message.acknowledge();
                    }
                    catch (ActiveMQException e1) {
                        e1.printStackTrace();
                    }
                    latch1.countDown();
                    try {
                        latch2.await(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    latch3.countDown();
                }
            });
            latch1.await(10L, TimeUnit.SECONDS);
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(1000L);
                String jsonStr = queueControl.listDeliveringMessagesAsJSON();
                n = QueueControlTest.countOccurrencesOf((String)jsonStr, (String)"seqno");
                if (n == numMsg) break;
            }
            QueueControlTest.assertEquals((long)numMsg, (long)n);
            latch2.countDown();
            latch3.await(10L, TimeUnit.SECONDS);
            transSession.commit();
        }
        catch (Throwable throwable) {
            consumer.close();
            transSession.deleteQueue(queue);
            transSession.close();
            locator1.close();
            throw throwable;
        }
        consumer.close();
        transSession.deleteQueue(queue);
        transSession.close();
        locator1.close();
    }

    @Test
    public void testListDeliveringMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        Queue srvqueue = this.server.locateQueue(queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(new SimpleString("key"), intValue);
        producer.send((Message)message);
        producer.send((Message)this.session.createMessage(this.durable));
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage msgRec = consumer.receive(5000L);
        QueueControlTest.assertNotNull((Object)msgRec);
        QueueControlTest.assertEquals((long)msgRec.getIntProperty("key").intValue(), (long)intValue);
        ClientSessionFactory sf2 = this.createSessionFactory(this.locator);
        ClientSession session2 = sf2.createSession(false, true, false);
        ClientConsumer consumer2 = session2.createConsumer(queue);
        session2.start();
        ClientMessage msgRec2 = consumer2.receive(5000L);
        QueueControlTest.assertNotNull((Object)msgRec2);
        QueueControlTest.assertEquals((long)2L, (long)srvqueue.getDeliveringCount());
        QueueControlTest.assertEquals((long)2L, (long)srvqueue.getConsumerCount());
        Map deliveringMap = queueControl.listDeliveringMessages();
        QueueControlTest.assertEquals((long)2L, (long)deliveringMap.size());
        consumer.close();
        consumer2.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListDeliveringMessagesOnClosedConsumer() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        Queue srvqueue = this.server.locateQueue(queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(new SimpleString("key"), intValue);
        producer.send((Message)message);
        producer.send((Message)this.session.createMessage(this.durable));
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage msgRec = consumer.receive(5000L);
        QueueControlTest.assertNotNull((Object)msgRec);
        QueueControlTest.assertEquals((long)msgRec.getIntProperty("key").intValue(), (long)intValue);
        QueueControlTest.assertEquals((long)1L, (long)srvqueue.getDeliveringCount());
        QueueControlTest.assertEquals((long)1L, (long)queueControl.listDeliveringMessages().size());
        msgRec.acknowledge();
        consumer.close();
        QueueControlTest.assertEquals((long)1L, (long)srvqueue.getDeliveringCount());
        Map deliveringMap = queueControl.listDeliveringMessages();
        QueueControlTest.assertEquals((long)1L, (long)deliveringMap.size());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListScheduledMessages() throws Exception {
        long delay = 2000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        message.putIntProperty(new SimpleString("key"), intValue);
        producer.send((Message)message);
        producer.send((Message)this.session.createMessage(this.durable));
        Map[] messages = queueControl.listScheduledMessages();
        Assert.assertEquals((long)1L, (long)messages.length);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        Assert.assertEquals((long)intValue, (long)Integer.parseInt(messages[0].get("key").toString()));
        Thread.sleep(delay + 500L);
        messages = queueControl.listScheduledMessages();
        Assert.assertEquals((long)0L, (long)messages.length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListScheduledMessagesAsJSON() throws Exception {
        long delay = 2000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        message.putIntProperty(new SimpleString("key"), intValue);
        producer.send((Message)message);
        producer.send((Message)this.session.createMessage(this.durable));
        String jsonString = queueControl.listScheduledMessagesAsJSON();
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        int i = Integer.parseInt(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assert.assertEquals((long)intValue, (long)i);
        Thread.sleep(delay + 500L);
        jsonString = queueControl.listScheduledMessagesAsJSON();
        Assert.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)0L, (long)array.size());
        QueueControlTest.consumeMessages(2, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetDeliveringCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getDeliveringCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        this.assertDeliveringMetrics(queueControl, 1L, this.durable);
        message.acknowledge();
        this.session.commit();
        this.assertDeliveringMetrics(queueControl, 0L, this.durable);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessagesAddedAndMessagesAcknowledged() throws Exception {
        int THREAD_COUNT = 5;
        int MSG_COUNT = 1000;
        CountDownLatch producerCountDown = new CountDownLatch(5);
        CountDownLatch consumerCountDown = new CountDownLatch(5);
        ExecutorService producerExecutor = Executors.newFixedThreadPool(5);
        ExecutorService consumerExecutor = Executors.newFixedThreadPool(5);
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        try {
            int i;
            this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            for (i = 0; i < 5; ++i) {
                producerExecutor.submit(() -> {
                    try (ClientSessionFactory sf = this.locator.createSessionFactory();
                         ClientSession session = sf.createSession(false, true, false);
                         ClientProducer producer = session.createProducer(address);){
                        for (int j = 0; j < 1000; ++j) {
                            producer.send((Message)session.createMessage(false));
                            Thread.sleep(5L);
                        }
                        producerCountDown.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            for (i = 0; i < 5; ++i) {
                consumerExecutor.submit(() -> {
                    try (ClientSessionFactory sf = this.locator.createSessionFactory();
                         ClientSession session = sf.createSession(false, true, false);
                         ClientConsumer consumer = session.createConsumer(queue);){
                        session.start();
                        for (int j = 0; j < 1000; ++j) {
                            ClientMessage message = consumer.receive(500L);
                            Assert.assertNotNull((Object)message);
                            message.acknowledge();
                        }
                        session.commit();
                        consumerCountDown.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            producerCountDown.await(30L, TimeUnit.SECONDS);
            consumerCountDown.await(30L, TimeUnit.SECONDS);
            QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.MULTICAST);
            Thread.sleep(200L);
            Assert.assertEquals((long)0L, (long)queueControl.getMessageCount());
            Assert.assertEquals((long)0L, (long)queueControl.getConsumerCount());
            Assert.assertEquals((long)0L, (long)queueControl.getDeliveringCount());
            Assert.assertEquals((long)5000L, (long)queueControl.getMessagesAdded());
            Assert.assertEquals((long)5000L, (long)queueControl.getMessagesAcknowledged());
            this.session.deleteQueue(queue);
        }
        finally {
            this.shutdownExecutor(producerExecutor);
            this.shutdownExecutor(consumerExecutor);
        }
    }

    private void shutdownExecutor(ExecutorService executor) {
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testListMessagesAsJSONWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(new SimpleString("key"), intValue);
        producer.send((Message)message);
        String jsonString = queueControl.listMessagesAsJSON(null);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        long l = Long.parseLong(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assert.assertEquals((long)intValue, (long)l);
        QueueControlTest.consumeMessages(1, this.session, queue);
        jsonString = queueControl.listMessagesAsJSON(null);
        Assert.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)0L, (long)array.size());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessagesWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        String filter = key + " =" + matchingValue;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(filter);
        Assert.assertEquals((long)1L, (long)messages.length);
        Assert.assertEquals((long)matchingValue, (long)Long.parseLong(messages[0].get("key").toString()));
        QueueControlTest.consumeMessages(2, this.session, queue);
        messages = queueControl.listMessages(filter);
        Assert.assertEquals((long)0L, (long)messages.length);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessagesWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable).putBytesProperty("bytes", new byte[]{37}));
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((int)2, () -> queueControl.listMessages(null).length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((int)0, () -> queueControl.listMessages(null).length);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessagesWithEmptyFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((int)2, () -> queueControl.listMessages("").length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((int)0, () -> queueControl.listMessages("").length);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessagesAsJSONWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        String filter = key + " =" + matchingValue;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        String jsonString = queueControl.listMessagesAsJSON(filter);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        long l = Long.parseLong(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assert.assertEquals((long)matchingValue, (long)l);
        QueueControlTest.consumeMessages(2, this.session, queue);
        jsonString = queueControl.listMessagesAsJSON(filter);
        Assert.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)0L, (long)array.size());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRetryMessage() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        SimpleString dlq = new SimpleString("DLQ1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        long messageID = this.getFirstMessageId(queueControl);
        Assert.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Test
    public void testRetryMessageWithAutoCreatedResources() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        Assert.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Test
    public void testRetryMessageWithoutDLQ() throws Exception {
        SimpleString qName = new SimpleString("q1");
        SimpleString qName2 = new SimpleString("q2");
        SimpleString adName = new SimpleString("ad1");
        SimpleString adName2 = new SimpleString("ad2");
        String sampleText = "Put me on DLQ";
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(qName2).setAddress(adName2).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        ClientMessage m = this.createTextMessage(this.session, "Put me on DLQ");
        m.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, adName2);
        m.putStringProperty(Message.HDR_ORIGINAL_QUEUE, qName2);
        producer.send((Message)m);
        this.session.start();
        QueueControl queueControl = this.createManagementControl(adName, qName);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        QueueControl queueControl2 = this.createManagementControl(adName2, qName2);
        this.assertMessageMetrics(queueControl2, 0L, this.durable);
        queueControl.retryMessages();
        Wait.assertTrue(() -> this.getMessageCount(queueControl) == 1L, (long)2000L, (long)100L);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Wait.assertTrue(() -> this.getMessageCount(queueControl2) == 1L, (long)2000L, (long)100L);
        this.assertMessageMetrics(queueControl2, 1L, this.durable);
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer = this.session.createConsumer(qName2);
        clientMessage = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Test
    public void testRetryDivertedMessage() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString dlq = new SimpleString("DLQ");
        SimpleString forwardingQueue = new SimpleString("forwardingQueue");
        SimpleString forwardingAddress = new SimpleString("forwardingAddress");
        SimpleString myTopic = new SimpleString("myTopic");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(forwardingAddress.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(forwardingQueue).setAddress(forwardingAddress).setDurable(Boolean.valueOf(this.durable)));
        this.session.createAddress(myTopic, RoutingType.MULTICAST, false);
        DivertConfiguration divert = new DivertConfiguration().setName("local-divert").setRoutingName("some-name").setAddress(myTopic.toString()).setForwardingAddress(forwardingAddress.toString()).setExclusive(false);
        this.server.deployDivert(divert);
        ClientProducer producer = this.session.createProducer(myTopic);
        producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(forwardingQueue);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq, RoutingType.MULTICAST);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        long messageID = this.getFirstMessageId(queueControl);
        Assert.assertTrue((boolean)queueControl.retryMessage(messageID));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Test
    public void testRetryMultipleMessages() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        SimpleString dlq = new SimpleString("DLQ1");
        String sampleText = "Put me on DLQ";
        int numMessagesToTest = 10;
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        }
        this.session.start();
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(qName);
        Queue q = binding.getQueue();
        LocalQueueBinding binding2 = (LocalQueueBinding)this.server.getPostOffice().getBinding(dlq);
        Queue q2 = binding2.getQueue();
        Field queueMemorySizeField = QueueImpl.class.getDeclaredField("queueMemorySize");
        queueMemorySizeField.setAccessible(true);
        AtomicInteger queueMemorySize1 = (AtomicInteger)queueMemorySizeField.get(q);
        AtomicInteger queueMemorySize2 = (AtomicInteger)queueMemorySizeField.get(q2);
        QueueControlTest.assertTrue((queueMemorySize1.get() > 0 ? (byte)1 : 0) != 0);
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize2.get());
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        for (int i = 0; i < 10; ++i) {
            ClientMessage clientMessage = clientConsumer.receive(500L);
            clientMessage.acknowledge();
            Assert.assertNotNull((Object)clientMessage);
            Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
            this.session.rollback();
        }
        Assert.assertNull((Object)clientConsumer.receiveImmediate());
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize1.get());
        QueueControlTest.assertTrue((queueMemorySize2.get() > 0 ? (byte)1 : 0) != 0);
        QueueControl dlqQueueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(dlqQueueControl, 10L, this.durable);
        Assert.assertEquals((long)10L, (long)dlqQueueControl.retryMessages());
        this.assertMessageMetrics(dlqQueueControl, 0L, this.durable);
        QueueControlTest.assertTrue((queueMemorySize1.get() > 0 ? (byte)1 : 0) != 0);
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize2.get());
        for (int i = 0; i < 10; ++i) {
            ClientMessage clientMessage = clientConsumer.receive(500L);
            clientMessage.acknowledge();
            Assert.assertNotNull((Object)clientMessage);
            Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        }
        clientConsumer.close();
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize1.get());
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize2.get());
    }

    @Test
    public void testMoveMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        message.putLongProperty(key, value);
        producer.send((Message)message);
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        Queue q = binding.getQueue();
        Field queueMemorySizeField = QueueImpl.class.getDeclaredField("queueMemorySize");
        queueMemorySizeField.setAccessible(true);
        AtomicInteger queueMemorySize = (AtomicInteger)queueMemorySizeField.get(q);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Assert.assertTrue((queueMemorySize.get() > 0 ? (byte)1 : 0) != 0);
        int movedMessagesCount = queueControl.moveMessages(null, otherQueue.toString());
        Assert.assertEquals((long)1L, (long)movedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        Assert.assertEquals((long)0L, (long)queueMemorySize.get());
        QueueControlTest.consumeMessages(0, this.session, queue);
        ClientConsumer otherConsumer = this.session.createConsumer(otherQueue);
        ClientMessage m = otherConsumer.receive(500L);
        Assert.assertEquals((Object)value, (Object)m.getObjectProperty(key));
        m.acknowledge();
        this.session.deleteQueue(queue);
        otherConsumer.close();
        this.session.deleteQueue(otherQueue);
    }

    @Test
    public void testMoveMessages2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queueA = new SimpleString("A");
        SimpleString queueB = new SimpleString("B");
        SimpleString queueC = new SimpleString("C");
        this.server.createQueue(new QueueConfiguration(queueA).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(new QueueConfiguration(queueB).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(new QueueConfiguration(queueC).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControlA = this.createManagementControl(address, queueA);
        QueueControl queueControlB = this.createManagementControl(address, queueB);
        QueueControl queueControlC = this.createManagementControl(address, queueC);
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody2".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlB));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlC));
        queueControlA.moveMessages(null, queueB.toString());
        Thread.sleep(500L);
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlB));
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody3".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControlA));
        queueControlA.moveMessages(null, queueC.toString());
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControlC));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlA));
        queueControlB.moveMessages(null, queueA.toString());
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlB));
        queueControlC.moveMessages(null, queueA.toString());
        Wait.assertEquals((long)3L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlC));
        ClientConsumer consumer = this.session.createConsumer(queueA);
        ClientMessage m1 = consumer.receive(500L);
        ClientMessage m2 = consumer.receive(500L);
        ClientMessage m3 = consumer.receive(500L);
        m1.acknowledge();
        m2.acknowledge();
        m3.acknowledge();
        consumer.close();
        this.session.deleteQueue(queueA);
        this.session.deleteQueue(queueB);
        this.session.deleteQueue(queueC);
    }

    @Test
    public void testMoveMessagesToUnknownQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString unknownQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        message.putLongProperty(key, value);
        producer.send((Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        try {
            queueControl.moveMessages(null, unknownQueue.toString());
            Assert.fail((String)"operation must fail if the other queue does not exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMoveMessagesWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int movedMatchedMessagesCount = queueControl.moveMessages(key + " =" + matchingValue, otherQueue.toString());
        Assert.assertEquals((long)1L, (long)movedMatchedMessagesCount);
        Assert.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        ClientConsumer otherConsumer = this.session.createConsumer(otherQueue);
        m = otherConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)matchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
        otherConsumer.close();
        this.session.deleteQueue(otherQueue);
    }

    @Test
    public void testMoveMessagesWithMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = this.session.createMessage(this.durable);
            SimpleString key = RandomUtil.randomSimpleString();
            long value = RandomUtil.randomLong();
            message.putLongProperty(key, value);
            producer.send((Message)message);
        }
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        Assert.assertEquals((long)10L, (long)binding.getQueue().getMessageCount());
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)10L, (long)queueControl.getMessageCount());
        int movedMessagesCount = queueControl.moveMessages(500, null, otherQueue.toString(), false, 5);
        Assert.assertEquals((long)5L, (long)movedMessagesCount);
        Assert.assertEquals((long)5L, (long)queueControl.getMessageCount());
        QueueControlTest.consumeMessages(5, this.session, queue);
        QueueControlTest.consumeMessages(5, this.session, otherQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue);
    }

    @Test
    public void testMoveMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl otherQueueControl = this.createManagementControl(otherAddress, otherQueue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        this.assertMessageMetrics(otherQueueControl, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean moved = queueControl.moveMessage(messageID, otherQueue.toString());
        Assert.assertTrue((boolean)moved);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(otherQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, otherQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue);
    }

    @Test
    public void testMoveMessageToFQQN() throws Exception {
        SimpleString address = new SimpleString("ErrorQueue");
        SimpleString queue = new SimpleString("ErrorQueue");
        SimpleString otherAddress = new SimpleString("parent.addr.1");
        SimpleString otherQueue1 = new SimpleString("child.queue.1");
        SimpleString otherQueue2 = new SimpleString("child.queue.2");
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue1).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(otherQueue2).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.ANYCAST);
        QueueControl otherQueue1Control = this.createManagementControl(otherAddress, otherQueue1);
        QueueControl otherQueue2Control = this.createManagementControl(otherAddress, otherQueue2);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        this.assertMessageMetrics(otherQueue1Control, 0L, this.durable);
        this.assertMessageMetrics(otherQueue2Control, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean moved = queueControl.moveMessage(messageID, otherQueue1.toString());
        Assert.assertTrue((boolean)moved);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(otherQueue1Control, 1L, this.durable);
        this.assertMessageMetrics(otherQueue2Control, 0L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, otherQueue1);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue1);
        this.session.deleteQueue(otherQueue2);
    }

    @Test
    public void testMoveMessageToUnknownQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString unknownQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        try {
            queueControl.moveMessage(messageID, unknownQueue.toString());
            Assert.fail((String)"operation must fail if the other queue does not exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCopiedMessageProperties() throws Exception {
        String testAddress = "testAddress";
        SimpleString queue = SimpleString.toSimpleString((String)"queue");
        int COUNT = 5;
        for (int i = 0; i < 5; ++i) {
            this.server.createQueue(new QueueConfiguration(queue.concat(Integer.toString(i))).setAddress("testAddress" + i).setRoutingType(RoutingType.ANYCAST));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress0"));
        ClientMessage message = session.createMessage(this.durable);
        producer.send((Message)message);
        producer.close();
        for (int i = 0; i < 4; ++i) {
            QueueControl queueControl = this.createManagementControl(SimpleString.toSimpleString((String)("testAddress" + i)), queue.concat(Integer.toString(i)), RoutingType.ANYCAST);
            QueueControl otherQueueControl = this.createManagementControl(SimpleString.toSimpleString((String)("testAddress" + (i + 1))), queue.concat(Integer.toString(i + 1)), RoutingType.ANYCAST);
            this.assertMessageMetrics(queueControl, 1L, this.durable);
            this.assertMessageMetrics(otherQueueControl, 0L, this.durable);
            int moved = queueControl.moveMessages(null, queue.concat(Integer.toString(i + 1)).toString());
            Assert.assertEquals((long)1L, (long)moved);
            this.assertMessageMetrics(queueControl, 0L, this.durable);
            this.assertMessageMetrics(otherQueueControl, 1L, this.durable);
        }
        ClientConsumer consumer1 = session.createConsumer(queue.concat(Integer.toString(4)));
        message = consumer1.receive(1000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        System.out.println(message);
        Assert.assertEquals((Object)"testAddress4", (Object)message.getAddress());
        Assert.assertEquals((Object)"testAddress3", (Object)message.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
    }

    @Test
    public void testRemoveMessages() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(key + " =" + matchingValue);
        Assert.assertEquals((long)1L, (long)removedMatchedMessagesCount);
        Assert.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assert.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveMessagesWithLimit() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(5, key + " =" + matchingValue);
        Assert.assertEquals((long)1L, (long)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assert.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveMessagesWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(null);
        Assert.assertEquals((long)2L, (long)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveAllMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeAllMessages();
        Assert.assertEquals((long)2L, (long)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveAllWithPagingMode() throws Exception {
        int MESSAGE_SIZE = 3072;
        Field maxSizField = PagingManagerImpl.class.getDeclaredField("maxSize");
        maxSizField.setAccessible(true);
        maxSizField.setLong(this.server.getPagingManager(), 10240L);
        this.clearDataRecreateServerDirs();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        Queue queue = this.server.locateQueue(queueName);
        Assert.assertFalse((boolean)queue.getPageSubscription().isPaging());
        ClientProducer producer = this.session.createProducer(address);
        byte[] body = new byte[3072];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 3072; ++j) {
            bb.put(QueueControlTest.getSamplebyte((long)j));
        }
        int numberOfMessages = 8000;
        for (int i = 0; i < 8000; ++i) {
            ClientMessage message = this.session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((Message)message);
        }
        Assert.assertTrue((boolean)queue.getPageSubscription().isPaging());
        QueueControl queueControl = this.createManagementControl(address, queueName);
        this.assertMessageMetrics(queueControl, 8000L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeAllMessages();
        Assert.assertEquals((long)8000L, (long)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        Field queueMemoprySizeField = QueueImpl.class.getDeclaredField("queueMemorySize");
        queueMemoprySizeField.setAccessible(true);
        AtomicInteger queueMemorySize = (AtomicInteger)queueMemoprySizeField.get(queue);
        Assert.assertEquals((long)0L, (long)queueMemorySize.get());
        this.session.deleteQueue(queueName);
    }

    @Test
    public void testRemoveMessagesWithEmptyFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages("");
        Assert.assertEquals((long)2L, (long)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assert.assertTrue((boolean)deleted);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveScheduledMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        long timeout = System.currentTimeMillis() + 5000L;
        ClientMessage m1 = this.session.createMessage(this.durable);
        m1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((Message)m1);
        ClientMessage m2 = this.session.createMessage(this.durable);
        m2.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((Message)m2);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)2L, (long)queueControl.getScheduledCount());
        Map[] messages = queueControl.listScheduledMessages();
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assert.assertTrue((boolean)deleted);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        while (timeout > System.currentTimeMillis() && queueControl.getScheduledCount() == 1L) {
            Thread.sleep(100L);
        }
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRemoveScheduledMessageRestart() throws Exception {
        Assume.assumeTrue((boolean)this.durable);
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        long timeout = System.currentTimeMillis() + 5000L;
        ClientMessage m1 = this.session.createMessage(this.durable);
        m1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((Message)m1);
        ClientMessage m2 = this.session.createMessage(this.durable);
        m2.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((Message)m2);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertScheduledMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listScheduledMessages();
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assert.assertTrue((boolean)deleted);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        this.locator.close();
        this.server.stop();
        this.server.start();
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
    }

    @Test
    public void testRemoveMessage2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.session.createMessage(this.durable);
            msg.putIntProperty("count", i);
            producer.send((Message)msg);
        }
        ClientConsumer cons = this.session.createConsumer(queue);
        this.session.start();
        LinkedList<ClientMessage> msgs = new LinkedList<ClientMessage>();
        for (int i = 0; i < 50; ++i) {
            ClientMessage msg = cons.receive(1000L);
            msgs.add(msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 100L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)50L, (long)messages.length);
        int i = Integer.parseInt(messages[0].get("count").toString());
        QueueControlTest.assertEquals((long)50L, (long)i);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assert.assertTrue((boolean)deleted);
        this.assertMessageMetrics(queueControl, 99L, this.durable);
        cons.close();
        QueueControlTest.consumeMessages(99, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountDeliveringMessageCountWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomPositiveLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)matchingMessage);
        producer.send((Message)unmatchingMessage);
        producer.send((Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(null));
        Assert.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(key + " =" + matchingValue));
        Assert.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(key + " =" + unmatchingValue));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((long)3L, (long)queueControl.countDeliveringMessages(null));
        Assert.assertEquals((long)2L, (long)queueControl.countDeliveringMessages(key + " =" + matchingValue));
        Assert.assertEquals((long)1L, (long)queueControl.countDeliveringMessages(key + " =" + unmatchingValue));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountDeliveringMessageCountNoFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)matchingMessage);
        producer.send((Message)unmatchingMessage);
        producer.send((Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(null));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((long)3L, (long)queueControl.countDeliveringMessages(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountDeliveringMessageCountNoGroupNoFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)matchingMessage);
        producer.send((Message)unmatchingMessage);
        producer.send((Message)matchingMessage);
        this.session.commit();
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(null, null);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)0L, (long)jsonObject.getInt("null"));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(null, null);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)3L, (long)jsonObject.getInt("null"));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountDeliveringMessageCountGroupNoFilter() throws Exception {
        String key = new String("key_group");
        String valueGroup1 = "group_1";
        String valueGroup2 = "group_2";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message1 = this.session.createMessage(false);
        message1.putStringProperty(key, valueGroup1);
        ClientMessage message2 = this.session.createMessage(false);
        message2.putStringProperty(key, valueGroup2);
        producer.send((Message)message1);
        producer.send((Message)message2);
        producer.send((Message)message1);
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(null, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertTrue((boolean)jsonObject.isEmpty());
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(null, key);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)2L, (long)jsonObject.getInt(valueGroup1));
        Assert.assertEquals((long)1L, (long)jsonObject.getInt(valueGroup2));
        Assert.assertFalse((boolean)jsonObject.containsKey(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountDeliveringMessageCountGroupFilter() throws Exception {
        String key = new String("key_group");
        long valueGroup1 = RandomUtil.randomLong();
        long valueGroup2 = valueGroup1 + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message1 = this.session.createMessage(false);
        message1.putLongProperty(key, valueGroup1);
        ClientMessage message2 = this.session.createMessage(false);
        message2.putLongProperty(key, valueGroup2);
        producer.send((Message)message1);
        producer.send((Message)message2);
        producer.send((Message)message1);
        this.session.commit();
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(key + " =" + valueGroup1, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertTrue((boolean)jsonObject.isEmpty());
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assert.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(key + " =" + valueGroup1, key);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)2L, (long)jsonObject.getInt(String.valueOf(valueGroup1)));
        Assert.assertFalse((boolean)jsonObject.containsKey((Object)String.valueOf(valueGroup2)));
        Assert.assertFalse((boolean)jsonObject.containsKey(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountMessagesWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)matchingMessage);
        producer.send((Message)unmatchingMessage);
        producer.send((Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)3L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 3L, this.durable);
        Assert.assertEquals((long)2L, (long)queueControl.countMessages(key + " =" + matchingValue));
        Assert.assertEquals((long)1L, (long)queueControl.countMessages(key + " =" + unmatchingValue));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountMessagesWithInvalidFilter() throws Exception {
        ClientMessage msg;
        int i;
        SimpleString key = new SimpleString("key");
        String matchingValue = "MATCH";
        String nonMatchingValue = "DIFFERENT";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (i = 0; i < 100; ++i) {
            msg = this.session.createMessage(this.durable);
            msg.putStringProperty(key, SimpleString.toSimpleString((String)matchingValue));
            producer.send((Message)msg);
        }
        for (i = 0; i < 10; ++i) {
            msg = this.session.createMessage(this.durable);
            msg.putStringProperty(key, SimpleString.toSimpleString((String)nonMatchingValue));
            producer.send((Message)msg);
        }
        this.session.commit();
        ClientConsumer consumer = this.session.createConsumer(queue, SimpleString.toSimpleString((String)"nonExistentProperty like '%Temp/88'"));
        this.session.start();
        QueueControlTest.assertNull((Object)consumer.receiveImmediate());
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 110L, this.durable);
        Assert.assertEquals((long)0L, (long)queueControl.countMessages("nonExistentProperty like '%Temp/88'"));
        Assert.assertEquals((long)100L, (long)queueControl.countMessages(key + "='" + matchingValue + "'"));
        Assert.assertEquals((long)10L, (long)queueControl.countMessages(key + " = '" + nonMatchingValue + "'"));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountMessagesPropertyExist() throws Exception {
        ClientMessage msg;
        int i;
        String key = new String("key_group");
        String valueGroup1 = "group_1";
        String valueGroup2 = "group_2";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (i = 0; i < 100; ++i) {
            msg = this.session.createMessage(false);
            if (i % 3 == 0) {
                msg.putStringProperty(key, valueGroup1);
            } else {
                msg.putStringProperty(key, valueGroup2);
            }
            producer.send((Message)msg);
        }
        for (i = 0; i < 20; ++i) {
            msg = this.session.createMessage(false);
            producer.send((Message)msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)120L, (long)this.getMessageCount(queueControl));
        String result = queueControl.countMessages(null, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)34L, (long)jsonObject.getInt(valueGroup1));
        Assert.assertEquals((long)66L, (long)jsonObject.getInt(valueGroup2));
        Assert.assertEquals((long)20L, (long)jsonObject.getInt("null"));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCountMessagesPropertyWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.session.createMessage(false);
            msg.putStringProperty(RandomUtil.randomString(), RandomUtil.randomString());
            producer.send((Message)msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)100L, (long)this.getMessageCount(queueControl));
        String result = queueControl.countMessages(null, null);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assert.assertEquals((long)100L, (long)jsonObject.getInt("null"));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testExpireMessagesWithFilter() throws Exception {
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)2L, (long)this.getMessageCount(queueControl));
        int expiredMessagesCount = queueControl.expireMessages(key + " =" + matchingValue);
        Assert.assertEquals((long)1L, (long)expiredMessagesCount);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assert.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
        this.session.close();
    }

    @Test
    public void testExpireMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiryAddress = RandomUtil.randomSimpleString();
        SimpleString expiryQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(expiryQueue).setAddress(expiryAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl expiryQueueControl = this.createManagementControl(expiryAddress, expiryQueue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(expiryQueueControl, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        boolean expired = queueControl.expireMessage(messageID);
        Assert.assertTrue((boolean)expired);
        Thread.sleep(200L);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.assertMessageMetrics(expiryQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(0, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, expiryQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(expiryQueue);
        this.session.close();
    }

    @Test
    public void testSendMessageToDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString deadLetterQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(new QueueConfiguration(deadLetterQueue).setAddress(deadLetterAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl deadLetterQueueControl = this.createManagementControl(deadLetterAddress, deadLetterQueue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)2L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(deadLetterAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assert.assertEquals((long)0L, (long)this.getMessageCount(deadLetterQueueControl));
        boolean movedToDeadLetterAddress = queueControl.sendMessageToDeadLetterAddress(messageID);
        Assert.assertTrue((boolean)movedToDeadLetterAddress);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Thread.sleep(200L);
        this.assertMessageMetrics(deadLetterQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, deadLetterQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(deadLetterQueue);
    }

    @Test
    public void testChangeMessagePriority() throws Exception {
        byte originalPriority = 1;
        int newPriority = 8;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.setPriority(originalPriority);
        producer.send((Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean priorityChanged = queueControl.changeMessagePriority(messageID, newPriority);
        Assert.assertTrue((boolean)priorityChanged);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)newPriority, (long)m.getPriority());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testChangeMessagePriorityWithInvalidValue() throws Exception {
        byte invalidPriority = 23;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        try {
            queueControl.changeMessagePriority(messageID, (int)invalidPriority);
            Assert.fail((String)"operation fails when priority value is < 0 or > 9");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((invalidPriority != m.getPriority() ? (byte)1 : 0) != 0);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessageCounter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(99999L);
        String jsonString = queueControl.listMessageCounter();
        MessageCounterInfo info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)0L, (long)info.getDepth());
        Assert.assertEquals((long)0L, (long)info.getCount());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertTrue(() -> this.server.locateQueue(queue).getMessageCount() == 1L);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)1L, (long)info.getDepth());
        Assert.assertEquals((long)1L, (long)info.getDepthDelta());
        Assert.assertEquals((long)1L, (long)info.getCount());
        Assert.assertEquals((long)1L, (long)info.getCountDelta());
        Assert.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAddTimestamp());
        Assert.assertEquals((Object)NULL_DATE, (Object)info.getLastAckTimestamp());
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertTrue(() -> this.server.locateQueue(queue).getMessageCount() == 2L);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)2L, (long)info.getDepth());
        Assert.assertEquals((long)1L, (long)info.getDepthDelta());
        Assert.assertEquals((long)2L, (long)info.getCount());
        Assert.assertEquals((long)1L, (long)info.getCountDelta());
        Assert.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAddTimestamp());
        Assert.assertEquals((Object)NULL_DATE, (Object)info.getLastAckTimestamp());
        QueueControlTest.consumeMessages(2, this.session, queue);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)0L, (long)info.getDepth());
        Assert.assertEquals((long)-2L, (long)info.getDepthDelta());
        Assert.assertEquals((long)2L, (long)info.getCount());
        Assert.assertEquals((long)0L, (long)info.getCountDelta());
        Assert.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAckTimestamp());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testResetMessageCounter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(1000L);
        String jsonString = queueControl.listMessageCounter();
        MessageCounterInfo info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)0L, (long)info.getDepth());
        Assert.assertEquals((long)0L, (long)info.getCount());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)1L, (long)info.getDepth());
        Assert.assertEquals((long)1L, (long)info.getDepthDelta());
        Assert.assertEquals((long)1L, (long)info.getCount());
        Assert.assertEquals((long)1L, (long)info.getCountDelta());
        QueueControlTest.consumeMessages(1, this.session, queue);
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)0L, (long)info.getDepth());
        Assert.assertEquals((long)-1L, (long)info.getDepthDelta());
        Assert.assertEquals((long)1L, (long)info.getCount());
        Assert.assertEquals((long)0L, (long)info.getCountDelta());
        queueControl.resetMessageCounter();
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)0L, (long)info.getDepth());
        Assert.assertEquals((long)0L, (long)info.getDepthDelta());
        Assert.assertEquals((long)0L, (long)info.getCount());
        Assert.assertEquals((long)0L, (long)info.getCountDelta());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessageCounterAsHTML() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        String history = queueControl.listMessageCounterAsHTML();
        Assert.assertNotNull((Object)history);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessageCounterHistory() throws Exception {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(counterPeriod);
        String jsonString = queueControl.listMessageCounterHistory();
        DayCounterInfo[] infos = DayCounterInfo.fromJSON((String)jsonString);
        Assert.assertEquals((long)1L, (long)infos.length);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testListMessageCounterHistoryAsHTML() throws Exception {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(counterPeriod);
        String history = queueControl.listMessageCounterHistoryAsHTML();
        Assert.assertNotNull((Object)history);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMoveMessagesBack() throws Exception {
        this.server.createQueue(new QueueConfiguration(new SimpleString("q1")).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(new QueueConfiguration(new SimpleString("q2")).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true);
        ClientProducer prod1 = session.createProducer("q1");
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = session.createMessage(this.durable);
            msg.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, new SimpleString("dupl-" + i));
            prod1.send((Message)msg);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer("q1", true);
        session.start();
        QueueControlTest.assertNotNull((Object)consumer.receive(5000L));
        consumer.close();
        QueueControl q1Control = ManagementControlHelper.createQueueControl(new SimpleString("q1"), new SimpleString("q1"), this.mbeanServer);
        QueueControl q2Control = ManagementControlHelper.createQueueControl(new SimpleString("q2"), new SimpleString("q2"), this.mbeanServer);
        QueueControlTest.assertEquals((long)10L, (long)q1Control.moveMessages(null, "q2"));
        consumer = session.createConsumer("q2", true);
        QueueControlTest.assertNotNull((Object)consumer.receive(500L));
        consumer.close();
        q2Control.moveMessages(null, "q1", false);
        session.start();
        consumer = session.createConsumer("q1");
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            QueueControlTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        consumer.close();
        session.deleteQueue("q1");
        session.deleteQueue("q2");
        session.close();
        locator.close();
    }

    @Test
    public void testMoveMessagesBack2() throws Exception {
        ClientMessage msg;
        int i;
        this.server.createQueue(new QueueConfiguration(new SimpleString("q1")).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(new QueueConfiguration(new SimpleString("q2")).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true);
        ClientProducer prod1 = session.createProducer("q1");
        int NUMBER_OF_MSGS = 10;
        for (int i2 = 0; i2 < NUMBER_OF_MSGS; ++i2) {
            ClientMessage msg2 = session.createMessage(this.durable);
            msg2.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, new SimpleString("dupl-" + i2));
            prod1.send((Message)msg2);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer("q1", true);
        session.start();
        QueueControlTest.assertNotNull((Object)consumer.receive(5000L));
        consumer.close();
        QueueControl q1Control = ManagementControlHelper.createQueueControl(new SimpleString("q1"), new SimpleString("q1"), this.mbeanServer);
        QueueControl q2Control = ManagementControlHelper.createQueueControl(new SimpleString("q2"), new SimpleString("q2"), this.mbeanServer);
        QueueControlTest.assertEquals((long)NUMBER_OF_MSGS, (long)q1Control.moveMessages(null, "q2"));
        long[] messageIDs = new long[NUMBER_OF_MSGS];
        consumer = session.createConsumer("q2", true);
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            msg = consumer.receive(5000L);
            QueueControlTest.assertNotNull((Object)msg);
            messageIDs[i] = msg.getMessageID();
        }
        QueueControlTest.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            q2Control.moveMessage(messageIDs[i], "q1");
        }
        session.start();
        consumer = session.createConsumer("q1");
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            msg = consumer.receive(5000L);
            QueueControlTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        consumer.close();
        session.deleteQueue("q1");
        session.deleteQueue("q2");
        session.close();
    }

    @Test
    public void testPauseAndResume() {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        try {
            this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            QueueControl queueControl = this.createManagementControl(address, queue);
            ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
            serverControl.enableMessageCounters();
            serverControl.setMessageCounterSamplePeriod(counterPeriod);
            Assert.assertFalse((boolean)queueControl.isPaused());
            queueControl.pause();
            Assert.assertTrue((boolean)queueControl.isPaused());
            queueControl.resume();
            Assert.assertFalse((boolean)queueControl.isPaused());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testResetMessagesAdded() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)this.getMessagesAdded(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)1L, () -> this.getMessagesAdded(queueControl));
        producer.send((Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        queueControl.resetMessagesAdded();
        Wait.assertEquals((long)0L, () -> this.getMessagesAdded(queueControl));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testResetMessagesAcknowledged() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Assert.assertEquals((long)1L, (long)queueControl.getMessagesAcknowledged());
        producer.send((Message)this.session.createMessage(this.durable));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Assert.assertEquals((long)2L, (long)queueControl.getMessagesAcknowledged());
        queueControl.resetMessagesAcknowledged();
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testResetMessagesExpired() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((Message)message);
        Wait.assertEquals((int)1, () -> queueControl.listMessages(null).length);
        Map[] messages = queueControl.listMessages(null);
        long messageID = (Long)messages[0].get("messageID");
        queueControl.expireMessage(messageID);
        Assert.assertEquals((long)1L, (long)queueControl.getMessagesExpired());
        message = this.session.createMessage(this.durable);
        producer.send((Message)message);
        Queue serverqueue = this.server.locateQueue(queue);
        Wait.assertEquals((long)1L, () -> ((Queue)serverqueue).getMessageCount());
        messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        messageID = (Long)messages[0].get("messageID");
        queueControl.expireMessage(messageID);
        Assert.assertEquals((long)2L, (long)queueControl.getMessagesExpired());
        queueControl.resetMessagesExpired();
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testResetMessagesKilled() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((Message)message);
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
        Map[] messages = queueControl.listMessages(null);
        Assert.assertEquals((long)1L, (long)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        queueControl.sendMessageToDeadLetterAddress(messageID);
        Assert.assertEquals((long)1L, (long)queueControl.getMessagesKilled());
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        message = this.session.createMessage(false);
        producer.send((Message)message);
        ClientConsumer consumer = this.session.createConsumer(queue);
        for (int i = 0; i < ((AddressSettings)this.server.getAddressSettingsRepository().getMatch(queue.toString())).getMaxDeliveryAttempts(); ++i) {
            message = consumer.receive(500L);
            QueueControlTest.assertNotNull((Object)message);
            message.acknowledge();
            this.session.rollback();
        }
        consumer.close();
        Assert.assertEquals((long)2L, (long)queueControl.getMessagesKilled());
        queueControl.resetMessagesKilled();
        Assert.assertEquals((long)0L, (long)queueControl.getMessagesKilled());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCreateQueueNotification() throws Exception {
        JMSUtil.JMXListener listener = new JMSUtil.JMXListener();
        this.mbeanServer.addNotificationListener(ObjectNameBuilder.DEFAULT.getActiveMQServerObjectName(), listener, null, null);
        SimpleString testQueueName = new SimpleString("newQueue");
        String testQueueName2 = "newQueue2";
        this.server.createQueue(new QueueConfiguration(testQueueName).setDurable(Boolean.valueOf(this.durable)));
        Notification notif = listener.getNotification();
        QueueControlTest.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notif.getType());
        this.server.destroyQueue(testQueueName);
        notif = listener.getNotification();
        QueueControlTest.assertEquals((Object)CoreNotificationType.BINDING_REMOVED.toString(), (Object)notif.getType());
        ActiveMQServerControl control = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        control.createQueue(new QueueConfiguration(testQueueName2).setRoutingType(RoutingType.MULTICAST).toJSON());
        notif = listener.getNotification();
        QueueControlTest.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notif.getType());
        control.destroyQueue(testQueueName2);
        notif = listener.getNotification();
        QueueControlTest.assertEquals((Object)CoreNotificationType.BINDING_REMOVED.toString(), (Object)notif.getType());
    }

    @Test
    public void testSendMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assert.assertEquals((long)2L, (long)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @Test
    public void testSendMessageWithMessageId() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword", true);
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assert.assertEquals((long)2L, (long)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        String messageID = (String)browse[0].get("userID");
        Assert.assertEquals((long)0L, (long)messageID.length());
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        messageID = (String)browse[1].get("userID");
        Assert.assertTrue((messageID.length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @Test
    public void testSendMessageWithProperties() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("myProp1", "myValue1");
        headers.put("myProp2", "myValue2");
        queueControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assert.assertEquals((long)2L, (long)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        for (Object prop : ((TabularDataSupport)browse[0].get("StringProperties")).values()) {
            CompositeDataSupport cds = (CompositeDataSupport)prop;
            Assert.assertTrue((boolean)headers.containsKey(cds.get("key")));
            Assert.assertTrue((boolean)headers.containsValue(cds.get("value")));
        }
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @Test
    public void testBrowseLimitOnListBrowseAndFilteredCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementBrowsePageSize(5);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)this.session.createMessage(true));
        }
        producer.close();
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getMessageCount());
        QueueControlTest.assertEquals((long)5L, (long)queueControl.browse().length);
        QueueControlTest.assertEquals((long)5L, (long)queueControl.listMessages("").length);
        JsonArray array = JsonUtil.readJsonArray((String)queueControl.listMessagesAsJSON(""));
        QueueControlTest.assertEquals((long)5L, (long)array.size());
        QueueControlTest.assertEquals((long)5L, (long)queueControl.countMessages("AMQSize > 0"));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testResetGroups() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientConsumer consumer = this.session.createConsumer(queue);
        Assert.assertEquals((long)1L, (long)queueControl.getConsumerCount());
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                QueueControlTest.this.instanceLog.debug((Object)message);
            }
        });
        this.session.start();
        ClientProducer producer = this.session.createProducer(address);
        producer.send(this.session.createMessage(this.durable).putStringProperty(Message.HDR_GROUP_ID, "group1"));
        producer.send(this.session.createMessage(this.durable).putStringProperty(Message.HDR_GROUP_ID, "group2"));
        producer.send(this.session.createMessage(this.durable).putStringProperty(Message.HDR_GROUP_ID, "group3"));
        Wait.assertEquals((int)3, () -> this.getGroupCount(queueControl));
        queueControl.resetGroup("group1");
        Wait.assertEquals((int)2, () -> this.getGroupCount(queueControl));
        producer.send(this.session.createMessage(this.durable).putStringProperty(Message.HDR_GROUP_ID, "group1"));
        Wait.assertEquals((int)3, () -> this.getGroupCount(queueControl));
        queueControl.resetAllGroups();
        Wait.assertEquals((int)0, () -> this.getGroupCount(queueControl));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetScheduledCountOnRemove() throws Exception {
        long delay = Integer.MAX_VALUE;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assert.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        Field queueMemorySizeField = QueueImpl.class.getDeclaredField("queueMemorySize");
        queueMemorySizeField.setAccessible(true);
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        Queue q = binding.getQueue();
        AtomicInteger queueMemorySize1 = (AtomicInteger)queueMemorySizeField.get(q);
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize1.get());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        producer.send((Message)message);
        queueControl.removeAllMessages();
        Assert.assertEquals((long)0L, (long)queueControl.getMessageCount());
        QueueControlTest.assertEquals((long)0L, (long)queueMemorySize1.get());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testRetryMessageWithAutoCreatedResourcesAndOrigRoutingType() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer(adName);
        ClientMessage m = this.createTextMessage(this.session, "Put me on DLQ");
        m.putByteProperty(Message.HDR_ORIG_ROUTING_TYPE, (byte)1);
        producer.send((Message)m);
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        Assert.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        QueueControlTest.assertTrue((clientMessage.getRoutingType() == RoutingType.ANYCAST ? (byte)1 : 0) != 0);
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Test
    public void testRetryMessageReturnedWhenNoOrigQueue() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        clientConsumer.close();
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        this.session.deleteQueue(qName);
        queueControl.retryMessage(messageID);
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        clientConsumer = this.session.createConsumer(dlq);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf, (MBeanServer)this.mbeanServer, (boolean)true));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        this.session = sf.createSession(false, true, false);
        this.session.start();
    }

    protected long getFirstMessageId(QueueControl queueControl) throws Exception {
        JsonArray array = JsonUtil.readJsonArray((String)queueControl.getFirstMessageAsJSON());
        JsonObject object = (JsonObject)array.get(0);
        return object.getJsonNumber("messageID").longValue();
    }

    protected void assertMessageMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getMessageCount(), () -> ((QueueControl)queueControl).getPersistentSize(), () -> ((QueueControl)queueControl).getDurableMessageCount(), () -> ((QueueControl)queueControl).getDurablePersistentSize());
    }

    protected void assertScheduledMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getScheduledCount(), () -> ((QueueControl)queueControl).getScheduledSize(), () -> ((QueueControl)queueControl).getDurableScheduledCount(), () -> ((QueueControl)queueControl).getDurableScheduledSize());
    }

    protected void assertDeliveringMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getDeliveringCount(), () -> ((QueueControl)queueControl).getDeliveringSize(), () -> ((QueueControl)queueControl).getDurableDeliveringCount(), () -> ((QueueControl)queueControl).getDurableDeliveringSize());
    }

    protected void assertMetrics(QueueControl queueControl, long messageCount, boolean durable, Supplier<Number> count, Supplier<Number> size, Supplier<Number> durableCount, Supplier<Number> durableSize) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor(() -> ((Number)count.get()).longValue() == messageCount, (long)3000L, (long)100L));
        if (messageCount > 0L) {
            Assert.assertTrue((boolean)Wait.waitFor(() -> ((Number)size.get()).longValue() > 0L, (long)3000L, (long)100L));
            if (durable) {
                Wait.assertEquals((Long)messageCount, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
                Assert.assertTrue((boolean)Wait.waitFor(() -> ((Number)durableSize.get()).longValue() > 0L, (long)3000L, (long)100L));
            } else {
                Wait.assertEquals((Long)0L, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
                Wait.assertEquals((Long)0L, () -> ((Number)durableSize.get()).longValue(), (long)3000L, (long)100L);
            }
        } else {
            Wait.assertEquals((Long)0L, () -> ((Number)count.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)size.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)durableSize.get()).longValue(), (long)3000L, (long)100L);
        }
    }
}

