/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.tests.integration.openwire.amq.ProducerFlowControlBaseTest;
import org.junit.Test;

public class ProducerFlowControlTest
extends ProducerFlowControlBaseTest {
    @Test
    public void test2ndPublisherWithProducerWindowSendConnectionThatIsBlocked() throws Exception {
        this.factory.setProducerWindowSize(65536);
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        Session session = this.flowControlConnection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 1", (Object)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 2", (Object)msg.getText());
        msg.acknowledge();
        consumer.close();
    }

    @Test
    public void testPublisherRecoverAfterBlock() throws Exception {
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        final Session session = this.flowControlConnection.createSession(false, 2);
        final MessageProducer producer = session.createProducer((Destination)this.queueA);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        Thread thread = new Thread("Filler"){
            int i;

            @Override
            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    try {
                        producer.send((Message)session.createTextMessage("Test message " + ++this.i));
                    }
                    catch (JMSException e) {
                        break;
                    }
                }
            }
        };
        thread.start();
        this.waitForBlockedOrResourceLimit(done);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 5; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            msg.acknowledge();
        }
        Thread.sleep(1000L);
        keepGoing.set(false);
        consumer.close();
        ProducerFlowControlTest.assertFalse((String)"producer has resumed", (boolean)done.get());
    }

    @Test
    public void testAsyncPublisherRecoverAfterBlock() throws Exception {
        this.factory.setProducerWindowSize(5120);
        this.factory.setUseAsyncSend(true);
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        final Session session = this.flowControlConnection.createSession(false, 2);
        final MessageProducer producer = session.createProducer((Destination)this.queueA);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        Thread thread = new Thread("Filler"){
            int i;

            @Override
            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    try {
                        producer.send((Message)session.createTextMessage("Test message " + ++this.i));
                    }
                    catch (JMSException jMSException) {}
                }
            }
        };
        thread.start();
        this.waitForBlockedOrResourceLimit(done);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 5; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            ProducerFlowControlTest.assertNotNull((String)"Got a message", (Object)msg);
            msg.acknowledge();
        }
        Thread.sleep(1000L);
        keepGoing.set(false);
        consumer.close();
        ProducerFlowControlTest.assertFalse((String)"producer has resumed", (boolean)done.get());
    }

    @Test
    public void test2ndPublisherWithSyncSendConnectionThatIsBlocked() throws Exception {
        this.factory.setAlwaysSyncSend(true);
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        Session session = this.flowControlConnection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 1", (Object)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 2", (Object)msg.getText());
        msg.acknowledge();
        consumer.close();
    }

    @Test
    public void testSimpleSendReceive() throws Exception {
        this.factory.setAlwaysSyncSend(true);
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        Session session = this.flowControlConnection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        CountDownLatch pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 1", (Object)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((Object)"Message 2", (Object)msg.getText());
        msg.acknowledge();
        consumer.close();
    }

    @Test
    public void test2ndPublisherWithStandardConnectionThatIsBlocked() throws Exception {
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        this.flowControlConnection.start();
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertFalse((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
    }
}

