/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.impl.AbstractPassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.persistence.manager.PassivationPersistenceManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
extends AbstractPassivationManager {
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    CacheNotifier<Object, Object> notifier;
    @Inject
    Configuration cfg;
    @Inject
    InternalDataContainer<Object, Object> container;
    @Inject
    TimeService timeService;
    @Inject
    MarshallableEntryFactory<?, ?> marshalledEntryFactory;
    @Inject
    DistributionManager distributionManager;
    @Inject
    KeyPartitioner keyPartitioner;
    PassivationPersistenceManager passivationPersistenceManager;
    private volatile boolean skipOnStop = false;
    boolean statsEnabled = false;
    volatile boolean enabled = false;
    private final AtomicLong passivations = new AtomicLong(0L);
    private final PersistenceManager.StoreChangeListener listener = pm -> this.updateEnabledStatus(pm.isEnabled(), pm.usingReadOnly());

    @Start(priority=12)
    public void start() {
        this.updateEnabledStatus(this.cfg.persistence().usingStores(), this.persistenceManager.isReadOnly());
        this.persistenceManager.addStoreListener(this.listener);
    }

    @Stop
    public void stop() {
        this.persistenceManager.removeStoreListener(this.listener);
    }

    private void updateEnabledStatus(boolean usingStores, boolean readOnly) {
        boolean bl = this.enabled = !readOnly && this.cfg.persistence().passivation() && usingStores;
        if (this.enabled) {
            this.passivationPersistenceManager = (PassivationPersistenceManager)this.persistenceManager;
            this.statsEnabled = this.cfg.statistics().enabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isL1Key(Object key) {
        return this.distributionManager != null && !this.distributionManager.getCacheTopology().isWriteOwner(key);
    }

    private CompletionStage<Void> doPassivate(Object key, InternalCacheEntry<?, ?> entry) {
        if (log.isTraceEnabled()) {
            log.tracef("Passivating entry %s", Util.toStr((Object)key));
        }
        MarshallableEntry<?, ?> marshalledEntry = this.marshalledEntryFactory.create(entry);
        CompletionStage<Void> stage = this.passivationPersistenceManager.passivate(marshalledEntry, this.keyPartitioner.getSegment(key));
        return stage.handle((v, t) -> {
            if (t != null) {
                Log.CONTAINER.unableToPassivateEntry(key, (Throwable)t);
            }
            if (this.statsEnabled) {
                this.passivations.getAndIncrement();
            }
            return null;
        });
    }

    @Override
    public CompletionStage<Void> passivateAsync(InternalCacheEntry<?, ?> entry) {
        Object key;
        if (this.enabled && entry != null && !this.isL1Key(key = entry.getKey())) {
            if (this.notifier.hasListener(CacheEntryPassivated.class)) {
                return this.notifier.notifyCacheEntryPassivated(key, entry.getValue(), true, ImmutableContext.INSTANCE, null).thenCompose(v -> this.doPassivate(key, entry)).thenCompose(v -> this.notifier.notifyCacheEntryPassivated(key, null, false, ImmutableContext.INSTANCE, null));
            }
            return this.doPassivate(key, entry);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public void passivateAll() throws PersistenceException {
        CompletionStages.join(this.passivateAllAsync());
    }

    @Override
    public CompletionStage<Void> passivateAllAsync() throws PersistenceException {
        if (!this.enabled || this.skipOnStop) {
            return CompletableFutures.completedNull();
        }
        long start = this.timeService.time();
        if (Log.CONTAINER.isDebugEnabled()) {
            Log.CONTAINER.debug("Passivating all entries to disk");
        }
        int count = this.container.sizeIncludingExpired();
        Iterable iterable = () -> new IteratorMapper(this.container.iterator(), e -> this.marshalledEntryFactory.create((InternalCacheEntry<?, ?>)e));
        return this.persistenceManager.writeEntries(iterable, PersistenceManager.AccessMode.PRIVATE).thenRun(() -> {
            long durationMillis = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            if (Log.CONTAINER.isDebugEnabled()) {
                Log.CONTAINER.debugf("Passivated %d entries in %s", count, Util.prettyPrintTime((long)durationMillis));
            }
        });
    }

    @Override
    public void skipPassivationOnStop(boolean skip) {
        this.skipOnStop = skip;
    }

    @Override
    public long getPassivations() {
        return this.passivations.get();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @Override
    public void resetStatistics() {
        this.passivations.set(0L);
    }
}

