/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicResultAssembler<J>
implements DomainResultAssembler<J> {
    private final int valuesArrayPosition;
    private final JavaType<J> assembledJavaType;
    private final BasicValueConverter<J, ?> valueConverter;

    public static <X> BasicResultAssembler<X> from(SqlSelection selection, JavaType<X> javaType) {
        return new BasicResultAssembler<X>(selection.getValuesArrayPosition(), javaType);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaType<J> assembledJavaType) {
        this(valuesArrayPosition, assembledJavaType, null);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaType<J> assembledJavaType, BasicValueConverter<J, ?> valueConverter) {
        this.valuesArrayPosition = valuesArrayPosition;
        this.assembledJavaType = assembledJavaType;
        this.valueConverter = valueConverter;
    }

    public Object extractRawValue(RowProcessingState rowProcessingState) {
        return rowProcessingState.getJdbcValue(this.valuesArrayPosition);
    }

    @Override
    public J assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object jdbcValue = this.extractRawValue(rowProcessingState);
        ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("Extracted JDBC value [%d] - [%s]", this.valuesArrayPosition, jdbcValue);
        if (this.valueConverter != null) {
            if (jdbcValue != null && !this.valueConverter.getRelationalJavaType().getJavaTypeClass().isInstance(jdbcValue)) {
                throw new HibernateException(String.format(Locale.ROOT, "Expecting raw JDBC value of type `%s`, but found `%s` : [%s]", this.valueConverter.getRelationalJavaType().getJavaType().getTypeName(), jdbcValue.getClass().getName(), jdbcValue));
            }
            return this.valueConverter.toDomainValue(jdbcValue);
        }
        return (J)jdbcValue;
    }

    @Override
    public JavaType<J> getAssembledJavaType() {
        if (this.valueConverter != null) {
            return this.valueConverter.getDomainJavaType();
        }
        return this.assembledJavaType;
    }

    @Internal
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }
}

