/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.exec.AbstractScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptSourceInput;

public class ScriptSourceInputAggregate
implements ScriptSourceInput {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaCreatorImpl.class);
    private final AbstractScriptSourceInput[] inputs;

    public ScriptSourceInputAggregate(AbstractScriptSourceInput[] inputs) {
        this.inputs = inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> extract(Function<Reader, List<String>> extractor) {
        List[] lists = new List[this.inputs.length];
        int size = 0;
        for (int i = 0; i < this.inputs.length; ++i) {
            AbstractScriptSourceInput scriptSourceInput = this.inputs[i];
            Reader reader = scriptSourceInput.prepareReader();
            try {
                log.executingImportScript(scriptSourceInput.getScriptDescription());
                lists[i] = extractor.apply(reader);
                size += lists[i].size();
                continue;
            }
            finally {
                scriptSourceInput.releaseReader(reader);
            }
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (List strings : lists) {
            list.addAll(strings);
        }
        return list;
    }

    public String toString() {
        return "ScriptSourceInputAggregate(" + Arrays.toString(this.inputs) + ")";
    }
}

